/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public class FloatUtil {
    private static final int DOUBLE_FRACTION_WIDTH = 52;
    private static final int DOUBLE_PRECISION = 53;
    private static final int MAX_DOUBLE_EXPONENT = 1023;
    private static final int MIN_NORMALIZED_DOUBLE_EXPONENT = -1022;
    private static final int MIN_UNNORMALIZED_DOUBLE_EXPONENT = -1075;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final int DOUBLE_EXPONENT_SHIFT = 52;
    private static final int SINGLE_FRACTION_WIDTH = 23;
    private static final int SINGLE_PRECISION = 24;
    private static final int MAX_SINGLE_EXPONENT = 127;
    private static final int MIN_NORMALIZED_SINGLE_EXPONENT = -126;
    private static final int MIN_UNNORMALIZED_SINGLE_EXPONENT = -150;
    private static final int SINGLE_EXPONENT_BIAS = 127;
    private static final int SINGLE_EXPONENT_SHIFT = 23;

    public static float valueOfHexFloatLiteral(char[] cArray) {
        long l = FloatUtil.convertHexFloatingPointLiteralToBits(cArray);
        return Float.intBitsToFloat((int)l);
    }

    public static double valueOfHexDoubleLiteral(char[] cArray) {
        long l = FloatUtil.convertHexFloatingPointLiteralToBits(cArray);
        return Double.longBitsToDouble(l);
    }

    private static long convertHexFloatingPointLiteralToBits(char[] cArray) {
        int n;
        long l;
        int n2;
        int n3;
        int n4;
        int n5 = cArray.length;
        long l2 = 0L;
        int n6 = 0;
        char c = cArray[n6];
        c = cArray[n6];
        if (c != '0') {
            throw new NumberFormatException();
        }
        c = cArray[++n6];
        if (c == 'X' || c == 'x') {
            ++n6;
        } else {
            throw new NumberFormatException();
        }
        int n7 = -1;
        block19: while (true) {
            c = cArray[n6];
            switch (c) {
                case '0': {
                    ++n6;
                    continue block19;
                }
                case '.': {
                    n7 = n6++;
                    continue block19;
                }
            }
            break;
        }
        int n8 = 0;
        int n9 = -1;
        block20: while (true) {
            c = cArray[n6];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n4 = c - 48;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    n4 = c - 97 + 10;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n4 = c - 65 + 10;
                    break;
                }
                case '.': {
                    n7 = n6++;
                    continue block20;
                }
                default: {
                    if (n7 >= 0) break block20;
                    n7 = n6;
                    break block20;
                }
            }
            if (n8 == 0) {
                n9 = n6;
                l2 = n4;
                n8 = 4;
            } else if (n8 < 60) {
                l2 <<= 4;
                l2 |= (long)n4;
                n8 += 4;
            }
            ++n6;
        }
        if ((c = cArray[n6]) == 'P' || c == 'p') {
            ++n6;
        } else {
            throw new NumberFormatException();
        }
        n4 = 0;
        int n10 = 1;
        block21: while (n6 < n5) {
            c = cArray[n6];
            switch (c) {
                case '+': {
                    n10 = 1;
                    ++n6;
                    continue block21;
                }
                case '-': {
                    n10 = -1;
                    ++n6;
                    continue block21;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n3 = c - 48;
                    n4 = n4 * 10 + n3;
                    ++n6;
                    continue block21;
                }
            }
        }
        n3 = 1;
        if (n6 < n5) {
            c = cArray[n6];
            switch (c) {
                case 'F': 
                case 'f': {
                    n3 = 0;
                    ++n6;
                    break;
                }
                case 'D': 
                case 'd': {
                    n3 = 1;
                    ++n6;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
        }
        if (l2 == 0L) {
            return 0L;
        }
        int n11 = 0;
        long l3 = l2 >>> n8 - 4;
        if ((l3 & 8L) == 0L) {
            --n8;
            ++n11;
            if ((l3 & 4L) == 0L) {
                --n8;
                ++n11;
                if ((l3 & 2L) == 0L) {
                    --n8;
                    ++n11;
                }
            }
        }
        long l4 = 0L;
        if (n3 != 0) {
            int n12;
            long l5;
            int n13;
            if (n8 > 53) {
                n13 = n8 - 53;
                l5 = l2 >>> n13 - 1;
                long l6 = l5 & 1L;
                l5 += l6;
                if (((l5 >>>= 1) & 0x20000000000000L) != 0L) {
                    l5 >>>= 1;
                    --n11;
                }
            } else {
                l5 = l2 << 53 - n8;
            }
            n13 = 0;
            if (n8 > 0) {
                if (n9 < n7) {
                    n13 = 4 * (n7 - n9);
                    n13 -= n11;
                } else {
                    n13 = -4 * (n9 - n7 - 1);
                    n13 -= n11;
                }
            }
            if ((n12 = n10 * n4 + n13) - 1 > 1023) {
                l4 = Double.doubleToLongBits(Double.POSITIVE_INFINITY);
            } else if (n12 - 1 >= -1022) {
                long l7 = n12 - 1 + 1023;
                l4 = l5 & 0xFFEFFFFFFFFFFFFFL;
                l4 |= l7 << 52;
            } else if (n12 - 1 > -1075) {
                long l8 = 0L;
                l4 = l5 >>> -1022 - n12 + 1;
                l4 |= l8 << 52;
            } else {
                l4 = Double.doubleToLongBits(Double.NaN);
            }
            return l4;
        }
        if (n8 > 24) {
            n2 = n8 - 24;
            l = l2 >>> n2 - 1;
            long l9 = l & 1L;
            l += l9;
            if (((l >>>= 1) & 0x1000000L) != 0L) {
                l >>>= 1;
                --n11;
            }
        } else {
            l = l2 << 24 - n8;
        }
        n2 = 0;
        if (n8 > 0) {
            if (n9 < n7) {
                n2 = 4 * (n7 - n9);
                n2 -= n11;
            } else {
                n2 = -4 * (n9 - n7 - 1);
                n2 -= n11;
            }
        }
        if ((n = n10 * n4 + n2) - 1 > 127) {
            l4 = Float.floatToIntBits(Float.POSITIVE_INFINITY);
        } else if (n - 1 >= -126) {
            long l10 = n - 1 + 127;
            l4 = l & 0xFFFFFFFFFF7FFFFFL;
            l4 |= l10 << 23;
        } else if (n - 1 > -150) {
            long l11 = 0L;
            l4 = l >>> -126 - n + 1;
            l4 |= l11 << 23;
        } else {
            l4 = Float.floatToIntBits(Float.NaN);
        }
        return l4;
    }
}

