/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022_JP;
import sun.nio.cs.ext.SJIS;
import sun.security.action.GetPropertyAction;

public class JISAutoDetect
extends Charset
implements HistoricallyNamedCharset {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;

    public JISAutoDetect() {
        super("x-JISAutoDetect", ExtendedCharsets.aliasesFor("x-JISAutoDetect"));
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof SJIS || cs instanceof EUC_JP || cs instanceof ISO2022_JP;
    }

    @Override
    public boolean canEncode() {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public String historicalName() {
        return "JISAutoDetect";
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    public static byte[] getByteMask1() {
        return Decoder.maskTable1;
    }

    public static byte[] getByteMask2() {
        return Decoder.maskTable2;
    }

    public static final boolean canBeSJIS1B(int mask) {
        return (mask & 4) != 0;
    }

    public static final boolean canBeEUCJP(int mask) {
        return (mask & 1) != 0;
    }

    public static final boolean canBeEUCKana(int mask1, int mask2) {
        return (mask1 & 8) != 0 && (mask2 & 0x10) != 0;
    }

    private static boolean looksLikeJapanese(CharBuffer cb) {
        int hiragana = 0;
        int katakana = 0;
        while (cb.hasRemaining()) {
            char c = cb.get();
            if ('\u3040' <= c && c <= '\u309f' && ++hiragana > 1) {
                return true;
            }
            if ('\uff65' > c || c > '\uff9f' || ++katakana <= 1) continue;
            return true;
        }
        return false;
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final String SJISName = Decoder.getSJISName();
        private static final String EUCJPName = Decoder.getEUCJPName();
        private DelegatableDecoder detectedDecoder = null;
        private static final byte[] maskTable1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 5, 5, 5, 13, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};
        private static final byte[] maskTable2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};

        public Decoder(Charset cs) {
            super(cs, 0.5f, 1.0f);
        }

        private static boolean isPlainASCII(byte b) {
            return b >= 0 && b != 27;
        }

        private static void copyLeadingASCII(ByteBuffer src, CharBuffer dst) {
            byte b;
            int p;
            int start = src.position();
            int limit = start + Math.min(src.remaining(), dst.remaining());
            for (p = start; p < limit && Decoder.isPlainASCII(b = src.get(p)); ++p) {
                dst.put((char)(b & 0xFF));
            }
            src.position(p);
        }

        private CoderResult decodeLoop(Charset cs, ByteBuffer src, CharBuffer dst) {
            this.detectedDecoder = (DelegatableDecoder)((Object)cs.newDecoder());
            return this.detectedDecoder.decodeLoop(src, dst);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (this.detectedDecoder == null) {
                CharBuffer sandboxSJIS;
                ByteBuffer srcSJIS;
                ByteBuffer src2022;
                Decoder.copyLeadingASCII(src, dst);
                if (!src.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!dst.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                int cbufsiz = (int)((double)src.limit() * (double)this.maxCharsPerByte());
                CharBuffer sandbox = CharBuffer.allocate(cbufsiz);
                Charset cs2022 = Charset.forName("ISO-2022-JP");
                DelegatableDecoder dd2022 = (DelegatableDecoder)((Object)cs2022.newDecoder());
                CoderResult res2022 = dd2022.decodeLoop(src2022 = src.asReadOnlyBuffer(), sandbox);
                if (!res2022.isError()) {
                    return this.decodeLoop(cs2022, src, dst);
                }
                Charset csEUCJ = Charset.forName(EUCJPName);
                Charset csSJIS = Charset.forName(SJISName);
                DelegatableDecoder ddEUCJ = (DelegatableDecoder)((Object)csEUCJ.newDecoder());
                ByteBuffer srcEUCJ = src.asReadOnlyBuffer();
                sandbox.clear();
                CoderResult resEUCJ = ddEUCJ.decodeLoop(srcEUCJ, sandbox);
                if (resEUCJ.isError()) {
                    return this.decodeLoop(csSJIS, src, dst);
                }
                DelegatableDecoder ddSJIS = (DelegatableDecoder)((Object)csSJIS.newDecoder());
                CoderResult resSJIS = ddSJIS.decodeLoop(srcSJIS = src.asReadOnlyBuffer(), sandboxSJIS = CharBuffer.allocate(cbufsiz));
                if (resSJIS.isError()) {
                    return this.decodeLoop(csEUCJ, src, dst);
                }
                if (srcEUCJ.position() > srcSJIS.position()) {
                    return this.decodeLoop(csEUCJ, src, dst);
                }
                if (srcEUCJ.position() < srcSJIS.position()) {
                    return this.decodeLoop(csSJIS, src, dst);
                }
                if (src.position() == srcEUCJ.position()) {
                    return CoderResult.UNDERFLOW;
                }
                sandbox.flip();
                Charset guess = JISAutoDetect.looksLikeJapanese(sandbox) ? csEUCJ : csSJIS;
                return this.decodeLoop(guess, src, dst);
            }
            return this.detectedDecoder.decodeLoop(src, dst);
        }

        @Override
        protected void implReset() {
            this.detectedDecoder = null;
        }

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            if (this.detectedDecoder != null) {
                return this.detectedDecoder.implFlush(out);
            }
            return super.implFlush(out);
        }

        @Override
        public boolean isAutoDetecting() {
            return true;
        }

        @Override
        public boolean isCharsetDetected() {
            return this.detectedDecoder != null;
        }

        @Override
        public Charset detectedCharset() {
            if (this.detectedDecoder == null) {
                throw new IllegalStateException("charset not yet detected");
            }
            return ((CharsetDecoder)((Object)this.detectedDecoder)).charset();
        }

        private static String getSJISName() {
            String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (osName.equals("Solaris") || osName.equals("SunOS")) {
                return "PCK";
            }
            if (osName.startsWith("Windows")) {
                return "windows-31J";
            }
            return "Shift_JIS";
        }

        private static String getEUCJPName() {
            String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (osName.equals("Solaris") || osName.equals("SunOS")) {
                return "x-eucjp-open";
            }
            return "EUC_JP";
        }
    }
}

