/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.model.Pair;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingUtils {
    public static Pair<Integer, Class> loadClass(File file, String name) {
        int status = 0;
        Class value = Object.class;
        if (!file.exists()) {
            status = 1;
        } else {
            try {
                URLClassLoader classloader = new URLClassLoader(new URL[]{file.toURI().toURL()}, ClassLoadingUtils.class.getClassLoader());
                value = Class.forName(name, true, classloader);
            }
            catch (MalformedURLException nothandled1) {
                status = 2;
            }
            catch (ClassNotFoundException nothandled2) {
                status = 3;
            }
        }
        return new Pair<Integer, Class>(status, value);
    }

    public static Pair<Integer, Object> loadObject(File file, String name) {
        Pair<Integer, Class> pair = ClassLoadingUtils.loadClass(file, name);
        int status = pair.getFirstElement();
        Object value = new Object();
        if (status == 0) {
            try {
                value = pair.getSecondElement().newInstance();
            }
            catch (IllegalAccessException nothandled1) {
                status = 4;
            }
            catch (InstantiationException nothandled2) {
                status = 5;
            }
        }
        return new Pair<Integer, Object>(status, value);
    }
}

