/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gephi.appearance.PartitionImpl;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Index;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.types.TimeMap;

public class AttributePartitionImpl
extends PartitionImpl {
    protected final Graph graph;
    protected final Index index;
    protected final Column column;
    protected final Map<Object, Integer> parts;
    protected int elements;

    public AttributePartitionImpl(Column column, Index index) {
        this.column = column;
        this.index = index;
        this.graph = null;
        this.parts = null;
    }

    public AttributePartitionImpl(Column column, Graph graph) {
        this.column = column;
        this.index = null;
        this.graph = graph;
        this.parts = new HashMap<Object, Integer>();
    }

    @Override
    protected void refresh() {
        if (this.graph != null) {
            this.parts.clear();
            this.elements = 0;
            NodeIterable iterable = AttributeUtils.isNodeColumn((Column)this.column) ? this.graph.getNodes() : this.graph.getEdges();
            for (Element el : iterable) {
                Object[] va;
                TimeMap val = (TimeMap)el.getAttribute(this.column);
                if (val == null) continue;
                for (Object v : va = val.toValuesArray()) {
                    Integer count = this.parts.get(v);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    this.parts.put(v, count);
                    ++this.elements;
                }
            }
        }
    }

    @Override
    public Object getValue(Element element, Graph gr) {
        if (this.graph != null) {
            TimeMap val = (TimeMap)element.getAttribute(this.column);
            if (val != null) {
                return val.get(gr.getView().getTimeInterval(), Estimator.FIRST);
            }
            return null;
        }
        return element.getAttribute(this.column);
    }

    @Override
    public Collection getValues() {
        if (this.index != null) {
            return this.index.values(this.column);
        }
        return this.parts.keySet();
    }

    @Override
    public int getElementCount() {
        if (this.index != null) {
            return this.index.countElements(this.column);
        }
        return this.elements;
    }

    @Override
    public int count(Object value) {
        if (this.index != null) {
            return this.index.count(this.column, value);
        }
        Integer c = this.parts.get(value);
        return c != null ? c : 0;
    }

    @Override
    public float percentage(Object value) {
        if (this.index != null) {
            int count = this.index.count(this.column, value);
            return 100.0f * ((float)count / (float)this.index.countElements(this.column));
        }
        Integer c = this.parts.get(value);
        return 100.0f * (c != null ? c.floatValue() / (float)this.elements : 0.0f);
    }

    @Override
    public int size() {
        if (this.index != null) {
            return this.index.countValues(this.column);
        }
        return this.parts.size();
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.column != null ? this.column.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributePartitionImpl other = (AttributePartitionImpl)obj;
        return this.column == other.column || this.column != null && this.column.equals(other.column);
    }
}

