/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterPajek;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterPajekPanel;
import org.openide.util.NbBundle;

public class UIExporterPajek
implements ExporterUI {
    private UIExporterPajekPanel panel;
    private ExporterPajek exporterPajek;
    private ExporterPajekSettings settings = new ExporterPajekSettings();

    public void setup(Exporter exporter) {
        this.exporterPajek = (ExporterPajek)exporter;
        this.settings.load(this.exporterPajek);
        this.panel.setup(this.exporterPajek);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterPajek);
            this.settings.save(this.exporterPajek);
        }
        this.panel = null;
        this.exporterPajek = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterPajekPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterPajek;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPajek.class, (String)"UIExporterPajek.name");
    }

    private static class ExporterPajekSettings {
        private boolean exportPosition = true;
        private boolean exportEdgeWeight = true;

        private ExporterPajekSettings() {
        }

        private void save(ExporterPajek exporterPajek) {
            this.exportPosition = exporterPajek.isExportPosition();
            this.exportEdgeWeight = exporterPajek.isExportEdgeWeight();
        }

        private void load(ExporterPajek exporterPajek) {
            exporterPajek.setExportPosition(this.exportPosition);
            exporterPajek.setExportEdgeWeight(this.exportEdgeWeight);
        }
    }
}

