/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.util.Removal;

public class HSSFColor
implements org.apache.poi.ss.usermodel.Color {
    private static Map<Integer, HSSFColor> indexHash;
    private static Map<HSSFColorPredefined, HSSFColor> enumList;
    private Color color;
    private int index;
    private int index2;

    public HSSFColor() {
        this(64, -1, Color.BLACK);
    }

    public HSSFColor(int index, int index2, Color color) {
        this.index = index;
        this.index2 = index2;
        this.color = color;
    }

    public static final synchronized Map<Integer, HSSFColor> getIndexHash() {
        if (indexHash == null) {
            indexHash = Collections.unmodifiableMap(HSSFColor.createColorsByIndexMap());
        }
        return indexHash;
    }

    public static final Map<Integer, HSSFColor> getMutableIndexHash() {
        return HSSFColor.createColorsByIndexMap();
    }

    private static Map<Integer, HSSFColor> createColorsByIndexMap() {
        Map<HSSFColorPredefined, HSSFColor> eList = HSSFColor.mapEnumToColorClass();
        HashMap<Integer, HSSFColor> result = new HashMap<Integer, HSSFColor>(eList.size() * 3 / 2);
        for (Map.Entry<HSSFColorPredefined, HSSFColor> colorRef : eList.entrySet()) {
            Integer index2;
            Integer index1 = colorRef.getKey().getIndex();
            if (!result.containsKey(index1)) {
                result.put(index1, colorRef.getValue());
            }
            if ((index2 = Integer.valueOf(colorRef.getKey().getIndex2())) == -1 || result.containsKey(index2)) continue;
            result.put(index2, colorRef.getValue());
        }
        return result;
    }

    public static Map<String, HSSFColor> getTripletHash() {
        return HSSFColor.createColorsByHexStringMap();
    }

    private static Map<String, HSSFColor> createColorsByHexStringMap() {
        Map<HSSFColorPredefined, HSSFColor> eList = HSSFColor.mapEnumToColorClass();
        HashMap<String, HSSFColor> result = new HashMap<String, HSSFColor>(eList.size());
        for (Map.Entry<HSSFColorPredefined, HSSFColor> colorRef : eList.entrySet()) {
            String hexString = colorRef.getKey().getHexString();
            if (result.containsKey(hexString)) continue;
            result.put(hexString, colorRef.getValue());
        }
        return result;
    }

    @Deprecated
    @Removal(version="3.18")
    private static synchronized Map<HSSFColorPredefined, HSSFColor> mapEnumToColorClass() {
        if (enumList == null) {
            enumList = new EnumMap<HSSFColorPredefined, HSSFColor>(HSSFColorPredefined.class);
            enumList.put(HSSFColorPredefined.BLACK, new BLACK());
            enumList.put(HSSFColorPredefined.BROWN, new BROWN());
            enumList.put(HSSFColorPredefined.OLIVE_GREEN, new OLIVE_GREEN());
            enumList.put(HSSFColorPredefined.DARK_GREEN, new DARK_GREEN());
            enumList.put(HSSFColorPredefined.DARK_TEAL, new DARK_TEAL());
            enumList.put(HSSFColorPredefined.DARK_BLUE, new DARK_BLUE());
            enumList.put(HSSFColorPredefined.INDIGO, new INDIGO());
            enumList.put(HSSFColorPredefined.GREY_80_PERCENT, new GREY_80_PERCENT());
            enumList.put(HSSFColorPredefined.ORANGE, new ORANGE());
            enumList.put(HSSFColorPredefined.DARK_YELLOW, new DARK_YELLOW());
            enumList.put(HSSFColorPredefined.GREEN, new GREEN());
            enumList.put(HSSFColorPredefined.TEAL, new TEAL());
            enumList.put(HSSFColorPredefined.BLUE, new BLUE());
            enumList.put(HSSFColorPredefined.BLUE_GREY, new BLUE_GREY());
            enumList.put(HSSFColorPredefined.GREY_50_PERCENT, new GREY_50_PERCENT());
            enumList.put(HSSFColorPredefined.RED, new RED());
            enumList.put(HSSFColorPredefined.LIGHT_ORANGE, new LIGHT_ORANGE());
            enumList.put(HSSFColorPredefined.LIME, new LIME());
            enumList.put(HSSFColorPredefined.SEA_GREEN, new SEA_GREEN());
            enumList.put(HSSFColorPredefined.AQUA, new AQUA());
            enumList.put(HSSFColorPredefined.LIGHT_BLUE, new LIGHT_BLUE());
            enumList.put(HSSFColorPredefined.VIOLET, new VIOLET());
            enumList.put(HSSFColorPredefined.GREY_40_PERCENT, new GREY_40_PERCENT());
            enumList.put(HSSFColorPredefined.PINK, new PINK());
            enumList.put(HSSFColorPredefined.GOLD, new GOLD());
            enumList.put(HSSFColorPredefined.YELLOW, new YELLOW());
            enumList.put(HSSFColorPredefined.BRIGHT_GREEN, new BRIGHT_GREEN());
            enumList.put(HSSFColorPredefined.TURQUOISE, new TURQUOISE());
            enumList.put(HSSFColorPredefined.DARK_RED, new DARK_RED());
            enumList.put(HSSFColorPredefined.SKY_BLUE, new SKY_BLUE());
            enumList.put(HSSFColorPredefined.PLUM, new PLUM());
            enumList.put(HSSFColorPredefined.GREY_25_PERCENT, new GREY_25_PERCENT());
            enumList.put(HSSFColorPredefined.ROSE, new ROSE());
            enumList.put(HSSFColorPredefined.LIGHT_YELLOW, new LIGHT_YELLOW());
            enumList.put(HSSFColorPredefined.LIGHT_GREEN, new LIGHT_GREEN());
            enumList.put(HSSFColorPredefined.LIGHT_TURQUOISE, new LIGHT_TURQUOISE());
            enumList.put(HSSFColorPredefined.PALE_BLUE, new PALE_BLUE());
            enumList.put(HSSFColorPredefined.LAVENDER, new LAVENDER());
            enumList.put(HSSFColorPredefined.WHITE, new WHITE());
            enumList.put(HSSFColorPredefined.CORNFLOWER_BLUE, new CORNFLOWER_BLUE());
            enumList.put(HSSFColorPredefined.LEMON_CHIFFON, new LEMON_CHIFFON());
            enumList.put(HSSFColorPredefined.MAROON, new MAROON());
            enumList.put(HSSFColorPredefined.ORCHID, new ORCHID());
            enumList.put(HSSFColorPredefined.CORAL, new CORAL());
            enumList.put(HSSFColorPredefined.ROYAL_BLUE, new ROYAL_BLUE());
            enumList.put(HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE, new LIGHT_CORNFLOWER_BLUE());
            enumList.put(HSSFColorPredefined.TAN, new TAN());
        }
        return enumList;
    }

    public short getIndex() {
        return (short)this.index;
    }

    public short getIndex2() {
        return (short)this.index2;
    }

    public short[] getTriplet() {
        return new short[]{(short)this.color.getRed(), (short)this.color.getGreen(), (short)this.color.getBlue()};
    }

    public String getHexString() {
        return (Integer.toHexString(this.color.getRed() * 257) + ":" + Integer.toHexString(this.color.getGreen() * 257) + ":" + Integer.toHexString(this.color.getBlue() * 257)).toUpperCase(Locale.ROOT);
    }

    public static HSSFColor toHSSFColor(org.apache.poi.ss.usermodel.Color color) {
        if (color != null && !(color instanceof HSSFColor)) {
            throw new IllegalArgumentException("Only HSSFColor objects are supported");
        }
        return (HSSFColor)color;
    }

    @Deprecated
    @Removal(version="3.18")
    public static class AUTOMATIC
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.AUTOMATIC;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public AUTOMATIC() {
            super(ref);
        }

        public static HSSFColor getInstance() {
            return ref.color;
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIGHT_CORNFLOWER_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIGHT_CORNFLOWER_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class ROYAL_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.ROYAL_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public ROYAL_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class CORAL
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.CORAL;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public CORAL() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class ORCHID
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.ORCHID;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public ORCHID() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class MAROON
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.MAROON;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public MAROON() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LEMON_CHIFFON
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LEMON_CHIFFON;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LEMON_CHIFFON() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class CORNFLOWER_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.CORNFLOWER_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public CORNFLOWER_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class WHITE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.WHITE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public WHITE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LAVENDER
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LAVENDER;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LAVENDER() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class PALE_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.PALE_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public PALE_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIGHT_TURQUOISE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIGHT_TURQUOISE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIGHT_TURQUOISE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIGHT_GREEN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIGHT_GREEN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIGHT_GREEN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIGHT_YELLOW
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIGHT_YELLOW;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIGHT_YELLOW() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class TAN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.TAN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public TAN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class ROSE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.ROSE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public ROSE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class GREY_25_PERCENT
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.GREY_25_PERCENT;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public GREY_25_PERCENT() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class PLUM
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.PLUM;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public PLUM() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class SKY_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.SKY_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public SKY_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class TURQUOISE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.TURQUOISE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public TURQUOISE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class BRIGHT_GREEN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.BRIGHT_GREEN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public BRIGHT_GREEN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class YELLOW
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.YELLOW;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public YELLOW() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class GOLD
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.GOLD;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public GOLD() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class PINK
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.PINK;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public PINK() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class GREY_40_PERCENT
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.GREY_40_PERCENT;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public GREY_40_PERCENT() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class VIOLET
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.VIOLET;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public VIOLET() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIGHT_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIGHT_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIGHT_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class AQUA
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.AQUA;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public AQUA() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class SEA_GREEN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.SEA_GREEN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public SEA_GREEN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIME
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIME;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIME() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class LIGHT_ORANGE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.LIGHT_ORANGE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public LIGHT_ORANGE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class RED
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.RED;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public RED() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class GREY_50_PERCENT
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.GREY_50_PERCENT;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public GREY_50_PERCENT() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class BLUE_GREY
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.BLUE_GREY;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public BLUE_GREY() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class TEAL
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.TEAL;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public TEAL() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class GREEN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.GREEN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public GREEN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class DARK_YELLOW
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.DARK_YELLOW;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public DARK_YELLOW() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class ORANGE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.ORANGE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public ORANGE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class DARK_RED
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.DARK_RED;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public DARK_RED() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class GREY_80_PERCENT
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.GREY_80_PERCENT;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public GREY_80_PERCENT() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class INDIGO
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.INDIGO;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public INDIGO() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class DARK_BLUE
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.DARK_BLUE;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public DARK_BLUE() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class DARK_TEAL
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.DARK_TEAL;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public DARK_TEAL() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class DARK_GREEN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.DARK_GREEN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public DARK_GREEN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class OLIVE_GREEN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.OLIVE_GREEN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public OLIVE_GREEN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class BROWN
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.BROWN;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public BROWN() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    public static class BLACK
    extends HSSFColorRef {
        private static final HSSFColorPredefined ref = HSSFColorPredefined.BLACK;
        public static final short index = ref.getIndex();
        public static final int index2 = ref.getIndex2();
        public static final short[] triplet = ref.getTriplet();
        public static final String hexString = ref.getHexString();

        public BLACK() {
            super(ref);
        }
    }

    @Deprecated
    @Removal(version="3.18")
    private static class HSSFColorRef
    extends HSSFColor {
        HSSFColorRef(HSSFColorPredefined colorEnum) {
            super(colorEnum.getIndex(), colorEnum.getIndex2(), colorEnum.color.color);
        }
    }

    public static enum HSSFColorPredefined {
        BLACK(8, -1, 0),
        BROWN(60, -1, 0x993300),
        OLIVE_GREEN(59, -1, 0x333300),
        DARK_GREEN(58, -1, 13056),
        DARK_TEAL(56, -1, 13158),
        DARK_BLUE(18, 32, 128),
        INDIGO(62, -1, 0x333399),
        GREY_80_PERCENT(63, -1, 0x333333),
        ORANGE(53, -1, 0xFF6600),
        DARK_YELLOW(19, -1, 0x808000),
        GREEN(17, -1, 32768),
        TEAL(21, 38, 32896),
        BLUE(12, 39, 255),
        BLUE_GREY(54, -1, 0x666699),
        GREY_50_PERCENT(23, -1, 0x808080),
        RED(10, -1, 0xFF0000),
        LIGHT_ORANGE(52, -1, 0xFF9900),
        LIME(50, -1, 0x99CC00),
        SEA_GREEN(57, -1, 0x339966),
        AQUA(49, -1, 0x33CCCC),
        LIGHT_BLUE(48, -1, 0x3366FF),
        VIOLET(20, 36, 0x800080),
        GREY_40_PERCENT(55, -1, 0x969696),
        PINK(14, 33, 0xFF00FF),
        GOLD(51, -1, 0xFFCC00),
        YELLOW(13, 34, 0xFFFF00),
        BRIGHT_GREEN(11, -1, 65280),
        TURQUOISE(15, 35, 65535),
        DARK_RED(16, 37, 0x800000),
        SKY_BLUE(40, -1, 52479),
        PLUM(61, 25, 0x993366),
        GREY_25_PERCENT(22, -1, 0xC0C0C0),
        ROSE(45, -1, 0xFF99CC),
        LIGHT_YELLOW(43, -1, 0xFFFF99),
        LIGHT_GREEN(42, -1, 0xCCFFCC),
        LIGHT_TURQUOISE(41, 27, 0xCCFFFF),
        PALE_BLUE(44, -1, 0x99CCFF),
        LAVENDER(46, -1, 0xCC99FF),
        WHITE(9, -1, 0xFFFFFF),
        CORNFLOWER_BLUE(24, -1, 0x9999FF),
        LEMON_CHIFFON(26, -1, 0xFFFFCC),
        MAROON(25, -1, 0x7F0000),
        ORCHID(28, -1, 0x660066),
        CORAL(29, -1, 0xFF8080),
        ROYAL_BLUE(30, -1, 26316),
        LIGHT_CORNFLOWER_BLUE(31, -1, 0xCCCCFF),
        TAN(47, -1, 0xFFCC99),
        AUTOMATIC(64, -1, 0);

        private HSSFColor color;

        private HSSFColorPredefined(int index, int index2, int rgb) {
            this.color = new HSSFColor(index, index2, new Color(rgb));
        }

        public short getIndex() {
            return this.color.getIndex();
        }

        public short getIndex2() {
            return this.color.getIndex2();
        }

        public short[] getTriplet() {
            return this.color.getTriplet();
        }

        public String getHexString() {
            return this.color.getHexString();
        }

        public HSSFColor getColor() {
            return new HSSFColor(this.getIndex(), this.getIndex2(), this.color.color);
        }
    }
}

