/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> myCacheKey;
    private final Key<List<T>> myAllCacheKey;

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(0);
        }
        this(epName.getName(), null);
    }

    public LanguageExtension(@NotNull @NonNls String epName) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(1);
        }
        this(epName, null);
    }

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName, @Nullable T defaultImplementation) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(2);
        }
        this(epName.getName(), defaultImplementation);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.myCacheKey = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
        this.myAllCacheKey = Key.create("ALL_EXTENSIONS_IN_LANGUAGE_" + epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(3);
        }
        String string2 = key.getID();
        if (string2 == null) {
            LanguageExtension.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void clearCache(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(5);
        }
        Set<Language> languages = LanguageUtil.getAllDerivedLanguages(language);
        for (Language derivedLanguage : languages) {
            derivedLanguage.putUserData(this.myCacheKey, null);
            derivedLanguage.putUserData(this.myAllCacheKey, null);
        }
        this.clearCache();
    }

    @Override
    public void invalidateCacheForExtension(String key) {
        super.invalidateCacheForExtension(key);
        Language language = Language.findLanguageByID(key);
        if (language != null) {
            Set<Language> languages = LanguageUtil.getAllDerivedLanguages(language);
            for (Language derivedLanguage : languages) {
                derivedLanguage.putUserData(this.myCacheKey, null);
                derivedLanguage.putUserData(this.myAllCacheKey, null);
            }
        }
    }

    public T forLanguage(@NotNull Language l) {
        T cached2;
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(6);
        }
        if ((cached2 = l.getUserData(this.myCacheKey)) != null) {
            return cached2;
        }
        T result2 = this.findForLanguage(l);
        if (result2 == null) {
            return null;
        }
        result2 = l.putUserDataIfAbsent(this.myCacheKey, result2);
        return result2;
    }

    protected T findForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(7);
        }
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List extensions = this.forKey(l);
            if (extensions.isEmpty()) continue;
            return extensions.get(0);
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        List<T> cached2;
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(8);
        }
        if ((cached2 = language.getUserData(this.myAllCacheKey)) != null) {
            List<T> list2 = cached2;
            if (list2 == null) {
                LanguageExtension.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<T> result2 = this.collectAllForLanguage(language);
        List<T> list3 = language.putUserDataIfAbsent(this.myAllCacheKey, result2);
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @NotNull
    private List<T> collectAllForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(11);
        }
        boolean copyList = true;
        List result2 = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List list2 = this.forKey(l);
            if (result2 == null) {
                result2 = list2;
                continue;
            }
            if (list2.isEmpty()) continue;
            if (copyList) {
                result2 = new ArrayList(ContainerUtil.concat(result2, list2));
                copyList = false;
                continue;
            }
            result2.addAll(list2);
        }
        List list3 = result2;
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        Collection<MetaLanguage> metaLanguages;
        if (stringKey == null) {
            LanguageExtension.$$$reportNull$$$0(13);
        }
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(14);
        }
        if ((metaLanguages = LanguageUtil.matchingMetaLanguages(key)).isEmpty()) {
            List list2 = super.buildExtensions(stringKey, key);
            if (list2 == null) {
                LanguageExtension.$$$reportNull$$$0(15);
            }
            return list2;
        }
        THashSet allKeys = new THashSet();
        allKeys.add(stringKey);
        for (MetaLanguage language : metaLanguages) {
            allKeys.add(this.keyToString(language));
        }
        List list3 = this.buildExtensions((Set<String>)allKeys);
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(16);
        }
        return list3;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(17);
        }
        List<T> forLanguage = this.allForLanguage(l);
        if (l == Language.ANY) {
            List<T> list2 = forLanguage;
            if (list2 == null) {
                LanguageExtension.$$$reportNull$$$0(18);
            }
            return list2;
        }
        List<T> list3 = ContainerUtil.concat(forLanguage, this.allForLanguage(Language.ANY));
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(19);
        }
        return list3;
    }

    @Override
    public void addExplicitExtension(@NotNull Language key, @NotNull T t) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(20);
        }
        if (t == null) {
            LanguageExtension.$$$reportNull$$$0(21);
        }
        key.putUserData(this.myCacheKey, null);
        key.putUserData(this.myAllCacheKey, null);
        super.addExplicitExtension(key, t);
    }

    @Override
    public void removeExplicitExtension(@NotNull Language key, @NotNull T t) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(22);
        }
        if (t == null) {
            LanguageExtension.$$$reportNull$$$0(23);
        }
        key.putUserData(this.myCacheKey, null);
        key.putUserData(this.myAllCacheKey, null);
        super.removeExplicitExtension(key, t);
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @Override
    protected void ensureValuesLoaded() {
        super.ensureValuesLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 3: 
            case 14: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageExtension";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllForLanguage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguageOrAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findForLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAllForLanguage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguageOrAny";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

