/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("com.intellij.lang.psiAugmentProvider");

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(1);
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList2, @NotNull Set<String> modifiers2) {
        if (modifierList2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(4);
        }
        if (modifiers2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(5);
        }
        Set<String> set = modifiers2;
        if (set == null) {
            PsiAugmentProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type2) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(7);
        }
        if (type2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(8);
        }
        SmartList result2 = new SmartList();
        PsiAugmentProvider.forEach(element.getProject(), provider -> {
            result2.addAll(provider.getAugments(element, type2));
            return true;
        });
        SmartList smartList = result2;
        if (smartList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(10);
        }
        Ref result2 = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider -> {
            PsiType type2 = provider.inferType(typeElement);
            if (type2 != null) {
                try {
                    PsiUtil.ensureValidType(type2);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass(e, provider.getClass());
                }
                result2.set(type2);
                return false;
            }
            return true;
        });
        return (PsiType)result2.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList2, @NotNull Project project, @NotNull Set<String> modifiers2) {
        if (modifierList2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            PsiAugmentProvider.$$$reportNull$$$0(12);
        }
        if (modifiers2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(13);
        }
        Ref<Set<String>> result2 = Ref.create(modifiers2);
        PsiAugmentProvider.forEach(project, provider -> {
            result2.set(provider.transformModifiers(modifierList2, Collections.unmodifiableSet((Set)result2.get())));
            return true;
        });
        Set<String> set = result2.get();
        if (set == null) {
            PsiAugmentProvider.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static void forEach(Project project, Processor<? super PsiAugmentProvider> processor2) {
        boolean dumb = DumbService.isDumb(project);
        for (PsiAugmentProvider provider : EP_NAME.getExtensionList()) {
            if (dumb && !DumbService.isDumbAware(provider)) continue;
            try {
                boolean goOn = processor2.process(provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/augment/PsiAugmentProvider";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/augment/PsiAugmentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifiers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAugments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifierProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "transformModifiers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectAugments";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "transformModifierProperties";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

