/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.Ivy;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant.IvyTask;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.sort.SortOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.MapMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.BuildException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.DirectoryScanner;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.FileSet;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.Path;

public class IvyBuildList
extends IvyTask {
    public static final String DESCRIPTOR_REQUIRED = "required";
    private List<FileSet> buildFileSets = new ArrayList<FileSet>();
    private String reference;
    private boolean haltOnError = true;
    private String onMissingDescriptor = "head";
    private boolean reverse = false;
    private String ivyFilePath;
    private String root = "*";
    private List<BuildListModule> roots = new ArrayList<BuildListModule>();
    private boolean excludeRoot = false;
    private String leaf = "*";
    private List<BuildListModule> leafs = new ArrayList<BuildListModule>();
    private String delimiter = ",";
    private boolean excludeLeaf = false;
    private boolean onlydirectdep = false;
    private String restartFrom = "*";

    public void addFileset(FileSet buildFiles) {
        this.buildFileSets.add(buildFiles);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public BuildListModule createRoot() {
        BuildListModule root = new BuildListModule();
        this.roots.add(root);
        return root;
    }

    public boolean isExcludeRoot() {
        return this.excludeRoot;
    }

    public void setExcludeRoot(boolean root) {
        this.excludeRoot = root;
    }

    public String getLeaf() {
        return this.leaf;
    }

    public void setLeaf(String leaf) {
        this.leaf = leaf;
    }

    public BuildListModule createLeaf() {
        BuildListModule leaf = new BuildListModule();
        this.leafs.add(leaf);
        return leaf;
    }

    public boolean isExcludeLeaf() {
        return this.excludeLeaf;
    }

    public void setExcludeLeaf(boolean excludeLeaf) {
        this.excludeLeaf = excludeLeaf;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean getOnlydirectdep() {
        return this.onlydirectdep;
    }

    public void setOnlydirectdep(boolean onlydirectdep) {
        this.onlydirectdep = onlydirectdep;
    }

    @Override
    public void doExecute() throws BuildException {
        if (this.reference == null) {
            throw new BuildException("reference should be provided in ivy build list");
        }
        if (this.buildFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided in ivy build list");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        this.ivyFilePath = this.getProperty(this.ivyFilePath, settings, "ivy.buildlist.ivyfilepath");
        Path path = new Path(this.getProject());
        HashMap<ModuleDescriptor, File> buildFiles = new HashMap<ModuleDescriptor, File>();
        ArrayList<File> independent = new ArrayList<File>();
        ArrayList<File> noDescriptor = new ArrayList<File>();
        Collection<ModuleDescriptor> mds = new ArrayList<ModuleDescriptor>();
        Set<MapMatcher> rootModules = this.convert(this.roots, this.root, settings);
        Set<MapMatcher> leafModules = this.convert(this.leafs, this.leaf, settings);
        Set<MapMatcher> restartFromModules = this.convert(Collections.emptyList(), this.restartFrom, settings);
        for (FileSet fs : this.buildFileSets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String build : ds.getIncludedFiles()) {
                File buildFile = new File(ds.getBasedir(), build);
                File ivyFile = this.getIvyFileFor(buildFile);
                if (!ivyFile.exists()) {
                    this.onMissingDescriptor(buildFile, ivyFile, noDescriptor);
                    continue;
                }
                try {
                    ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, ivyFile.toURI().toURL(), this.doValidate(settings));
                    buildFiles.put(md, buildFile);
                    mds.add(md);
                    Message.debug("Add " + md.getModuleRevisionId().getModuleId());
                }
                catch (Exception ex) {
                    if (this.haltOnError) {
                        throw new BuildException("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex, (Throwable)ex);
                    }
                    Message.warn("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex.getMessage());
                    Message.info("\t=> adding it at the beginning of the path");
                    independent.add(buildFile);
                }
            }
        }
        List<ModuleDescriptor> leafModuleDescriptors = this.findModuleDescriptors(mds, leafModules, "leaf");
        List<ModuleDescriptor> rootModuleDescriptors = this.findModuleDescriptors(mds, rootModules, "root");
        List<ModuleDescriptor> restartFromModuleDescriptors = this.findModuleDescriptors(mds, restartFromModules, "restartFrom");
        if (!rootModuleDescriptors.isEmpty()) {
            Message.info("Filtering modules based on roots [" + this.extractModuleNames(rootModules) + "]");
            mds = this.filterModulesFromRoot(mds, rootModuleDescriptors);
        }
        if (!leafModuleDescriptors.isEmpty()) {
            Message.info("Filtering modules based on leafs [" + this.extractModuleNames(leafModules) + "]");
            mds = this.filterModulesFromLeaf(mds, leafModuleDescriptors);
        }
        List<ModuleDescriptor> sortedModules = ivy.sortModuleDescriptors(mds, SortOptions.DEFAULT);
        if (!"tail".equals(this.onMissingDescriptor)) {
            for (File buildFile : noDescriptor) {
                this.addBuildFile(path, buildFile);
            }
        }
        for (File buildFile : independent) {
            this.addBuildFile(path, buildFile);
        }
        if (this.isReverse()) {
            Collections.reverse(sortedModules);
        }
        if (!restartFromModuleDescriptors.isEmpty()) {
            boolean foundRestartFrom = false;
            ArrayList<ModuleDescriptor> keptModules = new ArrayList<ModuleDescriptor>();
            ModuleDescriptor restartFromModuleDescriptor = restartFromModuleDescriptors.get(0);
            for (ModuleDescriptor md : sortedModules) {
                if (md.equals(restartFromModuleDescriptor)) {
                    foundRestartFrom = true;
                }
                if (!foundRestartFrom) continue;
                keptModules.add(md);
            }
            sortedModules = keptModules;
        }
        StringBuilder order = new StringBuilder();
        for (ModuleDescriptor md : sortedModules) {
            if (order.length() > 0) {
                order.append(", ");
            }
            order.append(md.getModuleRevisionId().getModuleId());
            this.addBuildFile(path, (File)buildFiles.get(md));
        }
        if ("tail".equals(this.onMissingDescriptor)) {
            for (File buildFile : noDescriptor) {
                this.addBuildFile(path, buildFile);
            }
        }
        this.getProject().addReference(this.getReference(), (Object)path);
        this.getProject().setProperty("ivy.sorted.modules", order.toString());
    }

    private Set<MapMatcher> convert(List<BuildListModule> modulesList, String modulesString, IvySettings settings) {
        LinkedHashSet<MapMatcher> result = new LinkedHashSet<MapMatcher>();
        for (BuildListModule module : modulesList) {
            File ivyFile = module.getFile();
            if (ivyFile == null) {
                String org = module.getOrganisation();
                String name = module.getModule();
                String rev = module.getRevision();
                String branch = module.getBranch();
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("organisation", org == null ? "*" : org);
                attributes.put("module", name == null ? "*" : name);
                attributes.put("module", rev == null ? "*" : rev);
                attributes.put("module", branch == null ? "*" : branch);
                result.add(new MapMatcher(attributes, settings.getMatcher("exact")));
                continue;
            }
            try {
                ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, ivyFile.toURI().toURL(), this.doValidate(settings));
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.putAll(md.getModuleRevisionId().getAttributes());
                attributes.put("resource", md.getResource().getName());
                result.add(new MapMatcher(attributes, settings.getMatcher("exact")));
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (!"*".equals(modulesString)) {
            StringTokenizer st = new StringTokenizer(modulesString, this.getDelimiter());
            while (st.hasMoreTokens()) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("module", st.nextToken());
                result.add(new MapMatcher(attributes, settings.getMatcher("exact")));
            }
        }
        return result;
    }

    private void onMissingDescriptor(File buildFile, File ivyFile, List<File> noDescriptor) {
        switch (this.onMissingDescriptor) {
            case "fail": {
                throw new BuildException("a module has no module descriptor and onMissingDescriptor=fail. Build file: " + buildFile + ". Expected descriptor: " + ivyFile);
            }
            case "skip": {
                Message.debug("skipping " + buildFile + ": descriptor " + ivyFile + " doesn't exist");
                break;
            }
            case "warn": {
                Message.warn("a module has no module descriptor. Build file: " + buildFile + ". Expected descriptor: " + ivyFile);
            }
            default: {
                Message.verbose(String.format("no descriptor for %s: descriptor=%s: adding it at the %s of the path", buildFile, ivyFile, "tail".equals(this.onMissingDescriptor) ? "tail" : "head"));
                Message.verbose("\t(change onMissingDescriptor if you want to take another action");
                noDescriptor.add(buildFile);
            }
        }
    }

    private List<ModuleDescriptor> findModuleDescriptors(Collection<ModuleDescriptor> mds, Set<MapMatcher> matchers, String kind) {
        ArrayList<ModuleDescriptor> result = new ArrayList<ModuleDescriptor>();
        HashSet<MapMatcher> missingMatchers = new HashSet<MapMatcher>(matchers);
        for (ModuleDescriptor md : mds) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.putAll(md.getAttributes());
            attributes.put("resource", md.getResource().getName());
            for (MapMatcher matcher : matchers) {
                if (!matcher.matches(attributes)) continue;
                missingMatchers.remove(matcher);
                result.add(md);
            }
        }
        if (!missingMatchers.isEmpty()) {
            throw new BuildException("unable to find " + kind + " module(s) " + this.extractModuleNames(missingMatchers) + " in build fileset");
        }
        return result;
    }

    private String extractModuleNames(Set<MapMatcher> matchers) {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (MapMatcher matcher : matchers) {
            result.append(sep);
            Map<String, String> attributes = matcher.getAttributes();
            String organisation = attributes.get("organisation");
            if (organisation != null && !"*".equals(organisation)) {
                result.append(organisation);
                result.append('#');
            }
            result.append(attributes.get("module"));
            sep = ", ";
        }
        return result.toString();
    }

    private Collection<ModuleDescriptor> filterModulesFromRoot(Collection<ModuleDescriptor> mds, List<ModuleDescriptor> rootmds) {
        HashMap<ModuleId, ModuleDescriptor> moduleIdMap = new HashMap<ModuleId, ModuleDescriptor>();
        for (ModuleDescriptor md : mds) {
            moduleIdMap.put(md.getModuleRevisionId().getModuleId(), md);
        }
        LinkedHashSet<ModuleDescriptor> toKeep = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleDescriptor rootmd : rootmds) {
            this.processFilterNodeFromRoot(rootmd, toKeep, moduleIdMap);
            if (this.excludeRoot) {
                Message.verbose("Excluded module " + rootmd.getModuleRevisionId().getModuleId().getName());
                continue;
            }
            toKeep.add(rootmd);
        }
        for (ModuleDescriptor md : toKeep) {
            Message.verbose("Kept module " + md.getModuleRevisionId().getModuleId().getName());
        }
        return toKeep;
    }

    private void processFilterNodeFromRoot(ModuleDescriptor node, Set<ModuleDescriptor> toKeep, Map<ModuleId, ModuleDescriptor> moduleIdMap) {
        for (DependencyDescriptor dep : node.getDependencies()) {
            ModuleId id = dep.getDependencyId();
            ModuleDescriptor md = moduleIdMap.get(id);
            if (md == null || toKeep.contains(md)) continue;
            toKeep.add(md);
            if (this.getOnlydirectdep()) continue;
            this.processFilterNodeFromRoot(md, toKeep, moduleIdMap);
        }
    }

    private Collection<ModuleDescriptor> filterModulesFromLeaf(Collection<ModuleDescriptor> mds, List<ModuleDescriptor> leafmds) {
        HashMap<ModuleId, ModuleDescriptor> moduleIdMap = new HashMap<ModuleId, ModuleDescriptor>();
        for (ModuleDescriptor md : mds) {
            moduleIdMap.put(md.getModuleRevisionId().getModuleId(), md);
        }
        LinkedHashSet<ModuleDescriptor> toKeep = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleDescriptor leafmd : leafmds) {
            if (this.excludeLeaf) {
                Message.verbose("Excluded module " + leafmd.getModuleRevisionId().getModuleId().getName());
            } else {
                toKeep.add(leafmd);
            }
            this.processFilterNodeFromLeaf(leafmd, toKeep, moduleIdMap);
        }
        for (ModuleDescriptor md : toKeep) {
            Message.verbose("Kept module " + md.getModuleRevisionId().getModuleId().getName());
        }
        return toKeep;
    }

    private void processFilterNodeFromLeaf(ModuleDescriptor node, Set<ModuleDescriptor> toKeep, Map<ModuleId, ModuleDescriptor> moduleIdMap) {
        for (ModuleDescriptor md : moduleIdMap.values()) {
            for (DependencyDescriptor dep : md.getDependencies()) {
                if (!node.getModuleRevisionId().getModuleId().equals(dep.getDependencyId()) || toKeep.contains(md)) continue;
                toKeep.add(md);
                if (this.getOnlydirectdep()) continue;
                this.processFilterNodeFromLeaf(md, toKeep, moduleIdMap);
            }
        }
    }

    private void addBuildFile(Path path, File buildFile) {
        FileSet fs = new FileSet();
        fs.setFile(buildFile);
        path.addFileset(fs);
    }

    private File getIvyFileFor(File buildFile) {
        return new File(buildFile.getParentFile(), this.ivyFilePath);
    }

    public boolean isHaltonerror() {
        return this.haltOnError;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public String getIvyfilepath() {
        return this.ivyFilePath;
    }

    public void setIvyfilepath(String ivyFilePath) {
        this.ivyFilePath = ivyFilePath;
    }

    public String getOnMissingDescriptor() {
        return this.onMissingDescriptor;
    }

    public void setOnMissingDescriptor(String onMissingDescriptor) {
        this.onMissingDescriptor = onMissingDescriptor;
    }

    @Deprecated
    public boolean isSkipbuildwithoutivy() {
        return "skip".equals(this.onMissingDescriptor);
    }

    @Deprecated
    public void setSkipbuildwithoutivy(boolean skipBuildFilesWithoutIvy) {
        Message.deprecated("skipbuildwithoutivy is deprecated, use onMissingDescriptor instead.");
        this.onMissingDescriptor = skipBuildFilesWithoutIvy ? "skip" : "fail";
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public String getRestartFrom() {
        return this.restartFrom;
    }

    public void setRestartFrom(String restartFrom) {
        this.restartFrom = restartFrom;
    }

    public static final class BuildListModule {
        private String organisation;
        private String module;
        private String revision;
        private String branch;
        private File file;

        public String getOrganisation() {
            return this.organisation;
        }

        public void setOrganisation(String organisation) {
            this.organisation = organisation;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public String getBranch() {
            return this.branch;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    public static final class OnMissingDescriptor {
        public static final String HEAD = "head";
        public static final String TAIL = "tail";
        public static final String SKIP = "skip";
        public static final String FAIL = "fail";
        public static final String WARN = "warn";

        private OnMissingDescriptor() {
        }
    }
}

