"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tagtypes_1 = require("./tagtypes");
function filter(test, element, recurse, limit) {
    if (recurse === void 0) { recurse = true; }
    if (limit === void 0) { limit = Infinity; }
    if (!Array.isArray(element))
        element = [element];
    return find(test, element, recurse, limit);
}
exports.filter = filter;
function find(test, elems, recurse, limit) {
    var result = [];
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (test(elem)) {
            result.push(elem);
            if (--limit <= 0)
                break;
        }
        if (recurse && tagtypes_1.hasChildren(elem) && elem.children.length > 0) {
            var children = find(test, elem.children, recurse, limit);
            result = result.concat(children);
            limit -= children.length;
            if (limit <= 0)
                break;
        }
    }
    return result;
}
exports.find = find;
function findOneChild(test, elems) {
    for (var i = 0; i < elems.length; i++) {
        if (test(elems[i]))
            return elems[i];
    }
    return null;
}
exports.findOneChild = findOneChild;
function findOne(test, elems, recurse) {
    if (recurse === void 0) { recurse = true; }
    var elem = null;
    for (var i = 0; i < elems.length && !elem; i++) {
        var checked = elems[i];
        if (!tagtypes_1.isTag(checked)) {
            continue;
        }
        else if (test(checked)) {
            elem = checked;
        }
        else if (recurse && checked.children.length > 0) {
            elem = findOne(test, checked.children);
        }
    }
    return elem;
}
exports.findOne = findOne;
function existsOne(test, elems) {
    for (var i = 0; i < elems.length; i++) {
        var checked = elems[i];
        if (tagtypes_1.isTag(checked) &&
            (test(checked) ||
                (checked.children.length > 0 &&
                    existsOne(test, checked.children)))) {
            return true;
        }
    }
    return false;
}
exports.existsOne = existsOne;
function findAll(test, rootElems) {
    var result = [];
    var stack = rootElems.slice();
    while (stack.length) {
        var elem = stack.shift();
        if (!elem || !tagtypes_1.isTag(elem))
            continue;
        if (elem.children && elem.children.length > 0) {
            stack.unshift.apply(stack, elem.children);
        }
        if (test(elem))
            result.push(elem);
    }
    return result;
}
exports.findAll = findAll;
