/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.code.Base64Coder;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.atom.AtomImgSvg;
import net.sourceforge.plantuml.creole.atom.AtomText;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TileImageSvg;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class AtomImg
extends AbstractAtom
implements Atom {
    private static final String DATA_IMAGE_PNG_BASE64 = "data:image/png;base64,";
    private final BufferedImage image;
    private final double scale;
    private final Url url;
    private final String rawFileName;

    private AtomImg(BufferedImage image, double scale, Url url, String rawFileName) {
        this.image = image;
        this.scale = scale;
        this.url = url;
        this.rawFileName = rawFileName;
    }

    public static Atom createQrcode(String flash, double scale) {
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        BufferedImage im = utils.exportFlashcode(flash, Color.BLACK, Color.WHITE);
        if (im == null) {
            im = new BufferedImage(10, 10, 1);
        }
        return new AtomImg(new UImage(null, im).scaleNearestNeighbor(scale).getImage(), 1.0, null, null);
    }

    public static Atom create(String src, ImgValign valign, int vspace, double scale, Url url) {
        UFont font = UFont.monospaced(14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        if (src.startsWith(DATA_IMAGE_PNG_BASE64)) {
            String data = src.substring(DATA_IMAGE_PNG_BASE64.length(), src.length());
            try {
                byte[] bytes = Base64Coder.decode(data);
                return AtomImg.buildRasterFromData(src, fc, bytes, scale, url);
            }
            catch (Exception e) {
                return AtomText.create("ERROR " + e.toString(), fc);
            }
        }
        try {
            if (src.startsWith("http:") || src.startsWith("https:")) {
                if (src.endsWith(".svg")) {
                    return AtomImg.buildSvgFromUrl(src, fc, new URL(src), scale, url);
                }
                return AtomImg.buildRasterFromUrl(src, fc, new URL(src), scale, url);
            }
            File f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                return AtomText.create("(File not found: " + f.getCanonicalPath() + ")", fc);
            }
            if (f.getName().endsWith(".svg")) {
                return new AtomImgSvg(new TileImageSvg(f));
            }
            BufferedImage read = FileUtils.readRasterImageFromFile(f);
            if (read == null) {
                return AtomText.create("(Cannot decode: " + f.getCanonicalPath() + ")", fc);
            }
            return new AtomImg(FileUtils.readRasterImageFromFile(f), scale, url, src);
        }
        catch (IOException e) {
            return AtomText.create("ERROR " + e.toString(), fc);
        }
    }

    private static Atom buildRasterFromData(String source, FontConfiguration fc, byte[] data, double scale, Url url) throws IOException {
        BufferedImage read = ImageIO.read(new ByteArrayInputStream(data));
        if (read == null) {
            return AtomText.create("(Cannot decode: " + source + ")", fc);
        }
        return new AtomImg(read, scale, url, null);
    }

    private static Atom buildRasterFromUrl(String text, FontConfiguration fc, URL source, double scale, Url url) throws IOException {
        BufferedImage read = FileUtils.readRasterImageFromURL(source);
        if (read == null) {
            return AtomText.create("(Cannot decode: " + text + ")", fc);
        }
        return new AtomImg(read, scale, url, source.getPath());
    }

    private static Atom buildSvgFromUrl(String text, FontConfiguration fc, URL source, double scale, Url url) throws IOException {
        byte[] read = AtomImg.getFile(source);
        if (read == null) {
            return AtomText.create("(Cannot decode SVG: " + text + ")", fc);
        }
        return new AtomImgSvg(new TileImageSvg(new String(read, "UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFile(URL url) {
        byte[] byArray;
        block7: {
            ByteArrayOutputStream image = new ByteArrayOutputStream();
            InputStream input = null;
            try {
                int read;
                URLConnection connection = url.openConnection();
                input = connection.getInputStream();
                byte[] buffer = new byte[1024];
                while ((read = input.read(buffer)) > 0) {
                    image.write(buffer, 0, read);
                }
                image.close();
                byArray = image.toByteArray();
                if (input == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            input.close();
        }
        return byArray;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble((double)this.image.getWidth() * this.scale, (double)this.image.getHeight() * this.scale);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug.draw(new UImage(this.rawFileName, this.image).scale(this.scale));
        if (this.url != null) {
            ug.closeAction();
        }
    }
}

