/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.PaddingParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseBoundary;
import net.sourceforge.plantuml.skin.rose.ComponentRoseControl;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDatabase;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEntity;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteBox;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteHexagonal;
import net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import net.sourceforge.plantuml.skin.rose.ComponentRoseQueue;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Rose {
    private final double paddingX = 5.0;
    public static final double paddingY = 5.0;

    public HColor getFontColor(ISkinParam skin, FontParam fontParam) {
        return skin.getFontHtmlColor(null, fontParam);
    }

    public HColor getHtmlColor(ISkinParam skin, ColorParam color) {
        return this.getHtmlColor(skin, null, color);
    }

    public HColor getHtmlColor(ISkinParam skin, Stereotype stereotype, ColorParam ... colorParams) {
        for (ColorParam param : colorParams) {
            HColor result = skin.getHtmlColor(param, stereotype, false);
            if (result == null) continue;
            return result;
        }
        return colorParams[0].getDefaultValue();
    }

    private FontConfiguration getUFont2(ISkinParam skinParam, FontParam fontParam) {
        return new FontConfiguration(skinParam, fontParam, null);
    }

    public Component createComponent(Style[] styles, ComponentType type, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        UFont fontGrouping = param.getFont(null, false, FontParam.SEQUENCE_GROUP);
        Stereotype stereotype = stringsToDisplay == null ? null : stringsToDisplay.getStereotypeIfAny();
        UFont newFontForStereotype = param.getFont(null, false, FontParam.SEQUENCE_STEREOTYPE);
        if (type.isArrow()) {
            return this.createComponentArrow(null, config, param, stringsToDisplay);
        }
        double padding = param.getPadding(PaddingParam.PARTICIPANT);
        double roundCorner = param.getRoundCorner(CornerParam.DEFAULT, null);
        double diagonalCorner = param.getDiagonalCorner(CornerParam.DEFAULT, null);
        if (type == ComponentType.PARTICIPANT_HEAD) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.participantBorder), this.getUFont2(param, FontParam.PARTICIPANT), stringsToDisplay, param, roundCorner, diagonalCorner, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE), param.minClassWidth(), false, padding);
        }
        if (type == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.participantBorder), this.getUFont2(param, FontParam.PARTICIPANT), stringsToDisplay, param, roundCorner, diagonalCorner, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE), param.minClassWidth(), false, padding);
        }
        if (type == ComponentType.COLLECTIONS_HEAD) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.collectionsBorder), this.getUFont2(param, FontParam.PARTICIPANT), stringsToDisplay, param, roundCorner, diagonalCorner, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE), param.minClassWidth(), true, padding);
        }
        if (type == ComponentType.COLLECTIONS_TAIL) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.collectionsBorder), this.getUFont2(param, FontParam.PARTICIPANT), stringsToDisplay, param, roundCorner, diagonalCorner, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE), param.minClassWidth(), true, padding);
        }
        if (type == ComponentType.PARTICIPANT_LINE) {
            HColor borderColor = this.getHtmlColor(param, stereotype, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(styles == null ? null : styles[0], borderColor, false, Rose.getStroke(param, LineParam.sequenceLifeLineBorder, 1.0), param.getIHtmlColorSet());
        }
        if (type == ComponentType.CONTINUE_LINE) {
            HColor borderColor = this.getHtmlColor(param, stereotype, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(styles == null ? null : styles[0], borderColor, true, Rose.getStroke(param, LineParam.sequenceLifeLineBorder, 1.5), param.getIHtmlColorSet());
        }
        if (type == ComponentType.ACTOR_HEAD) {
            return new ComponentRoseActor(param.getActorStyle(), styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.ACTOR_TAIL) {
            return new ComponentRoseActor(param.getActorStyle(), styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.BOUNDARY_HEAD) {
            return new ComponentRoseBoundary(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.boundaryBorder), this.getUFont2(param, FontParam.BOUNDARY), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.BOUNDARY_STEREOTYPE));
        }
        if (type == ComponentType.BOUNDARY_TAIL) {
            return new ComponentRoseBoundary(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.boundaryBorder), this.getUFont2(param, FontParam.BOUNDARY), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.BOUNDARY_STEREOTYPE));
        }
        if (type == ComponentType.CONTROL_HEAD) {
            return new ComponentRoseControl(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.controlBorder), this.getUFont2(param, FontParam.CONTROL), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.CONTROL_STEREOTYPE));
        }
        if (type == ComponentType.CONTROL_TAIL) {
            return new ComponentRoseControl(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.controlBorder), this.getUFont2(param, FontParam.CONTROL), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.CONTROL_STEREOTYPE));
        }
        if (type == ComponentType.ENTITY_HEAD) {
            return new ComponentRoseEntity(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.entityBorder), this.getUFont2(param, FontParam.ENTITY), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.ENTITY_STEREOTYPE));
        }
        if (type == ComponentType.ENTITY_TAIL) {
            return new ComponentRoseEntity(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.entityBorder), this.getUFont2(param, FontParam.ENTITY), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.ENTITY_STEREOTYPE));
        }
        if (type == ComponentType.QUEUE_HEAD) {
            return new ComponentRoseQueue(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.queueBorder), this.getUFont2(param, FontParam.QUEUE), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.QUEUE_STEREOTYPE));
        }
        if (type == ComponentType.QUEUE_TAIL) {
            return new ComponentRoseQueue(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.queueBorder), this.getUFont2(param, FontParam.QUEUE), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.QUEUE_STEREOTYPE));
        }
        if (type == ComponentType.DATABASE_HEAD) {
            return new ComponentRoseDatabase(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.databaseBorder), this.getUFont2(param, FontParam.DATABASE), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.DATABASE_STEREOTYPE));
        }
        if (type == ComponentType.DATABASE_TAIL) {
            return new ComponentRoseDatabase(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getSymbolContext(stereotype, param, ColorParam.databaseBorder), this.getUFont2(param, FontParam.DATABASE), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.DATABASE_STEREOTYPE));
        }
        if (type == ComponentType.NOTE) {
            HorizontalAlignment alignment = param.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false);
            return new ComponentRoseNote(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.noteBorder), this.getUFont2(param, FontParam.NOTE), stringsToDisplay, 5.0, 5.0, param, roundCorner, alignment);
        }
        if (type == ComponentType.NOTE_HEXAGONAL) {
            HorizontalAlignment alignment = param.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false);
            return new ComponentRoseNoteHexagonal(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.noteBorder), this.getUFont2(param, FontParam.NOTE), stringsToDisplay, param, alignment);
        }
        if (type == ComponentType.NOTE_BOX) {
            HorizontalAlignment alignment = param.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false);
            return new ComponentRoseNoteBox(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.noteBorder), this.getUFont2(param, FontParam.NOTE), stringsToDisplay, param, roundCorner, alignment);
        }
        FontConfiguration bigFont = this.getUFont2(param, FontParam.SEQUENCE_GROUP_HEADER);
        if (type == ComponentType.GROUPING_HEADER) {
            FontConfiguration smallFont = bigFont.forceFont(fontGrouping, null);
            HColor smallColor = SkinParamUtils.getFontColor(param, FontParam.SEQUENCE_GROUP, null);
            if (smallColor != null) {
                smallFont = smallFont.changeColor(smallColor);
            }
            return new ComponentRoseGroupingHeader(styles == null ? null : styles[0], styles == null ? null : styles[1], param.getBackgroundColor(), this.getSymbolContext(stereotype, param, ColorParam.sequenceGroupBorder), bigFont, smallFont, stringsToDisplay, param, roundCorner);
        }
        if (type == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(styles == null ? null : styles[0], this.getHtmlColor(param, stereotype, ColorParam.sequenceGroupBorder), this.getUFont2(param, FontParam.SEQUENCE_GROUP), stringsToDisplay.get(0), param, param.getBackgroundColor());
        }
        if (type == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentRoseActiveLine(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.sequenceLifeLineBorder), true, true, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentRoseActiveLine(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.sequenceLifeLineBorder), true, false, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentRoseActiveLine(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.sequenceLifeLineBorder), false, true, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentRoseActiveLine(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.sequenceLifeLineBorder), false, false, param.getIHtmlColorSet());
        }
        if (type == ComponentType.DELAY_LINE) {
            return new ComponentRoseDelayLine(null, this.getHtmlColor(param, stereotype, ColorParam.sequenceLifeLineBorder));
        }
        if (type == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(styles == null ? null : styles[0], this.getUFont2(param, FontParam.SEQUENCE_DELAY), stringsToDisplay, param);
        }
        if (type == ComponentType.DESTROY) {
            return new ComponentRoseDestroy(null, this.getHtmlColor(param, stereotype, ColorParam.sequenceLifeLineBorder));
        }
        if (type == ComponentType.NEWPAGE) {
            throw new UnsupportedOperationException();
        }
        if (type == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(styles == null ? null : styles[0], this.getUFont2(param, FontParam.SEQUENCE_DIVIDER), this.getHtmlColor(param, stereotype, ColorParam.sequenceDividerBackground), stringsToDisplay, param, this.deltaShadow(param, ColorParam.sequenceDividerBackground) > 0.0, Rose.getStroke(param, LineParam.sequenceDividerBorder, 2.0), this.getHtmlColor(param, stereotype, ColorParam.sequenceDividerBorder));
        }
        if (type == ComponentType.REFERENCE) {
            return new ComponentRoseReference(styles == null ? null : styles[0], styles == null ? null : styles[1], this.getUFont2(param, FontParam.SEQUENCE_REFERENCE), this.getSymbolContext(stereotype, param, ColorParam.sequenceReferenceBorder), bigFont, stringsToDisplay, param.getHorizontalAlignment(AlignmentParam.sequenceReferenceAlignment, null, false), param, this.getHtmlColor(param, stereotype, ColorParam.sequenceReferenceBackground));
        }
        if (type == ComponentType.ENGLOBER) {
            return new ComponentRoseEnglober(styles == null ? null : styles[0], this.getSymbolContext(stereotype, param, ColorParam.sequenceBoxBorder), stringsToDisplay, this.getUFont2(param, FontParam.SEQUENCE_BOX), param, roundCorner);
        }
        return null;
    }

    public ComponentRoseNewpage createComponentNewPage(ISkinParam param) {
        return new ComponentRoseNewpage(null, this.getHtmlColor(param, ColorParam.sequenceNewpageSeparator));
    }

    public ArrowComponent createComponentArrow(Style[] styles, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        HorizontalAlignment textHorizontalAlignment;
        HorizontalAlignment messageHorizontalAlignment;
        HColor sequenceArrow;
        HColor hColor = sequenceArrow = config.getColor() == null ? this.getHtmlColor(param, ColorParam.arrow) : config.getColor();
        if (config.getArrowDirection() == ArrowDirection.SELF) {
            return new ComponentRoseSelfArrow(styles == null ? null : styles[0], sequenceArrow, this.getUFont2(param, FontParam.ARROW), stringsToDisplay, config, (ISkinSimple)param, param.maxMessageSize(), !param.strictUmlStyle());
        }
        ArrowDirection arrowDirection = config.getArrowDirection();
        if (SkinParam.USE_STYLES()) {
            StyleSignature signature = StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.arrow);
            Style textStyle = signature.getMergedStyle(param.getCurrentStyleBuilder());
            String value = textStyle.value(PName.HorizontalAlignment).asString();
            messageHorizontalAlignment = textStyle.getHorizontalAlignment();
            textHorizontalAlignment = textStyle.getHorizontalAlignment();
            if ("first".equalsIgnoreCase(value)) {
                boolean isReverseDefine = config.isReverseDefine();
                messageHorizontalAlignment = arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE ? (isReverseDefine ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT) : (isReverseDefine ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT);
            } else if ("direction".equalsIgnoreCase(value)) {
                if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                    messageHorizontalAlignment = HorizontalAlignment.LEFT;
                } else if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                    messageHorizontalAlignment = HorizontalAlignment.RIGHT;
                } else if (arrowDirection == ArrowDirection.BOTH_DIRECTION) {
                    messageHorizontalAlignment = HorizontalAlignment.CENTER;
                }
            } else if ("reversedirection".equalsIgnoreCase(value)) {
                if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                    messageHorizontalAlignment = HorizontalAlignment.RIGHT;
                } else if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                    messageHorizontalAlignment = HorizontalAlignment.LEFT;
                } else if (arrowDirection == ArrowDirection.BOTH_DIRECTION) {
                    messageHorizontalAlignment = HorizontalAlignment.CENTER;
                }
            }
        } else {
            messageHorizontalAlignment = param.getHorizontalAlignment(AlignmentParam.sequenceMessageAlignment, arrowDirection, config.isReverseDefine());
            textHorizontalAlignment = param.getHorizontalAlignment(AlignmentParam.sequenceMessageTextAlignment, config.getArrowDirection(), false);
        }
        return new ComponentRoseArrow(styles == null ? null : styles[0], sequenceArrow, this.getUFont2(param, FontParam.ARROW), stringsToDisplay, config, messageHorizontalAlignment, param, textHorizontalAlignment, param.maxMessageSize(), !param.strictUmlStyle(), param.responseMessageBelowArrow());
    }

    private double deltaShadow(ISkinParam param, ColorParam color) {
        SkinParameter skinParameter = null;
        if (color == ColorParam.participantBorder) {
            skinParameter = SkinParameter.PARTICIPANT;
        } else if (color == ColorParam.actorBorder) {
            skinParameter = SkinParameter.ACTOR;
        } else if (color == ColorParam.boundaryBorder) {
            skinParameter = SkinParameter.BOUNDARY;
        } else if (color == ColorParam.controlBorder) {
            skinParameter = SkinParameter.CONTROL;
        } else if (color == ColorParam.entityBorder) {
            skinParameter = SkinParameter.ENTITY;
        } else if (color == ColorParam.collectionsBorder) {
            skinParameter = SkinParameter.COLLECTIONS;
        } else if (color == ColorParam.databaseBorder) {
            skinParameter = SkinParameter.DATABASE;
        }
        boolean result = skinParameter == null ? param.shadowing(null) : param.shadowing2(null, skinParameter);
        return result ? 4.0 : 0.0;
    }

    private SymbolContext getSymbolContext(Stereotype stereotype, ISkinParam skin, ColorParam color) {
        if (color == ColorParam.participantBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.participantBackground), this.getHtmlColor(skin, stereotype, ColorParam.participantBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceParticipantBorder, 1.5)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.actorBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.actorBackground), this.getHtmlColor(skin, stereotype, ColorParam.actorBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.boundaryBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.boundaryBackground), this.getHtmlColor(skin, stereotype, ColorParam.boundaryBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.controlBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.controlBackground), this.getHtmlColor(skin, stereotype, ColorParam.controlBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.collectionsBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.collectionsBackground), this.getHtmlColor(skin, stereotype, ColorParam.collectionsBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceActorBorder, 1.5)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.queueBorder) {
            double tmp = this.deltaShadow(skin, color);
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.queueBackground), this.getHtmlColor(skin, stereotype, ColorParam.queueBorder)).withStroke(Rose.getStroke(skin, LineParam.queueBorder, 2.0)).withDeltaShadow(tmp);
        }
        if (color == ColorParam.entityBorder) {
            double tmp = this.deltaShadow(skin, color);
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.entityBackground), this.getHtmlColor(skin, stereotype, ColorParam.entityBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(tmp);
        }
        if (color == ColorParam.databaseBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.databaseBackground), this.getHtmlColor(skin, stereotype, ColorParam.databaseBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.sequenceLifeLineBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.sequenceLifeLineBackground), this.getHtmlColor(skin, stereotype, ColorParam.sequenceLifeLineBorder)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.noteBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.noteBackground), this.getHtmlColor(skin, stereotype, ColorParam.noteBorder)).withStroke(Rose.getStroke(skin, LineParam.noteBorder, 1.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.sequenceGroupBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.sequenceGroupBackground), this.getHtmlColor(skin, stereotype, ColorParam.sequenceGroupBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceGroupBorder, 2.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        if (color == ColorParam.sequenceBoxBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.sequenceBoxBackground), this.getHtmlColor(skin, stereotype, ColorParam.sequenceBoxBorder));
        }
        if (color == ColorParam.sequenceReferenceBorder) {
            return new SymbolContext(this.getHtmlColor(skin, stereotype, ColorParam.sequenceReferenceHeaderBackground), this.getHtmlColor(skin, stereotype, ColorParam.sequenceReferenceBorder)).withStroke(Rose.getStroke(skin, LineParam.sequenceReferenceBorder, 2.0)).withDeltaShadow(this.deltaShadow(skin, color));
        }
        throw new IllegalArgumentException();
    }

    public static UStroke getStroke(ISkinParam param, LineParam lineParam, double defaultValue) {
        UStroke result = param.getThickness(lineParam, null);
        if (result == null) {
            return new UStroke(defaultValue);
        }
        return result;
    }
}

