/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.Node;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageStateBorder
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Cluster stateParent;
    private final EntityPosition entityPosition;
    private final Bibliotekon bibliotekon;
    private final Rankdir rankdir;

    public EntityImageStateBorder(ILeaf leaf, ISkinParam skinParam, Cluster stateParent, Bibliotekon bibliotekon) {
        super(leaf, skinParam);
        this.bibliotekon = bibliotekon;
        this.rankdir = skinParam.getRankdir();
        this.entityPosition = leaf.getEntityPosition();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        this.stateParent = stateParent;
        Stereotype stereotype = leaf.getStereotype();
        this.desc = leaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, skinParam);
    }

    private boolean upPosition() {
        Point2D clusterCenter = this.stateParent.getClusterPosition().getPointCenter();
        Node node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.entityPosition.getDimension(this.rankdir);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    @Override
    public final void drawU(UGraphic ug) {
        double y = 0.0;
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        ug = ug.apply(new UStroke(1.5)).apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder));
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
        }
        ug = ug.apply(backcolor.bg());
        this.entityPosition.drawSymbol(ug, this.rankdir);
    }

    @Override
    public ShapeType getShapeType() {
        return this.entityPosition.getShapeType();
    }
}

