/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.URLHandler;

public class BasicURLHandler
extends AbstractURLHandler {
    private static final int BUFFER_SIZE = 65536;
    private static final int ERROR_BODY_TRUNCATE_LEN = 512;

    @Override
    public URLHandler.URLInfo getURLInfo(URL uRL) {
        return this.getURLInfo(uRL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URLHandler.URLInfo getURLInfo(URL uRL, int n) {
        URLConnection uRLConnection;
        block13: {
            if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
                IvyAuthenticator.install();
            }
            uRLConnection = null;
            try {
                uRL = this.normalizeToURL(uRL);
                uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    if (this.getRequestMethod() == 2) {
                        httpURLConnection.setRequestMethod("HEAD");
                    }
                    if (this.checkStatusCode(uRL, httpURLConnection)) {
                        String string = BasicURLHandler.getCharSetFromContentType(uRLConnection.getContentType());
                        URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, httpURLConnection.getContentLength(), uRLConnection.getLastModified(), string);
                        this.disconnect(uRLConnection);
                        return uRLInfo;
                    }
                    break block13;
                }
                int n2 = uRLConnection.getContentLength();
                if (n2 <= 0) {
                    URLHandler.URLInfo uRLInfo = UNAVAILABLE;
                    this.disconnect(uRLConnection);
                    return uRLInfo;
                }
                String string = BasicURLHandler.getCharSetFromContentType(uRLConnection.getContentType());
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, n2, uRLConnection.getLastModified(), string);
                this.disconnect(uRLConnection);
                return uRLInfo;
            }
            catch (UnknownHostException unknownHostException) {
                Message.warn("Host " + unknownHostException.getMessage() + " not found. url=" + uRL);
                Message.info("You probably access the destination server through a proxy server that is not well configured.");
                this.disconnect(uRLConnection);
                return UNAVAILABLE;
                {
                    catch (Throwable throwable) {
                        this.disconnect(uRLConnection);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    Message.error("Server access Error: " + iOException.getMessage() + " url=" + uRL);
                    this.disconnect(uRLConnection);
                    return UNAVAILABLE;
                }
            }
        }
        this.disconnect(uRLConnection);
        return UNAVAILABLE;
    }

    public static String getCharSetFromContentType(String string) {
        String string2 = null;
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                if (!string3.toLowerCase().startsWith("charset=")) continue;
                string2 = string3.substring("charset=".length());
            }
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "ISO-8859-1";
        }
        return string2;
    }

    private boolean checkStatusCode(URL uRL, HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            return true;
        }
        if ("HEAD".equals(httpURLConnection.getRequestMethod()) && n == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + n + " url=" + uRL);
        if (n == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(n).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + httpURLConnection.getResponseMessage() + " url=" + uRL);
        } else if (String.valueOf(n).startsWith("5")) {
            Message.error("SERVER ERROR: " + httpURLConnection.getResponseMessage() + " url=" + uRL);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openStream(URL uRL) throws IOException {
        if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
            IvyAuthenticator.install();
        }
        URLConnection uRLConnection = null;
        try {
            int n;
            Object object;
            uRL = this.normalizeToURL(uRL);
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            uRLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (uRLConnection instanceof HttpURLConnection && !this.checkStatusCode(uRL, (HttpURLConnection)(object = (HttpURLConnection)uRLConnection))) {
                throw new IOException("The HTTP response code for " + uRL + " did not indicate a success. See log for more detail.");
            }
            object = this.getDecodingInputStream(uRLConnection.getContentEncoding(), uRLConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65536];
            while ((n = ((InputStream)object).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.disconnect(uRLConnection);
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            this.disconnect(uRLConnection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(URL uRL, File file, CopyProgressListener copyProgressListener) throws IOException {
        if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
            IvyAuthenticator.install();
        }
        URLConnection uRLConnection = null;
        try {
            int n;
            Object object;
            uRL = this.normalizeToURL(uRL);
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            uRLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (uRLConnection instanceof HttpURLConnection && !this.checkStatusCode(uRL, (HttpURLConnection)(object = (HttpURLConnection)uRLConnection))) {
                throw new IOException("The HTTP response code for " + uRL + " did not indicate a success. See log for more detail.");
            }
            object = this.getDecodingInputStream(uRLConnection.getContentEncoding(), uRLConnection.getInputStream());
            FileUtil.copy((InputStream)object, file, copyProgressListener);
            if (uRLConnection.getContentEncoding() == null && (n = uRLConnection.getContentLength()) != -1 && file.length() != (long)n) {
                file.delete();
                throw new IOException("Downloaded file size doesn't match expected Content Length for " + uRL + ". Please retry.");
            }
            long l = uRLConnection.getLastModified();
            if (l > 0L) {
                file.setLastModified(l);
            }
            this.disconnect(uRLConnection);
        }
        catch (Throwable throwable) {
            this.disconnect(uRLConnection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(File file, URL uRL, CopyProgressListener copyProgressListener) throws IOException {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            throw new UnsupportedOperationException("URL repository only support HTTP PUT at the moment");
        }
        IvyAuthenticator.install();
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = this.normalizeToURL(uRL);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("PUT");
            httpURLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            httpURLConnection.setRequestProperty("Content-type", "application/octet-stream");
            httpURLConnection.setRequestProperty("Content-length", Long.toString(file.length()));
            httpURLConnection.setInstanceFollowRedirects(true);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                OutputStream outputStream = httpURLConnection.getOutputStream();
                FileUtil.copy((InputStream)fileInputStream, outputStream, copyProgressListener);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            int n = httpURLConnection.getResponseCode();
            String string = "";
            InputStream inputStream = httpURLConnection.getErrorStream();
            if (inputStream != null) {
                InputStream inputStream2 = this.getDecodingInputStream(httpURLConnection.getContentEncoding(), inputStream);
                byte[] byArray = this.readTruncated(inputStream2, 512);
                String string2 = BasicURLHandler.getCharSetFromContentType(httpURLConnection.getContentType());
                string = "; Response Body: " + new String(byArray, string2);
            }
            this.validatePutStatusCode(uRL, n, httpURLConnection.getResponseMessage() + string);
            this.disconnect(httpURLConnection);
        }
        catch (Throwable throwable) {
            this.disconnect(httpURLConnection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readTruncated(InputStream inputStream, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            int n2 = 0;
            int n3 = inputStream.read();
            boolean bl = false;
            while (!bl && n3 >= 0) {
                if (n2 >= n) {
                    bl = true;
                    continue;
                }
                byteArrayOutputStream.write(n3);
                ++n2;
                n3 = inputStream.read();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void disconnect(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            if (!"HEAD".equals(((HttpURLConnection)uRLConnection).getRequestMethod())) {
                this.readResponseBody((HttpURLConnection)uRLConnection);
            }
            ((HttpURLConnection)uRLConnection).disconnect();
        } else if (uRLConnection != null) {
            try {
                uRLConnection.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResponseBody(HttpURLConnection httpURLConnection) {
        InputStream inputStream;
        byte[] byArray = new byte[65536];
        InputStream inputStream2 = null;
        try {
            inputStream2 = httpURLConnection.getInputStream();
            while (inputStream2.read(byArray) > 0) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((inputStream = httpURLConnection.getErrorStream()) != null) {
            try {
                while (inputStream.read(byArray) > 0) {
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final class HttpStatus {
        static final int SC_OK = 200;
        static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;

        private HttpStatus() {
        }
    }
}

