/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.paths;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern propertyRegex = Pattern.compile(Pattern.quote("${") + "[^" + Pattern.quote("{[()]}") + "]*" + Pattern.quote("}"));
    private static volatile Boolean useAnsiOutput0 = null;

    public static Map<String, String> expandProperties(Map<String, String> map) {
        Matcher matcher;
        String string;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(map.size());
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>(map.size());
        for (String string2 : map.keySet()) {
            string = map.get(string2);
            matcher = propertyRegex.matcher(string);
            if (matcher.find()) {
                linkedHashMap2.put(string2, string);
                continue;
            }
            linkedHashMap.put(string2, string);
        }
        for (String string2 : linkedHashMap2.keySet()) {
            string = map.get(string2);
            matcher = propertyRegex.matcher(string);
            while (matcher.find()) {
                int n;
                int n2 = matcher.start(0);
                String string3 = string.substring(n2 + 2, (n = matcher.end(0)) - 1);
                String string4 = (String)linkedHashMap.get(string3);
                if (string4 == null) {
                    string4 = System.getProperty(string3);
                }
                if (string4 == null) {
                    string4 = "";
                }
                string = string.substring(0, n2) + string4 + string.substring(n);
            }
            linkedHashMap.put(string2, string);
        }
        return linkedHashMap;
    }

    public static void createDirectories(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw fileAlreadyExistsException;
            }
        }
    }

    private static boolean computeUseAnsiOutput() {
        boolean bl;
        if (System.console() == null) {
            return false;
        }
        if (System.getenv("INSIDE_EMACS") != null) {
            return false;
        }
        if (System.getenv("CI") != null) {
            return false;
        }
        String string = System.getenv("COURSIER_PROGRESS");
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("1"))) {
            bl = false;
        } else if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("disable") || string.equalsIgnoreCase("0"))) {
            bl = true;
        } else {
            boolean bl2 = bl = System.getenv("COURSIER_NO_TERM") != null;
        }
        return !bl;
    }

    public static boolean useAnsiOutput() {
        if (useAnsiOutput0 == null) {
            useAnsiOutput0 = Util.computeUseAnsiOutput();
        }
        return useAnsiOutput0;
    }
}

