/*
 * Decompiled with CFR 0.152.
 */
package xsbt.api;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import xsbti.api.Access;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.Definition;
import xsbti.api.DefinitionType;
import xsbti.api.EmptyType;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Modifiers;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.ParameterizedDefinition;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.This;
import xsbti.api.ThisQualifier;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Unqualified;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;

public final class ShowAPI$ {
    public static ShowAPI$ MODULE$;
    private int numDecls;
    private volatile boolean bitmap$0;

    static {
        new ShowAPI$();
    }

    private int numDecls$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.numDecls = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.parseInt((String)package$.MODULE$.props().get("sbt.inc.apidiff.decls").get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                this.bitmap$0 = true;
            }
        }
        return this.numDecls;
    }

    private int numDecls() {
        if (!this.bitmap$0) {
            return this.numDecls$lzycompute();
        }
        return this.numDecls;
    }

    private ClassDefinition[] truncateDecls(ClassDefinition[] decls) {
        if (this.numDecls() <= 0) {
            return decls;
        }
        return (ClassDefinition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])decls)).take(this.numDecls());
    }

    private String lines(Seq<String> ls) {
        return ls.mkString("\n", "\n", "\n");
    }

    public String showApi(ClassLike c, int nesting) {
        return this.showDefinition((Definition)c, nesting);
    }

    public String showDefinition(Definition d, int nesting) {
        String string;
        if (d instanceof Val) {
            Val val = (Val)d;
            string = new StringBuilder(2).append(this.showMonoDef((Definition)val, "val", nesting)).append(": ").append(this.showType(val.tpe(), nesting)).toString();
        } else if (d instanceof Var) {
            Var var = (Var)d;
            string = new StringBuilder(2).append(this.showMonoDef((Definition)var, "var", nesting)).append(": ").append(this.showType(var.tpe(), nesting)).toString();
        } else if (d instanceof Def) {
            Def def = (Def)d;
            string = new StringBuilder(2).append(this.showPolyDef((ParameterizedDefinition)def, "def", nesting)).append(this.showValueParams((Seq<ParameterList>)Predef$.MODULE$.wrapRefArray((Object[])def.valueParameters()), nesting)).append(": ").append(this.showType(def.returnType(), nesting)).toString();
        } else if (d instanceof TypeAlias) {
            TypeAlias typeAlias = (TypeAlias)d;
            string = new StringBuilder(3).append(this.showPolyDef((ParameterizedDefinition)typeAlias, "type", nesting)).append(" = ").append(this.showType(typeAlias.tpe(), nesting)).toString();
        } else if (d instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)d;
            string = new StringBuilder(0).append(this.showPolyDef((ParameterizedDefinition)typeDeclaration, "type", nesting)).append(this.showBounds(typeDeclaration.lowerBound(), typeDeclaration.upperBound(), nesting)).toString();
        } else if (d instanceof ClassLike) {
            ClassLike classLike = (ClassLike)d;
            string = new StringBuilder(9).append(this.showMonoDef(d, this.showDefinitionType(classLike.definitionType()), nesting)).append(this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])classLike.typeParameters()), nesting)).append(" extends ").append(this.showTemplate(classLike, nesting)).toString();
        } else if (d instanceof ClassLikeDef) {
            ClassLikeDef classLikeDef = (ClassLikeDef)d;
            string = this.showPolyDef((ParameterizedDefinition)classLikeDef, this.showDefinitionType(classLikeDef.definitionType()), nesting);
        } else {
            throw new MatchError((Object)d);
        }
        return string;
    }

    private String showTemplate(ClassLike cl, int nesting) {
        if (nesting <= 0) {
            return "<nesting level reached>";
        }
        String showSelf = cl.selfType() instanceof EmptyType ? "" : new StringBuilder(10).append(" self: ").append(this.showNestedType(cl.selfType(), nesting)).append(" =>").toString();
        return new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cl.structure().parents())).map((Function1 & Serializable & scala.Serializable)tp -> MODULE$.showNestedType((Type)tp, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("", " with ", " {")).append(showSelf).append(this.lines((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().inherited()))).map((Function1 & Serializable & scala.Serializable)d -> new StringBuilder(12).append("^inherited^ ").append(MODULE$.showNestedDefinition((Definition)d, nesting)).toString(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append(this.lines((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().declared()))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append("}").toString();
    }

    public String showType(Type t2, int nesting) {
        String string;
        if (t2 instanceof Projection) {
            Projection projection = (Projection)t2;
            string = new StringBuilder(1).append(this.showType(projection.prefix(), nesting)).append("#").append(projection.id()).toString();
        } else if (t2 instanceof ParameterRef) {
            ParameterRef parameterRef = (ParameterRef)t2;
            string = new StringBuilder(2).append("<").append(parameterRef.id()).append(">").toString();
        } else if (t2 instanceof Singleton) {
            Singleton singleton = (Singleton)t2;
            string = this.showPath(singleton.path());
        } else if (t2 instanceof EmptyType) {
            string = "<empty>";
        } else if (t2 instanceof Parameterized) {
            Parameterized parameterized = (Parameterized)t2;
            string = new StringBuilder(0).append(this.showType(parameterized.baseType(), nesting)).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterized.typeArguments())).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.showType((Type)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]")).toString();
        } else if (t2 instanceof Constant) {
            Constant constant = (Constant)t2;
            string = new StringBuilder(2).append(this.showType(constant.baseType(), nesting)).append("(").append(constant.value()).append(")").toString();
        } else if (t2 instanceof Annotated) {
            Annotated annotated = (Annotated)t2;
            string = new StringBuilder(1).append(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])annotated.annotations()), nesting)).append(" ").append(this.showType(annotated.baseType(), nesting)).toString();
        } else if (t2 instanceof Structure) {
            Structure structure2 = (Structure)t2;
            string = new StringBuilder(0).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structure2.parents())).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.showType((Type)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" with ")).append((Object)(nesting <= 0 ? "{ <nesting level reached> }" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(structure2.declared()))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" {", "\n", "}"))).toString();
        } else if (t2 instanceof Existential) {
            Existential existential = (Existential)t2;
            string = new StringBuilder(0).append(this.showType(existential.baseType(), nesting)).append((Object)(nesting <= 0 ? " forSome { <nesting level reached> }" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existential.clause())).map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(5).append("type ").append(MODULE$.showNestedTypeParameter((TypeParameter)t, nesting)).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" forSome { ", "; ", " }"))).toString();
        } else if (t2 instanceof Polymorphic) {
            Polymorphic polymorphic = (Polymorphic)t2;
            string = new StringBuilder(0).append(this.showType(polymorphic.baseType(), nesting)).append((Object)(nesting <= 0 ? " [ <nesting level reached> ]" : this.showNestedTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])polymorphic.parameters()), nesting))).toString();
        } else {
            throw new MatchError((Object)t2);
        }
        return string;
    }

    private String showPath(Path p) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.components())).map((Function1 & Serializable & scala.Serializable)pc -> MODULE$.showPathComponent((PathComponent)pc), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    private String showPathComponent(PathComponent pc) {
        String string;
        if (pc instanceof Super) {
            Super super_ = (Super)pc;
            string = new StringBuilder(7).append("super[").append(this.showPath(super_.qualifier())).append("]").toString();
        } else if (pc instanceof This) {
            string = "this";
        } else if (pc instanceof Id) {
            string = ((Id)pc).id();
        } else {
            throw new MatchError((Object)pc);
        }
        return string;
    }

    private String space(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return new StringBuilder(1).append(s).append(" ").toString();
    }

    private String showMonoDef(Definition d, String label, int nesting) {
        return new StringBuilder(0).append(this.space(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])d.annotations()), nesting))).append(this.space(this.showAccess(d.access()))).append(this.space(this.showModifiers(d.modifiers()))).append(this.space(label)).append(d.name()).toString();
    }

    private String showPolyDef(ParameterizedDefinition d, String label, int nesting) {
        return new StringBuilder(0).append(this.showMonoDef((Definition)d, label, nesting)).append(this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])d.typeParameters()), nesting)).toString();
    }

    private String showTypeParameters(Seq<TypeParameter> tps, int nesting) {
        if (tps.isEmpty()) {
            return "";
        }
        return ((TraversableOnce)tps.map((Function1 & Serializable & scala.Serializable)tp -> MODULE$.showTypeParameter((TypeParameter)tp, nesting), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    private String showTypeParameter(TypeParameter tp, int nesting) {
        return new StringBuilder(2).append(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])tp.annotations()), nesting)).append(" ").append(this.showVariance(tp.variance())).append(tp.id()).append(this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])tp.typeParameters()), nesting)).append(" ").append(this.showBounds(tp.lowerBound(), tp.upperBound(), nesting)).toString();
    }

    private String showAnnotations(Seq<Annotation> as, int nesting) {
        return ((TraversableOnce)as.map((Function1 & Serializable & scala.Serializable)a -> MODULE$.showAnnotation((Annotation)a, nesting), Seq$.MODULE$.canBuildFrom())).mkString(" ");
    }

    private String showAnnotation(Annotation a2, int nesting) {
        return new StringBuilder(1).append("@").append(this.showType(a2.base(), nesting)).append((Object)(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())).isEmpty() ? "" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())).map((Function1 & Serializable & scala.Serializable)a -> new StringBuilder(3).append(a.name()).append(" = ").append(a.value()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("(", ", ", ")"))).toString();
    }

    private String showBounds(Type lower, Type upper, int nesting) {
        return new StringBuilder(7).append(">: ").append(this.showType(lower, nesting)).append(" <: ").append(this.showType(upper, nesting)).toString();
    }

    private String showValueParams(Seq<ParameterList> ps, int nesting) {
        return ((TraversableOnce)ps.map((Function1 & Serializable & scala.Serializable)pl -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pl.parameters())).map((Function1 & Serializable & scala.Serializable)mp -> new StringBuilder(2).append(mp.name()).append(": ").append(MODULE$.showParameterModifier(MODULE$.showType(mp.tpe(), nesting), mp.modifier())).append((Object)(mp.hasDefault() ? "= ..." : "")).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(pl.isImplicit() ? "(implicit " : "(", ", ", ")"), Seq$.MODULE$.canBuildFrom())).mkString("");
    }

    private String showParameterModifier(String base, ParameterModifier pm) {
        String string;
        if (ParameterModifier.Plain.equals(pm)) {
            string = base;
        } else if (ParameterModifier.Repeated.equals(pm)) {
            string = new StringBuilder(1).append(base).append("*").toString();
        } else if (ParameterModifier.ByName.equals(pm)) {
            string = new StringBuilder(3).append("=> ").append(base).toString();
        } else {
            throw new MatchError((Object)pm);
        }
        return string;
    }

    private String showDefinitionType(DefinitionType d) {
        String string;
        if (DefinitionType.Trait.equals(d)) {
            string = "trait";
        } else if (DefinitionType.ClassDef.equals(d)) {
            string = "class";
        } else if (DefinitionType.Module.equals(d)) {
            string = "object";
        } else if (DefinitionType.PackageModule.equals(d)) {
            string = "package object";
        } else {
            throw new MatchError((Object)d);
        }
        return string;
    }

    private String showAccess(Access a) {
        String string;
        if (a instanceof Public) {
            string = "";
        } else if (a instanceof Protected) {
            Protected protected_ = (Protected)a;
            string = new StringBuilder(9).append("protected").append(this.showQualifier(protected_.qualifier())).toString();
        } else if (a instanceof Private) {
            Private private_ = (Private)a;
            string = new StringBuilder(7).append("private").append(this.showQualifier(private_.qualifier())).toString();
        } else {
            throw new MatchError((Object)a);
        }
        return string;
    }

    private String showQualifier(Qualifier q) {
        String string;
        if (q instanceof Unqualified) {
            string = "";
        } else if (q instanceof ThisQualifier) {
            string = "[this]";
        } else if (q instanceof IdQualifier) {
            IdQualifier idQualifier = (IdQualifier)q;
            string = new StringBuilder(2).append("[").append(idQualifier.value()).append("]").toString();
        } else {
            throw new MatchError((Object)q);
        }
        return string;
    }

    private String showModifiers(Modifiers m) {
        return ((TraversableOnce)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isOverride()), (Object)"override"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isFinal()), (Object)"final"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isSealed()), (Object)"sealed"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isImplicit()), (Object)"implicit"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isAbstract()), (Object)"abstract"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isLazy()), (Object)"lazy"), (List)Nil$.MODULE$)))))).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    boolean bl = x1._1$mcZ$sp();
                    String mod = (String)x1._2();
                    if (bl) {
                        object = mod;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                boolean bl;
                boolean bl2 = x1 != null && true == (bl = x1._1$mcZ$sp());
                return bl2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" ");
    }

    private String showVariance(Variance v) {
        String string;
        if (Variance.Invariant.equals(v)) {
            string = "";
        } else if (Variance.Covariant.equals(v)) {
            string = "+";
        } else if (Variance.Contravariant.equals(v)) {
            string = "-";
        } else {
            throw new MatchError((Object)v);
        }
        return string;
    }

    private String showNestedType(Type tp, int nesting) {
        return this.showType(tp, nesting - 1);
    }

    private String showNestedTypeParameter(TypeParameter tp, int nesting) {
        return this.showTypeParameter(tp, nesting - 1);
    }

    private String showNestedTypeParameters(Seq<TypeParameter> tps, int nesting) {
        return this.showTypeParameters(tps, nesting - 1);
    }

    private String showNestedDefinition(Definition d, int nesting) {
        return this.showDefinition(d, nesting - 1);
    }

    private ShowAPI$() {
        MODULE$ = this;
    }
}

