/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.util.Direction;

public class ConstructorMessage
extends ForwardMessage {
    public ConstructorMessage(Lifeline caller, Lifeline callee, SequenceDiagram diagram, MessageData data) {
        super(caller, callee, diagram, data);
    }

    @Override
    protected void execute() {
        Arrow arrow;
        int headHeight = this.getCallee().getHead().getHeight();
        this.getDiagram().getPaintDevice().announce(this.getConfiguration().getSpaceBeforeConstruction() + Math.max(0, Arrow.getInnerHeight(this) - headHeight / 2) + headHeight + this.getDiagram().getConfiguration().getInitialSpace());
        this.extendLifelines(this.getConfiguration().getSpaceBeforeConstruction());
        if (this.getCallee().isVariable()) {
            this.getDiagram().reuseSpace(this.getCallee());
        }
        int s = 0;
        if (this.getCaller().getPosition() < this.getCallee().getPosition()) {
            arrow = new Arrow(this, ArrowStroke.SOLID, Direction.RIGHT, this.v());
        } else {
            arrow = new Arrow(this, ArrowStroke.SOLID, Direction.LEFT, this.v());
            s = 3;
        }
        this.setArrow(arrow);
        arrow.setSpace(s + this.getCallee().getHead().getWidth() / 2);
        this.getDiagram().getPaintDevice().append(arrow);
        int diff = arrow.getInnerHeight() - headHeight / 2;
        if (diff > 0) {
            this.extendLifelines(diff);
        }
        this.getCallee().getHead().setTop(this.v());
        this.extendLifelines(headHeight / 2);
        this.getCallee().giveBirth();
        this.getCallee().getView().setTop(this.v());
        this.getCallee().getView().setHeight(0);
        this.extendLifelines(headHeight / 2 + this.getDiagram().getConfiguration().getInitialSpace());
        if (this.isActivating()) {
            this.getCallee().setActive(true);
        }
    }
}

