/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TransformGroupRetained;

class CompileState {
    HashMap knownAppearances = new HashMap();
    int numAppearances = 0;
    int numShared = 0;
    int numShapes = 0;
    HashMap shapeLists = null;
    int numMergeSets = 0;
    int numMergeShapes = 0;
    boolean compileVerbose = false;
    static final int BOUNDS_READ = 1;
    static final int GEOMETRY_READ = 2;
    boolean keepTG = false;
    boolean needNormalsTransform = false;
    TransformGroupRetained staticTransform = null;
    GroupRetained parentGroup = null;
    ArrayList transformGroupChildrenList = null;
    ArrayList staticTransformObjects = new ArrayList(1);
    int numTransformGroups = 0;
    int numStaticTransformGroups = 0;
    int numMergedTransformGroups = 0;
    int numGroups = 0;
    int numMergedGroups = 0;
    int numShapesWSharedGeom = 0;
    int numShapesWStaticTG = 0;
    int numLinks = 0;
    int numSwitches = 0;
    int numOrderedGroups = 0;
    int numMorphs = 0;

    CompileState() {
        try {
            this.compileVerbose = Boolean.getBoolean("javax.media.j3d.compileVerbose");
        }
        catch (AccessControlException accessControlException) {
            this.compileVerbose = false;
        }
        this.initShapeMerge();
    }

    AppearanceRetained getAppearance(AppearanceRetained appearanceRetained) {
        if (appearanceRetained.map == this && appearanceRetained.mapAppearance != null) {
            ++this.numShared;
            return appearanceRetained.mapAppearance;
        }
        AppearanceRetained appearanceRetained2 = (AppearanceRetained)this.knownAppearances.get(appearanceRetained);
        if (appearanceRetained2 != null) {
            ++this.numShared;
        } else {
            this.knownAppearances.put(appearanceRetained, appearanceRetained);
            ++this.numAppearances;
            ++this.numShared;
            appearanceRetained2 = appearanceRetained;
        }
        appearanceRetained.map = this;
        appearanceRetained.mapAppearance = appearanceRetained2;
        return appearanceRetained2;
    }

    private void initShapeMerge() {
        this.shapeLists = new HashMap();
    }

    void addShape(Shape3DRetained shape3DRetained) {
        if (this.parentGroup != null) {
            Vector<Shape3DRetained> vector = (Vector<Shape3DRetained>)this.shapeLists.get(shape3DRetained.appearance);
            if (vector == null) {
                vector = new Vector<Shape3DRetained>();
                this.shapeLists.put(shape3DRetained.appearance, vector);
            }
            GeometryRetained geometryRetained = null;
            for (int i = 0; geometryRetained == null && i < shape3DRetained.geometryList.size(); ++i) {
                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(i);
            }
            if (shape3DRetained.parent instanceof GroupRetained && ((GroupRetained)shape3DRetained.parent).isStaticChildren() && geometryRetained.geoType < 15) {
                vector.add(shape3DRetained);
            }
        }
    }

    void printStats() {
        System.err.println("numTransformGroups= " + this.numTransformGroups);
        System.err.println("numStaticTransformGroups= " + this.numStaticTransformGroups);
        System.err.println("numMergedTransformGroups= " + this.numMergedTransformGroups);
        System.err.println("numGroups= " + this.numGroups);
        System.err.println("numMergedGroups= " + this.numMergedGroups);
        System.err.println("numShapes= " + this.numShapes);
        System.err.println("numShapesWStaticTG= " + this.numShapesWStaticTG);
        System.err.println("numMergeShapes= " + this.numMergeShapes);
        System.err.println("numMergeSets= " + this.numMergeSets);
        System.err.println("numLinks= " + this.numLinks);
        System.err.println("numSwitches= " + this.numSwitches);
        System.err.println("numOrderedGroups= " + this.numOrderedGroups);
        System.err.println("numMorphs= " + this.numMorphs);
    }

    void doShapeMerge() {
        if (this.shapeLists != null) {
            Collection collection = this.shapeLists.values();
            Iterator iterator = collection.iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                int n3 = vector.size();
                Object[] objectArray = new Shape3DRetained[n3];
                vector.copyInto(objectArray);
                Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[n3];
                for (int i = 0; i < n3; ++i) {
                    if (objectArray[i] == null) continue;
                    GeometryRetained geometryRetained = null;
                    for (n = 0; geometryRetained == null && n < ((Shape3DRetained)objectArray[i]).geometryList.size(); ++n) {
                        geometryRetained = (GeometryRetained)((Shape3DRetained)objectArray[i]).geometryList.get(n);
                    }
                    if (geometryRetained == null || !(geometryRetained instanceof GeometryArrayRetained)) continue;
                    int n4 = 0;
                    Object object = objectArray[i];
                    GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
                    shape3DRetainedArray[n4++] = object;
                    n2 = this.getCompileFlags((Shape3DRetained)object);
                    for (int j = i + 1; j < n3; ++j) {
                        if (objectArray[j] == null) continue;
                        geometryRetained = null;
                        for (n = 0; geometryRetained == null && n < ((Shape3DRetained)objectArray[j]).geometryList.size(); ++n) {
                            geometryRetained = (GeometryRetained)((Shape3DRetained)objectArray[j]).geometryList.get(n);
                        }
                        if (geometryRetained == null || !((Shape3DRetained)objectArray[j]).isEquivalent((Shape3DRetained)object) || !geometryRetained.isEquivalenceClass(geometryArrayRetained) || ((GeometryArrayRetained)geometryRetained).vertexFormat != geometryArrayRetained.vertexFormat) continue;
                        shape3DRetainedArray[n4++] = objectArray[j];
                        n2 |= this.getCompileFlags((Shape3DRetained)objectArray[j]);
                        objectArray[j] = null;
                    }
                    if (n4 <= 1) continue;
                    GroupRetained groupRetained = (GroupRetained)shape3DRetainedArray[0].parent;
                    for (int j = 0; j < n4; ++j) {
                        Shape3DRetained shape3DRetained = shape3DRetainedArray[j];
                        boolean bl = false;
                        int n5 = groupRetained.numChildren();
                        for (int k = 0; k < n5 && !bl; ++k) {
                            if (groupRetained.getChild((int)k).retained != shape3DRetained) continue;
                            bl = true;
                            groupRetained.removeChild(k);
                        }
                        if (bl) continue;
                        System.err.println("ShapeSet.add(): Can't remove shape from parent, can't find shape!");
                    }
                    object = new Shape3DCompileRetained(shape3DRetainedArray, n4, n2);
                    ((SceneGraphObjectRetained)object).setSource(shape3DRetainedArray[0].source);
                    ++this.numMergeSets;
                    this.numMergeShapes += n4;
                    this.parentGroup.addChild((Node)((Shape3DRetained)object).source);
                }
            }
        }
        this.shapeLists.clear();
    }

    int getCompileFlags(Shape3DRetained shape3DRetained) {
        int n = 0;
        if (shape3DRetained.allowIntersect() || shape3DRetained.source.getCapability(12) || shape3DRetained.boundsAutoCompute && shape3DRetained.source.getCapability(3)) {
            n |= 2;
        }
        return n;
    }
}

