/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.Serializable;
import org.apache.tomcat.dbcp.dbcp2.Utils;

class UserPassKey
implements Serializable {
    private static final long serialVersionUID = 5142970911626584817L;
    private final String userName;
    private final char[] userPassword;

    UserPassKey(String userName) {
        this(userName, (char[])null);
    }

    UserPassKey(String userName, char[] password) {
        this.userName = userName;
        this.userPassword = password;
    }

    UserPassKey(String userName, String userPassword) {
        this(userName, Utils.toCharArray(userPassword));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserPassKey other = (UserPassKey)obj;
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String getPassword() {
        return Utils.toString(this.userPassword);
    }

    public char[] getPasswordCharArray() {
        return this.userPassword;
    }

    public String getUsername() {
        return this.userName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("[");
        sb.append(this.userName);
        sb.append(']');
        return sb.toString();
    }
}

