/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpPipelinedMessage;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpResponse
extends DefaultFullHttpResponse
implements HttpResponse,
HttpPipelinedMessage {
    private final int sequence;
    private final Netty4HttpRequest request;

    Netty4HttpResponse(Netty4HttpRequest request, RestStatus status, BytesReference content) {
        super(request.nettyRequest().protocolVersion(), HttpResponseStatus.valueOf((int)status.getStatus()), Netty4Utils.toByteBuf(content));
        this.sequence = request.sequence();
        this.request = request;
    }

    public void addHeader(String name, String value) {
        this.headers().add(name, (Object)value);
    }

    public boolean containsHeader(String name) {
        return this.headers().contains(name);
    }

    public int getSequence() {
        return this.sequence;
    }

    public Netty4HttpRequest getRequest() {
        return this.request;
    }
}

