/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.common.ssl.SslClientAuthenticationMode;
import org.elasticsearch.common.ssl.SslConfigException;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.ssl.SslVerificationMode;

public class SslConfiguration {
    static final Map<String, String> ORDERED_PROTOCOL_ALGORITHM_MAP;
    private final SslTrustConfig trustConfig;
    private final SslKeyConfig keyConfig;
    private final SslVerificationMode verificationMode;
    private final SslClientAuthenticationMode clientAuth;
    private final List<String> ciphers;
    private final List<String> supportedProtocols;

    public SslConfiguration(SslTrustConfig trustConfig, SslKeyConfig keyConfig, SslVerificationMode verificationMode, SslClientAuthenticationMode clientAuth, List<String> ciphers, List<String> supportedProtocols) {
        if (ciphers == null || ciphers.isEmpty()) {
            throw new SslConfigException("cannot configure SSL/TLS without any supported cipher suites");
        }
        if (supportedProtocols == null || supportedProtocols.isEmpty()) {
            throw new SslConfigException("cannot configure SSL/TLS without any supported protocols");
        }
        this.trustConfig = Objects.requireNonNull(trustConfig, "trust config cannot be null");
        this.keyConfig = Objects.requireNonNull(keyConfig, "key config cannot be null");
        this.verificationMode = Objects.requireNonNull(verificationMode, "verification mode cannot be null");
        this.clientAuth = Objects.requireNonNull(clientAuth, "client authentication cannot be null");
        this.ciphers = Collections.unmodifiableList(ciphers);
        this.supportedProtocols = Collections.unmodifiableList(supportedProtocols);
    }

    public SslTrustConfig getTrustConfig() {
        return this.trustConfig;
    }

    public SslKeyConfig getKeyConfig() {
        return this.keyConfig;
    }

    public SslVerificationMode getVerificationMode() {
        return this.verificationMode;
    }

    public SslClientAuthenticationMode getClientAuth() {
        return this.clientAuth;
    }

    public List<String> getCipherSuites() {
        return this.ciphers;
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public Collection<Path> getDependentFiles() {
        HashSet<Path> paths = new HashSet<Path>(this.keyConfig.getDependentFiles());
        paths.addAll(this.trustConfig.getDependentFiles());
        return paths;
    }

    public SSLContext createSslContext() {
        X509ExtendedKeyManager keyManager = this.keyConfig.createKeyManager();
        X509ExtendedTrustManager trustManager = this.trustConfig.createTrustManager();
        try {
            SSLContext sslContext = SSLContext.getInstance(this.contextProtocol());
            sslContext.init(new X509ExtendedKeyManager[]{keyManager}, new X509ExtendedTrustManager[]{trustManager}, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("cannot create ssl context", e);
        }
    }

    private String contextProtocol() {
        if (this.supportedProtocols.isEmpty()) {
            throw new SslConfigException("no SSL/TLS protocols have been configured");
        }
        for (Map.Entry<String, String> entry : ORDERED_PROTOCOL_ALGORITHM_MAP.entrySet()) {
            if (!this.supportedProtocols.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new SslConfigException("no supported SSL/TLS protocol was found in the configured supported protocols: " + this.supportedProtocols);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "trustConfig=" + this.trustConfig + ", keyConfig=" + this.keyConfig + ", verificationMode=" + (Object)((Object)this.verificationMode) + ", clientAuth=" + (Object)((Object)this.clientAuth) + ", ciphers=" + this.ciphers + ", supportedProtocols=" + this.supportedProtocols + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslConfiguration that = (SslConfiguration)o;
        return Objects.equals(this.trustConfig, that.trustConfig) && Objects.equals(this.keyConfig, that.keyConfig) && this.verificationMode == that.verificationMode && this.clientAuth == that.clientAuth && Objects.equals(this.ciphers, that.ciphers) && Objects.equals(this.supportedProtocols, that.supportedProtocols);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.trustConfig, this.keyConfig, this.verificationMode, this.clientAuth, this.ciphers, this.supportedProtocols});
    }

    static {
        LinkedHashMap<String, String> protocolAlgorithmMap = new LinkedHashMap<String, String>();
        try {
            SSLContext.getInstance("TLSv1.3");
            protocolAlgorithmMap.put("TLSv1.3", "TLSv1.3");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        protocolAlgorithmMap.put("TLSv1.2", "TLSv1.2");
        protocolAlgorithmMap.put("TLSv1.1", "TLSv1.1");
        protocolAlgorithmMap.put("TLSv1", "TLSv1");
        protocolAlgorithmMap.put("SSLv3", "SSLv3");
        protocolAlgorithmMap.put("SSLv2", "SSL");
        protocolAlgorithmMap.put("SSLv2Hello", "SSL");
        ORDERED_PROTOCOL_ALGORITHM_MAP = Collections.unmodifiableMap(protocolAlgorithmMap);
    }
}

