/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.highlight.TermVectorLeafReader;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;

public class TermVectorOffsetStrategy
extends FieldOffsetStrategy {
    public TermVectorOffsetStrategy(UHComponents components) {
        super(components);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        Terms tvTerms = reader.getTermVector(docId, this.getField());
        if (tvTerms == null) {
            return OffsetsEnum.EMPTY;
        }
        TermVectorLeafReader singleDocReader = new TermVectorLeafReader(this.getField(), tvTerms);
        return this.createOffsetsEnumFromReader((LeafReader)new OverlaySingleDocTermsLeafReader(reader, singleDocReader, this.getField(), docId), docId);
    }
}

