/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import org.elasticsearch.common.bytes.PagedBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;

public class ReleasableBytesStreamOutput
extends BytesStreamOutput
implements Releasable {
    private Releasable releasable;

    public ReleasableBytesStreamOutput(BigArrays bigarrays) {
        this(16384, bigarrays);
    }

    public ReleasableBytesStreamOutput(int expectedSize, BigArrays bigArrays) {
        super(expectedSize, bigArrays);
        this.releasable = Releasables.releaseOnce(this.bytes);
    }

    @Override
    public ReleasableBytesReference bytes() {
        return new ReleasableBytesReference(new PagedBytesReference(this.bytes, this.count), this.releasable);
    }

    @Override
    public void close() {
        Releasables.close(this.releasable);
    }

    @Override
    void ensureCapacity(long offset) {
        ByteArray prevBytes = this.bytes;
        super.ensureCapacity(offset);
        if (prevBytes != this.bytes) {
            this.releasable = Releasables.releaseOnce(this.bytes);
        }
    }

    @Override
    public void reset() {
        ByteArray prevBytes = this.bytes;
        super.reset();
        if (prevBytes != this.bytes) {
            this.releasable = Releasables.releaseOnce(this.bytes);
        }
    }
}

