/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;

public final class InternalAggregations
extends Aggregations
implements Writeable {
    public static final InternalAggregations EMPTY = new InternalAggregations(Collections.emptyList());
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.isMapped() == agg2.isMapped()) {
            return 0;
        }
        if (agg1.isMapped() && !agg2.isMapped()) {
            return -1;
        }
        return 1;
    };
    private final List<SiblingPipelineAggregator> topLevelPipelineAggregators;

    public InternalAggregations(List<InternalAggregation> aggregations) {
        super(aggregations);
        this.topLevelPipelineAggregators = Collections.emptyList();
    }

    public InternalAggregations(List<InternalAggregation> aggregations, List<SiblingPipelineAggregator> topLevelPipelineAggregators) {
        super(aggregations);
        this.topLevelPipelineAggregators = Objects.requireNonNull(topLevelPipelineAggregators);
    }

    public InternalAggregations(StreamInput in) throws IOException {
        super(in.readList(stream -> in.readNamedWriteable(InternalAggregation.class)));
        this.topLevelPipelineAggregators = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readList(stream -> (SiblingPipelineAggregator)in.readNamedWriteable(PipelineAggregator.class)) : Collections.emptyList();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.aggregations);
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeNamedWriteableList(this.topLevelPipelineAggregators);
        }
    }

    public List<SiblingPipelineAggregator> getTopLevelPipelineAggregators() {
        return this.topLevelPipelineAggregators;
    }

    private List<InternalAggregation> getInternalAggregations() {
        return this.aggregations;
    }

    public static InternalAggregations topLevelReduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        InternalAggregations reduced = InternalAggregations.reduce(aggregationsList, context);
        if (reduced == null) {
            return null;
        }
        if (context.isFinalReduce()) {
            List<InternalAggregation> reducedInternalAggs = reduced.getInternalAggregations();
            reducedInternalAggs = reducedInternalAggs.stream().map(agg -> agg.reducePipelines((InternalAggregation)agg, context)).collect(Collectors.toList());
            List<SiblingPipelineAggregator> topLevelPipelineAggregators = aggregationsList.get(0).getTopLevelPipelineAggregators();
            for (SiblingPipelineAggregator pipelineAggregator : topLevelPipelineAggregators) {
                InternalAggregation newAgg = pipelineAggregator.doReduce(new InternalAggregations(reducedInternalAggs), context);
                reducedInternalAggs.add(newAgg);
            }
            return new InternalAggregations(reducedInternalAggs);
        }
        return reduced;
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        List<SiblingPipelineAggregator> topLevelPipelineAggregators = aggregationsList.get(0).getTopLevelPipelineAggregators();
        HashMap<String, List> aggByName = new HashMap<String, List>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (Aggregation aggregation : aggregations.aggregations) {
                List aggs = aggByName.computeIfAbsent(aggregation.getName(), k -> new ArrayList(aggregationsList.size()));
                aggs.add((InternalAggregation)aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            aggregations.sort(INTERNAL_AGG_COMPARATOR);
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            reducedAggregations.add(first.reduce(aggregations, context));
        }
        return new InternalAggregations(reducedAggregations, topLevelPipelineAggregators);
    }
}

