/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_FREEDESKTOP_NOTIFY_API_H
#define __FCITX_MODULE_FCITX_FREEDESKTOP_NOTIFY_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "freedesktop-notify.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-freedesktop-notify", FreeDesktopNotify)

DEFINE_GET_AND_INVOKE_FUNC(FreeDesktopNotify, Show, 0)
static inline uint32_t
FcitxFreeDesktopNotifyShow(FcitxInstance *instance, const char* _arg0, uint32_t _arg1, const char* _arg2, const char* _arg3, const char* _arg4, const FcitxFreedesktopNotifyAction* _arg5, int32_t _arg6, FcitxFreedesktopNotifyActionCallback _arg7, void* _arg8, FcitxDestroyNotify _arg9)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, uint32_t, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, const char*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, const char*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, const char*, _arg4);
    FCITX_DEF_CAST_TO_PTR(arg5, const FcitxFreedesktopNotifyAction*, _arg5);
    FCITX_DEF_CAST_TO_PTR(arg6, int32_t, _arg6);
    FCITX_DEF_CAST_TO_PTR(arg7, FcitxFreedesktopNotifyActionCallback, _arg7);
    FCITX_DEF_CAST_TO_PTR(arg8, void*, _arg8);
    FCITX_DEF_CAST_TO_PTR(arg9, FcitxDestroyNotify, _arg9);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    result = FcitxFreeDesktopNotifyInvokeShow(instance, args);
    FCITX_RETURN_FROM_PTR(uint32_t, result);
}

DEFINE_GET_AND_INVOKE_FUNC(FreeDesktopNotify, Close, 1)
static inline void
FcitxFreeDesktopNotifyClose(FcitxInstance *instance, uint32_t _arg0)
{
    FCITX_DEF_CAST_TO_PTR(arg0, uint32_t, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    FcitxFreeDesktopNotifyInvokeClose(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(FreeDesktopNotify, ShowTip, 2)
static inline void
FcitxFreeDesktopNotifyShowTip(FcitxInstance *instance, const char* _arg0, const char* _arg1, int32_t _arg2, const char* _arg3, const char* _arg4, const char* _arg5)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, int32_t, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, const char*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, const char*, _arg4);
    FCITX_DEF_CAST_TO_PTR(arg5, const char*, _arg5);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4, arg5);
    FcitxFreeDesktopNotifyInvokeShowTip(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(FreeDesktopNotify, ShowSimple, 3)
static inline uint32_t
FcitxFreeDesktopNotifyShowSimple(FcitxInstance *instance, const char* _arg0, const char* _arg1, const char* _arg2, const char* _arg3, int32_t _arg4)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, const char*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, const char*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, int32_t, _arg4);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4);
    result = FcitxFreeDesktopNotifyInvokeShowSimple(instance, args);
    FCITX_RETURN_FROM_PTR(uint32_t, result);
}

DEFINE_GET_AND_INVOKE_FUNC(FreeDesktopNotify, ShowTipFmt, 4)
static inline void
FcitxFreeDesktopNotifyShowTipFmtV(FcitxInstance *instance, const char* _arg0, const char* _arg1, int32_t _arg2, const char* _arg3, const char* _arg4, const char* _arg5, va_list* _arg6)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, int32_t, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, const char*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, const char*, _arg4);
    FCITX_DEF_CAST_TO_PTR(arg5, const char*, _arg5);
    FCITX_DEF_CAST_TO_PTR(arg6, va_list*, _arg6);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    FcitxFreeDesktopNotifyInvokeShowTipFmt(instance, args);
}

static inline void
FcitxFreeDesktopNotifyShowTipFmt(FcitxInstance *instance, const char* _arg0, const char* _arg1, int32_t _arg2, const char* _arg3, const char* _arg4, const char* _arg5, ...)
{
    va_list ap;
    va_start(ap, _arg5);
    FcitxFreeDesktopNotifyShowTipFmtV(instance, _arg0, _arg1, _arg2, _arg3, _arg4, _arg5, &ap);
    va_end(ap);
}

DEFINE_GET_AND_INVOKE_FUNC(FreeDesktopNotify, ShowAddonTip, 5)
static inline void
FcitxFreeDesktopNotifyShowAddonTip(FcitxInstance *instance, const char* _arg0, const char* _arg1, const char* _arg2, const char* _arg3)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, const char*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, const char*, _arg3);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3);
    FcitxFreeDesktopNotifyInvokeShowAddonTip(instance, args);
}


#ifdef __cplusplus
}
#endif

#endif
