/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFNumsArray;
import org.apache.fop.pdf.PDFObject;

public class PDFNumberTreeNode
extends PDFDictionary {
    private static final String KIDS = "Kids";
    private static final String NUMS = "Nums";
    private static final String LIMITS = "Limits";

    public void setKids(PDFArray kids) {
        this.put(KIDS, kids);
    }

    public PDFArray getKids() {
        return (PDFArray)this.get(KIDS);
    }

    public void setNums(PDFNumsArray nums) {
        this.put(NUMS, nums);
    }

    public PDFNumsArray getNums() {
        PDFNumsArray nums = (PDFNumsArray)this.get(NUMS);
        if (nums == null) {
            nums = new PDFNumsArray(this);
            this.setNums(nums);
        }
        return nums;
    }

    public void setLowerLimit(Integer key) {
        PDFArray limits = this.prepareLimitsArray();
        limits.set(0, key);
    }

    public Integer getLowerLimit() {
        PDFArray limits = this.prepareLimitsArray();
        return (Integer)limits.get(0);
    }

    public void setUpperLimit(Integer key) {
        PDFArray limits = this.prepareLimitsArray();
        limits.set(1, key);
    }

    public Integer getUpperLimit() {
        PDFArray limits = this.prepareLimitsArray();
        return (Integer)limits.get(1);
    }

    protected void addToNums(int num, Object object) {
        this.getNums().put(num, object);
        if (this.getUpperLimit() < num) {
            this.setUpperLimit(num);
        }
    }

    private PDFArray prepareLimitsArray() {
        PDFArray limits = (PDFArray)this.get(LIMITS);
        if (limits == null) {
            limits = new PDFArray((PDFObject)this, new Object[2]);
            this.put(LIMITS, limits);
        }
        if (limits.length() != 2) {
            throw new IllegalStateException("Limits array must have 2 entries");
        }
        return limits;
    }
}

