/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import org.gjt.sp.jedit.bsh.Capabilities;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Reflect;
import org.gjt.sp.jedit.bsh.This;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.bsh.UtilTargetError;

class Types {
    static final int CAST = 0;
    static final int ASSIGNMENT = 1;
    static final int JAVA_BASE_ASSIGNABLE = 1;
    static final int JAVA_BOX_TYPES_ASSIGABLE = 2;
    static final int JAVA_VARARGS_ASSIGNABLE = 3;
    static final int BSH_ASSIGNABLE = 4;
    static final int FIRST_ROUND_ASSIGNABLE = 1;
    static final int LAST_ROUND_ASSIGNABLE = 4;
    static Primitive VALID_CAST = new Primitive(1);
    static Primitive INVALID_CAST = new Primitive(-1);

    Types() {
    }

    public static Class[] getTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : (objectArray[i] instanceof Primitive ? ((Primitive)objectArray[i]).getType() : objectArray[i].getClass());
        }
        return classArray;
    }

    static boolean isSignatureAssignable(Class[] classArray, Class[] classArray2, int n) {
        if (n != 3 && classArray.length != classArray2.length) {
            return false;
        }
        switch (n) {
            case 1: {
                for (int i = 0; i < classArray.length; ++i) {
                    if (Types.isJavaBaseAssignable(classArray2[i], classArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                for (int i = 0; i < classArray.length; ++i) {
                    if (Types.isJavaBoxTypesAssignable(classArray2[i], classArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                return Types.isSignatureVarargsAssignable(classArray, classArray2);
            }
            case 4: {
                for (int i = 0; i < classArray.length; ++i) {
                    if (Types.isBshAssignable(classArray2[i], classArray[i])) continue;
                    return false;
                }
                return true;
            }
        }
        throw new InterpreterError("bad case");
    }

    private static boolean isSignatureVarargsAssignable(Class[] classArray, Class[] classArray2) {
        return false;
    }

    static boolean isJavaAssignable(Class clazz, Class clazz2) {
        return Types.isJavaBaseAssignable(clazz, clazz2) || Types.isJavaBoxTypesAssignable(clazz, clazz2);
    }

    static boolean isJavaBaseAssignable(Class clazz, Class clazz2) {
        if (clazz == null) {
            return false;
        }
        if (clazz2 == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isPrimitive() && clazz2.isPrimitive()) {
            if (clazz == clazz2) {
                return true;
            }
            if (clazz2 == Byte.TYPE && (clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Short.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Character.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Integer.TYPE && (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Long.TYPE && (clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Float.TYPE && clazz == Double.TYPE) {
                return true;
            }
        } else if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        return false;
    }

    static boolean isJavaBoxTypesAssignable(Class clazz, Class clazz2) {
        if (clazz == null) {
            return false;
        }
        if (clazz == Object.class) {
            return true;
        }
        if (clazz == Number.class && clazz2 != Character.TYPE && clazz2 != Boolean.TYPE) {
            return true;
        }
        return Primitive.wrapperMap.get(clazz) == clazz2;
    }

    static boolean isBshAssignable(Class clazz, Class clazz2) {
        try {
            return Types.castObject(clazz, clazz2, null, 1, true) == VALID_CAST;
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("err in cast check: " + utilEvalError);
        }
    }

    public static Object castObject(Object object, Class clazz, int n) throws UtilEvalError {
        if (object == null) {
            throw new InterpreterError("null fromValue");
        }
        Class clazz2 = object instanceof Primitive ? ((Primitive)object).getType() : object.getClass();
        return Types.castObject(clazz, clazz2, object, n, false);
    }

    private static Object castObject(Class clazz, Class clazz2, Object object, int n, boolean bl) throws UtilEvalError {
        if (bl && object != null) {
            throw new InterpreterError("bad cast params 1");
        }
        if (!bl && object == null) {
            throw new InterpreterError("bad cast params 2");
        }
        if (clazz2 == Primitive.class) {
            throw new InterpreterError("bad from Type, need to unwrap");
        }
        if (object == Primitive.NULL && clazz2 != null) {
            throw new InterpreterError("inconsistent args 1");
        }
        if (object == Primitive.VOID && clazz2 != Void.TYPE) {
            throw new InterpreterError("inconsistent args 2");
        }
        if (clazz == Void.TYPE) {
            throw new InterpreterError("loose toType should be null");
        }
        if (clazz == null || clazz == clazz2) {
            return bl ? VALID_CAST : object;
        }
        if (clazz.isPrimitive()) {
            if (clazz2 == Void.TYPE || clazz2 == null || clazz2.isPrimitive()) {
                return Primitive.castPrimitive(clazz, clazz2, (Primitive)object, bl, n);
            }
            if (Primitive.isWrapperType(clazz2)) {
                Class clazz3 = Primitive.unboxType(clazz2);
                Primitive primitive = bl ? null : (Primitive)Primitive.wrap(object, clazz3);
                return Primitive.castPrimitive(clazz, clazz3, primitive, bl, n);
            }
            if (bl) {
                return INVALID_CAST;
            }
            throw Types.castError(clazz, clazz2, n);
        }
        if (clazz2 == Void.TYPE || clazz2 == null || clazz2.isPrimitive()) {
            if (Primitive.isWrapperType(clazz) && clazz2 != Void.TYPE && clazz2 != null) {
                return bl ? VALID_CAST : Primitive.castWrapper(Primitive.unboxType(clazz), ((Primitive)object).getValue());
            }
            if (clazz == Object.class && clazz2 != Void.TYPE && clazz2 != null) {
                return bl ? VALID_CAST : ((Primitive)object).getValue();
            }
            return Primitive.castPrimitive(clazz, clazz2, (Primitive)object, bl, n);
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return bl ? VALID_CAST : object;
        }
        if (clazz.isInterface() && This.class.isAssignableFrom(clazz2) && Capabilities.canGenerateInterfaces()) {
            return bl ? VALID_CAST : ((This)object).getInterface(clazz);
        }
        if (Primitive.isWrapperType(clazz) && Primitive.isWrapperType(clazz2)) {
            return bl ? VALID_CAST : Primitive.castWrapper(clazz, object);
        }
        if (bl) {
            return INVALID_CAST;
        }
        throw Types.castError(clazz, clazz2, n);
    }

    static UtilEvalError castError(Class clazz, Class clazz2, int n) {
        return Types.castError(Reflect.normalizeClassName(clazz), Reflect.normalizeClassName(clazz2), n);
    }

    static UtilEvalError castError(String string, String string2, int n) {
        if (n == 1) {
            return new UtilEvalError("Can't assign " + string2 + " to " + string);
        }
        ClassCastException classCastException = new ClassCastException("Cannot cast " + string2 + " to " + string);
        return new UtilTargetError(classCastException);
    }
}

