/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.JEditEmbeddedTextArea;
import org.gjt.sp.jedit.textarea.StandaloneTextArea;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;
import org.jedit.keymap.Keymap;

public class ErrorsWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        ErrorWidget errorWidget = new ErrorWidget(view);
        return errorWidget;
    }

    private static class ErrorDialog
    extends EnhancedDialog {
        private final TextArea textArea;
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private final PrintStream printStream = new PrintStream(this.byteArrayOutputStream);
        private final JButton removeThisError;
        private final JButton removeAllErrors;
        private final Throwable[] throwables = Log.throwables.toArray(new Throwable[0]);
        private final JComboBox<Throwable> combo;

        private ErrorDialog(Frame frame) {
            super(frame, "Errors", false);
            Serializable serializable;
            String string;
            this.textArea = new JEditEmbeddedTextArea();
            StandaloneTextArea.StandaloneActionSet standaloneActionSet = new StandaloneTextArea.StandaloneActionSet(jEdit.getPropertyManager(), this.textArea, TextArea.class.getResource("textarea.actions.xml"));
            this.textArea.addActionSet(standaloneActionSet);
            standaloneActionSet.load();
            standaloneActionSet.initKeyBindings();
            Keymap keymap = jEdit.getKeymapManager().getKeymap();
            String string2 = keymap.getShortcut("copy.shortcut");
            if (string2 != null) {
                this.textArea.getInputHandler().addKeyBinding(string2, "copy");
            }
            if ((string = keymap.getShortcut("copy.shortcut2")) != null) {
                this.textArea.getInputHandler().addKeyBinding(string, "copy");
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("copy.label").replace("$", ""));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Registers.copy(textArea, '$');
                }
            });
            jPopupMenu.add(jMenuItem);
            this.textArea.setRightClickPopup(jPopupMenu);
            this.textArea.setRightClickPopupEnabled(true);
            this.textArea.getBuffer().setMode(jEdit.getMode("logs"));
            if (this.throwables.length != 0) {
                serializable = this.throwables[0];
                this.setThrowable((Throwable)serializable);
            }
            this.combo = new JComboBox<Throwable>(this.throwables);
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    this.setThrowable((Throwable)combo.getSelectedItem());
                }
            });
            this.getContentPane().add(this.combo, "North");
            this.getContentPane().add(new JScrollPane(this.textArea));
            serializable = new Box(0);
            ((Container)serializable).add(Box.createGlue());
            this.removeThisError = new JButton(jEdit.getProperty("common.removeCurrent"));
            ((Container)serializable).add(this.removeThisError);
            ((Container)serializable).add(Box.createHorizontalStrut(6));
            this.removeAllErrors = new JButton(jEdit.getProperty("common.clearAll"));
            ((Container)serializable).add(this.removeAllErrors);
            MyActionListener myActionListener = new MyActionListener();
            this.removeThisError.addActionListener(myActionListener);
            this.removeAllErrors.addActionListener(myActionListener);
            ((Container)serializable).add(Box.createGlue());
            this.getContentPane().add((Component)serializable, "South");
            this.pack();
            GUIUtilities.loadGeometry(this, "status.errorWidget");
            this.setVisible(true);
        }

        private void setThrowable(Throwable throwable) {
            this.textArea.getBuffer().setReadOnly(false);
            if (throwable == null) {
                this.textArea.setText(null);
            } else {
                throwable.printStackTrace(this.printStream);
                this.textArea.setText(this.byteArrayOutputStream.toString());
                this.textArea.setCaretPosition(0);
                this.byteArrayOutputStream.reset();
            }
            this.textArea.getBuffer().setReadOnly(true);
        }

        @Override
        public void dispose() {
            GUIUtilities.saveGeometry(this, "status.errorWidget");
            super.dispose();
        }

        @Override
        public void ok() {
            this.dispose();
        }

        @Override
        public void cancel() {
            this.dispose();
        }

        private class MyActionListener
        implements ActionListener {
            private MyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == ErrorDialog.this.removeThisError) {
                    Throwable throwable = (Throwable)ErrorDialog.this.combo.getSelectedItem();
                    if (throwable != null) {
                        Log.throwables.remove(throwable);
                        ErrorDialog.this.combo.removeItem(throwable);
                        if (ErrorDialog.this.combo.getItemCount() == 0) {
                            ErrorDialog.this.dispose();
                        }
                    }
                } else if (object == ErrorDialog.this.removeAllErrors) {
                    for (Throwable throwable : ErrorDialog.this.throwables) {
                        Log.throwables.remove(throwable);
                    }
                    ErrorDialog.this.dispose();
                }
            }
        }
    }

    private static class ErrorHighlight
    extends JLabel
    implements ActionListener {
        private int currentSize;
        private final Color foregroundColor;
        private Timer timer;

        ErrorHighlight(View view) {
            String string = jEdit.getProperty("view.font");
            int n = jEdit.getIntegerProperty("view.fontsize", 12);
            SyntaxStyle syntaxStyle = SyntaxUtilities.parseStyle(jEdit.getProperty("view.style.invalid"), string, n, true);
            this.foregroundColor = syntaxStyle.getForegroundColor();
            this.setForeground(this.foregroundColor);
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.addMouseListener(new MyMouseAdapter(view));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.update();
            int n = 1000;
            this.timer = new Timer(n, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private void update() {
            int n = Log.throwables.size();
            if (n != this.currentSize) {
                this.currentSize = n;
                if (n == 0) {
                    this.setText(null);
                    this.setToolTipText(n + " error");
                } else {
                    this.setForeground(this.foregroundColor);
                    this.setText(Integer.toString(n) + " error(s)");
                    this.setToolTipText(n + " error(s)");
                }
            }
        }

        private class MyMouseAdapter
        extends MouseAdapter {
            private final View view;

            MyMouseAdapter(View view) {
                this.view = view;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (Log.throwables.isEmpty()) {
                    return;
                }
                if (GenericGUIUtilities.isRightButton(mouseEvent.getModifiers())) {
                    JPopupMenu jPopupMenu = GUIUtilities.loadPopupMenu("errorwidget.popupmenu");
                    GenericGUIUtilities.showPopupMenu(jPopupMenu, ErrorHighlight.this, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() == 2) {
                    new ErrorDialog((Frame)this.view);
                }
            }
        }
    }

    private static class ErrorWidget
    implements Widget {
        private final ErrorHighlight errorHighlight;

        ErrorWidget(View view) {
            this.errorHighlight = new ErrorHighlight(view);
        }

        @Override
        public JComponent getComponent() {
            return this.errorHighlight;
        }

        @Override
        public void update() {
            this.errorHighlight.update();
        }

        @Override
        public void propertiesChanged() {
        }
    }
}

