/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.StandardUtilities;

public class TextAreaMouseHandler
extends MouseInputAdapter {
    protected final TextArea textArea;
    protected int dragStartLine;
    protected int dragStartOffset;
    protected int dragStart;
    protected int clickCount;
    protected boolean dragged;
    protected boolean quickCopyDrag;
    protected boolean control;
    protected boolean ctrlForRectangularSelection;
    protected boolean maybeDragAndDrop;

    TextAreaMouseHandler(TextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showCursor();
        this.control = OperatingSystem.isMacOS() && mouseEvent.isMetaDown() || !OperatingSystem.isMacOS() && mouseEvent.isControlDown();
        this.ctrlForRectangularSelection = true;
        this.textArea.getInputHandler().resetLastActionCount();
        boolean bl = this.quickCopyDrag = this.textArea.isQuickCopyEnabled() && TextAreaMouseHandler.isMiddleButton(mouseEvent.getModifiers());
        if (!this.quickCopyDrag) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragStart = this.textArea.xyToOffset(n, n2, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        this.dragStartLine = this.textArea.getLineOfOffset(this.dragStart);
        this.dragStartOffset = this.dragStart - this.textArea.getLineStartOffset(this.dragStartLine);
        if (TextAreaMouseHandler.isPopupTrigger(mouseEvent) && this.textArea.isRightClickPopupEnabled()) {
            this.textArea.handlePopupTrigger(mouseEvent);
            return;
        }
        this.dragged = false;
        this.textArea.blink = true;
        this.textArea.invalidateLine(this.textArea.getCaretLine());
        this.clickCount = mouseEvent.getClickCount();
        if (this.textArea.isDragEnabled() && this.textArea.selectionManager.insideSelection(n, n2) && this.clickCount == 1 && !mouseEvent.isShiftDown()) {
            this.maybeDragAndDrop = true;
            this.textArea.moveCaretPosition(this.dragStart, false);
            return;
        }
        this.maybeDragAndDrop = false;
        if (this.quickCopyDrag) {
            this.doSingleClick(mouseEvent);
        } else {
            switch (this.clickCount) {
                case 1: {
                    this.doSingleClick(mouseEvent);
                    break;
                }
                case 2: {
                    this.doDoubleClick();
                    break;
                }
                default: {
                    this.doTripleClick();
                }
            }
        }
    }

    protected void doSingleClick(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = 0;
        if (this.textArea.chunkCache.getLineInfo((int)this.textArea.getLastScreenLine()).lastSubregion) {
            float f;
            n = this.textArea.xyToOffset(n2, mouseEvent.getY(), !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
            int n4 = this.textArea.getScreenLineOfOffset(n);
            object = this.textArea.chunkCache.getLineInfo(n4);
            int n5 = this.textArea.getScreenLineEndOffset(n4);
            if (1 != n5 - n || ((ChunkCache.LineInfo)object).lastSubregion) {
                --n5;
            }
            if ((float)n2 > (f = (float)this.textArea.offsetToXY((int)n5).x)) {
                n3 = (int)(((float)n2 - f) / (float)this.textArea.charWidth);
                if (!this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled() && (n2 - this.textArea.getHorizontalOffset()) % this.textArea.charWidth > this.textArea.charWidth / 2) {
                    ++n3;
                }
            }
        }
        if ((this.control && this.ctrlForRectangularSelection || this.textArea.isRectangularSelectionEnabled()) && this.textArea.isEditable()) {
            n = mouseEvent.getY() / this.textArea.getPainter().getLineHeight();
            if (n > this.textArea.getLastScreenLine()) {
                n = this.textArea.getLastScreenLine();
            }
            ChunkCache.LineInfo lineInfo = this.textArea.chunkCache.getLineInfo(n);
            if (lineInfo.lastSubregion && n3 != 0) {
                object = StandardUtilities.createWhiteSpace(n3, 0);
                this.textArea.getBuffer().insert(this.dragStart, (String)object);
                this.dragStart += ((String)object).length();
            }
        }
        if (mouseEvent.isShiftDown()) {
            this.textArea.resizeSelection(this.getSelectionPivotCaret(), this.dragStart, n3, this.textArea.isRectangularSelectionEnabled() || this.control && this.ctrlForRectangularSelection);
            if (!this.quickCopyDrag) {
                this.textArea.moveCaretPosition(this.dragStart, false);
            }
            this.dragStartLine = this.getSelectionPivotLine();
            this.dragStart = this.getSelectionPivotCaret();
            this.dragStartOffset = this.dragStart - this.textArea.getLineStartOffset(this.dragStartLine);
            this.dragged = true;
            return;
        }
        if (!this.quickCopyDrag) {
            Point point = this.textArea.offsetToXY(this.dragStart);
            this.textArea.moveCaretPosition(this.dragStart, point.x < 0 ? 0 : 1);
        }
        if (!this.textArea.isMultipleSelectionEnabled() && !this.quickCopyDrag) {
            this.textArea.selectNone();
        }
    }

    protected void doDoubleClick() {
        if (this.textArea.getLineLength(this.dragStartLine) == 0) {
            return;
        }
        String string = this.textArea.getLineText(this.dragStartLine);
        String string2 = this.textArea.getBuffer().getStringProperty("noWordSep");
        if (this.dragStartOffset == this.textArea.getLineLength(this.dragStartLine)) {
            --this.dragStartOffset;
        }
        boolean bl = this.textArea.getJoinNonWordChars();
        int n = TextUtilities.findWordStart(string, this.dragStartOffset, string2, bl, false, false);
        int n2 = TextUtilities.findWordEnd(string, this.dragStartOffset + 1, string2, bl, false, false);
        int n3 = this.textArea.getLineStartOffset(this.dragStartLine);
        Selection.Range range = new Selection.Range(n3 + n, n3 + n2);
        if (this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.addToSelection(range);
        } else {
            this.textArea.setSelection(range);
        }
        if (this.quickCopyDrag) {
            this.quickCopyDrag = false;
        }
        this.textArea.moveCaretPosition(n3 + n2, false);
        this.dragged = true;
    }

    protected void doTripleClick() {
        int n = this.textArea.getLineEndOffset(this.dragStartLine);
        if (this.dragStartLine == this.textArea.getLineCount() - 1) {
            --n;
        }
        Selection.Range range = new Selection.Range(this.textArea.getLineStartOffset(this.dragStartLine), n);
        if (this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.addToSelection(range);
        } else {
            this.textArea.setSelection(range);
        }
        if (this.quickCopyDrag) {
            this.quickCopyDrag = false;
        }
        this.textArea.moveCaretPosition(n, false);
        this.dragged = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.showCursor();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (TextAreaMouseHandler.isPopupTrigger(mouseEvent)) {
            return;
        }
        if (this.maybeDragAndDrop) {
            this.textArea.startDragAndDrop(mouseEvent, this.control);
            return;
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        if (mouseEvent.getY() < 0) {
            int n = Math.min(-1, mouseEvent.getY() / textAreaPainter.getLineHeight());
            this.textArea.setFirstLine(this.textArea.getFirstLine() + n);
        } else if (mouseEvent.getY() >= textAreaPainter.getHeight()) {
            int n = Math.max(1, (mouseEvent.getY() - textAreaPainter.getHeight()) / textAreaPainter.getLineHeight());
            if (this.textArea.lastLinePartial) {
                --n;
            }
            this.textArea.setFirstLine(this.textArea.getFirstLine() + n);
        }
        switch (this.clickCount) {
            case 1: {
                this.doSingleDrag(mouseEvent);
                break;
            }
            case 2: {
                this.doDoubleDrag(mouseEvent);
                break;
            }
            default: {
                this.doTripleDrag(mouseEvent);
            }
        }
    }

    private void doSingleDrag(MouseEvent mouseEvent) {
        this.dragged = true;
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= textAreaPainter.getHeight()) {
            n2 = textAreaPainter.getHeight() - 1;
        }
        int n3 = this.textArea.xyToOffset(n, n2, !textAreaPainter.isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled() || this.quickCopyDrag);
        int n4 = this.textArea.getLineOfOffset(n3);
        int n5 = 0;
        if (this.textArea.chunkCache.getLineInfo((int)this.textArea.getLastScreenLine()).lastSubregion) {
            float f;
            int n6 = this.textArea.getScreenLineOfOffset(n3);
            ChunkCache.LineInfo lineInfo = this.textArea.chunkCache.getLineInfo(n6);
            int n7 = this.textArea.getScreenLineEndOffset(n6);
            if (1 != n7 - n3 || lineInfo.lastSubregion) {
                --n7;
            }
            if ((float)n > (f = (float)this.textArea.offsetToXY((int)n7).x)) {
                n5 = (int)(((float)n - f) / (float)this.textArea.charWidth);
                if (!textAreaPainter.isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled() && (n - this.textArea.getHorizontalOffset()) % this.textArea.charWidth > this.textArea.charWidth / 2) {
                    ++n5;
                }
            }
        }
        this.textArea.resizeSelection(this.dragStart, n3, n5, this.textArea.isRectangularSelectionEnabled() || this.control && this.ctrlForRectangularSelection);
        if (this.quickCopyDrag) {
            this.textArea.scrollTo(n4, n3 - this.textArea.getLineStartOffset(n4), false);
        } else {
            Point point = this.textArea.offsetToXY(n3);
            if (n3 != this.textArea.getCaretPosition()) {
                this.textArea.moveCaretPosition(n3, point.x < 0 && n > 1 ? 0 : 1);
            } else if (point.x < 0 && n < 1) {
                this.textArea.scrollToCaret(false);
            }
            if (this.textArea.isRectangularSelectionEnabled() && n5 != 0) {
                this.textArea.scrollTo(n4, n3 - this.textArea.getLineStartOffset(n4) + n5, false);
            }
        }
    }

    private void doDoubleDrag(MouseEvent mouseEvent) {
        int n = this.textArea.getLineStartOffset(this.dragStartLine);
        int n2 = this.textArea.getLineLength(this.dragStartLine);
        int n3 = this.dragStartOffset;
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        int n4 = this.textArea.xyToOffset(mouseEvent.getX(), Math.max(0, Math.min(textAreaPainter.getHeight(), mouseEvent.getY())), !textAreaPainter.isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        int n5 = this.textArea.getLineOfOffset(n4);
        int n6 = this.textArea.getLineStartOffset(n5);
        int n7 = this.textArea.getLineLength(n5);
        int n8 = n4 - n6;
        String string = this.textArea.getLineText(n5);
        String string2 = this.textArea.getLineText(this.dragStartLine);
        String string3 = this.textArea.getBuffer().getStringProperty("noWordSep");
        boolean bl = this.textArea.getJoinNonWordChars();
        if (n + this.dragStartOffset > n6 + n8) {
            if (n8 != 0 && n8 != n7) {
                n8 = TextUtilities.findWordStart(string, n8, string3, bl);
            }
            if (n2 != 0) {
                n3 = TextUtilities.findWordEnd(string2, n3, string3, bl);
            }
        } else {
            if (n8 != 0 && n7 != 0) {
                n8 = TextUtilities.findWordEnd(string, n8, string3, bl);
            }
            if (n3 != 0 && n3 != n2) {
                n3 = TextUtilities.findWordStart(string2, n3, string3, bl);
            }
        }
        if (n6 + n8 == this.textArea.getCaretPosition()) {
            return;
        }
        this.textArea.resizeSelection(n + n3, n6 + n8, 0, false);
        this.textArea.moveCaretPosition(n6 + n8, false);
        this.dragged = true;
    }

    private void doTripleDrag(MouseEvent mouseEvent) {
        int n;
        int n2;
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        int n3 = this.textArea.xyToOffset(mouseEvent.getX(), Math.max(0, Math.min(textAreaPainter.getHeight(), mouseEvent.getY())), false);
        int n4 = this.textArea.getLineOfOffset(n3);
        if (this.dragStartLine > n4) {
            n2 = this.textArea.getLineEndOffset(this.dragStartLine) - 1;
            n = n3 == this.textArea.getLineEndOffset(n4) - 1 ? n3 : this.textArea.getLineStartOffset(n4);
        } else {
            n2 = this.textArea.getLineStartOffset(this.dragStartLine);
            n = n3 == this.textArea.getLineStartOffset(n4) ? n3 : (n3 == this.textArea.getLineEndOffset(n4) - 1 && n4 != this.textArea.getLineCount() - 1 ? this.textArea.getLineEndOffset(n4) : this.textArea.getLineEndOffset(n4) - 1);
        }
        n = Math.min(this.textArea.getBuffer().getLength(), n);
        if (n == this.textArea.getCaretPosition()) {
            return;
        }
        this.textArea.resizeSelection(n2, n, 0, false);
        this.textArea.moveCaretPosition(n, false);
        this.dragged = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.dragged && this.textArea.isQuickCopyEnabled() && TextAreaMouseHandler.isMiddleButton(mouseEvent.getModifiers())) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
            this.textArea.setCaretPosition(this.dragStart, false);
        } else if (this.maybeDragAndDrop && !this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.dragged = false;
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return TextAreaMouseHandler.isRightButton(mouseEvent.getModifiers());
    }

    public static boolean isMiddleButton(int n) {
        if (OperatingSystem.isMacOS()) {
            if ((n & 0x10) != 0) {
                return (n & 8) != 0;
            }
            return (n & 8) != 0;
        }
        return (n & 8) != 0;
    }

    public static boolean isRightButton(int n) {
        if (OperatingSystem.isMacOS()) {
            if ((n & 0x10) != 0) {
                return (n & 2) != 0;
            }
            return (n & 4) != 0;
        }
        return (n & 4) != 0;
    }

    private int getSelectionPivotCaret() {
        int n = this.textArea.caret;
        Selection selection = this.textArea.getSelectionAtOffset(this.textArea.caret);
        if (selection == null) {
            return n;
        }
        n = n == selection.start ? selection.end : (n == selection.end ? selection.start : n);
        return n;
    }

    private int getSelectionPivotLine() {
        int n = this.textArea.caret;
        int n2 = this.textArea.caretLine;
        if (this.textArea.getSelectionCount() != 1) {
            return n2;
        }
        Selection selection = this.textArea.getSelection(0);
        n2 = n == selection.start ? selection.endLine : (n == selection.end ? selection.startLine : n2);
        return n2;
    }

    protected void showCursor() {
        this.textArea.getPainter().showCursor();
    }
}

