/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openscience.jmol.app.janocchio.NMR_Viewer;

public class PopulationDisplay
extends JPanel {
    NMR_Viewer viewer;
    int frameNumber;
    int storedFrameNumber;
    double[] population;
    int imaxp;
    double maxp = 0.0;
    JLabel label;
    JTextField field;
    JCheckBox populationFrames;

    public PopulationDisplay(NMR_Viewer viewer) {
        this.viewer = viewer;
        this.setLayout(new FlowLayout(0));
        this.setMaximumSize(new Dimension(1000, 10));
        this.setVisible(false);
        this.label = new JLabel();
        this.label.setText(this.getLabelText());
        this.field = new JTextField(5);
        this.field.setEditable(false);
        this.populationFrames = new JCheckBox("Display Populated Conformers");
        this.populationFrames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopulationDisplay.this.populationFramesActionPerformed(evt);
            }
        });
        this.add((Component)this.label, "West");
        this.add((Component)this.field, "Center");
        this.add((Component)this.populationFrames, "East");
    }

    private void populationFramesActionPerformed(ActionEvent evt) {
        String command;
        if (this.populationFrames.isSelected()) {
            this.storedFrameNumber = this.frameNumber;
            command = "frame 0; hide all;";
            for (int i = 1; i < this.population.length; ++i) {
                if (!(this.population[i] >= 0.1)) continue;
                String col = this.getColourString(this.population[i]);
                command = i == this.imaxp ? command + "select */" + i + "; color opaque " + col + ";" : command + "select */" + i + "; color translucent " + col + ";";
                command = command + "display */" + i + " or displayed;";
            }
        } else {
            command = "select all; color cpk; frame " + this.storedFrameNumber + "; display all;";
        }
        command = command + "select ALL;";
        this.viewer.script(command);
    }

    private String getColourString(double p) {
        double val = (1.0 - p) * 255.0;
        int ival = Math.round(Math.round(val));
        return "[" + ival + "," + ival + ",255]";
    }

    public void setFrameNumberFromViewer(int number) {
        this.frameNumber = number;
        if (this.population != null) {
            this.field.setText(String.valueOf(this.population[number]));
        }
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    private String getLabelText() {
        String text = "NAMFIS Population :";
        return text;
    }

    public void addPopulation(double[] population) {
        this.population = population;
        this.setVisible(true);
        this.field.setText(String.valueOf(population[this.frameNumber]));
        for (int i = 1; i < population.length; ++i) {
            if (!(population[i] > this.maxp)) continue;
            this.maxp = population[i];
            this.imaxp = i;
        }
    }

    public double[] getPopulation() {
        return this.population;
    }
}

