/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

public class PovrayDialog
extends JDialog {
    private transient Viewer vwr;
    protected JButton povrayPathButton;
    protected JButton goButton;
    protected JTextField saveField;
    protected JTextField savePathLabel;
    private int outputWidth = -1;
    private int outputHeight = -1;
    protected JTextField povrayPathLabel;
    protected JCheckBox runPovCheck;
    protected JCheckBox allFramesCheck;
    protected JCheckBox antiAliasCheck;
    protected JCheckBox displayWhileRenderingCheck;
    private JLabel imageSizeWidth;
    private JFormattedTextField imageSizeTextWidth;
    private JLabel imageSizeHeight;
    private JFormattedTextField imageSizeTextHeight;
    private JCheckBox imageSizeRatioBox;
    private JComboBox<String> imageSizeRatioCombo;
    private JCheckBox outputFormatCheck;
    private JComboBox<String> outputFormatCombo;
    private JCheckBox outputAlphaCheck;
    private JCheckBox mosaicPreviewCheck;
    private JLabel mosaicPreviewStart;
    private JComboBox<String> mosaicPreviewComboStart;
    private JLabel mosaicPreviewEnd;
    private JComboBox<String> mosaicPreviewComboEnd;
    private String outputExtension = ".png";
    private String outputFileType = "N";

    public PovrayDialog(JFrame f, Viewer vwr) {
        super(f, GT.$("Render in POV-Ray"), true);
        int power;
        this.vwr = vwr;
        String text = null;
        int screenWidth = vwr.getScreenWidth();
        int screenHeight = vwr.getScreenHeight();
        this.setImageDimensions(screenWidth, screenHeight);
        ActionListener updateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.updateScreen();
            }
        };
        InputVerifier updateInputVerifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent component) {
                PovrayDialog.this.updateScreen();
                return true;
            }
        };
        ItemListener updateItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.updateScreen();
            }
        };
        Box windowBox = Box.createVerticalBox();
        this.getContentPane().add(windowBox);
        Box mainBox = Box.createVerticalBox();
        Box justSavingBox = Box.createVerticalBox();
        text = GT.$("Conversion from Jmol to POV-Ray");
        justSavingBox.setBorder(new TitledBorder(text));
        Box saveBox = Box.createHorizontalBox();
        text = GT.$("File Name:");
        saveBox.setBorder(new TitledBorder(text));
        text = GT.$("'caffeine.pov' -> 'caffeine.pov', 'caffeine.pov.ini', 'caffeine.pov.spt'");
        saveBox.setToolTipText(text);
        this.saveField = new JTextField("Jmol.pov", 20);
        this.saveField.addActionListener(updateActionListener);
        this.saveField.setInputVerifier(updateInputVerifier);
        saveBox.add(this.saveField);
        justSavingBox.add(saveBox);
        Box savePathBox = Box.createHorizontalBox();
        text = GT.$("Working Directory");
        savePathBox.setBorder(new TitledBorder(text));
        text = GT.$("Where the .pov files will be saved");
        savePathBox.setToolTipText(text);
        this.savePathLabel = new JTextField("");
        this.savePathLabel.setEditable(false);
        this.savePathLabel.setBorder(null);
        savePathBox.add(this.savePathLabel);
        text = GT.$("Select");
        JButton savePathButton = new JButton(text);
        savePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.showSavePathDialog();
            }
        });
        savePathBox.add(savePathButton);
        justSavingBox.add(savePathBox);
        mainBox.add(justSavingBox);
        Box povOptionsBox = Box.createVerticalBox();
        text = GT.$("POV-Ray Runtime Options");
        povOptionsBox.setBorder(new TitledBorder(text));
        Box runPovBox = Box.createHorizontalBox();
        text = GT.$("Run POV-Ray directly");
        this.runPovCheck = new JCheckBox(text, true);
        text = GT.$("Launch POV-Ray from within Jmol");
        this.runPovCheck.setToolTipText(text);
        this.runPovCheck.addItemListener(updateItemListener);
        runPovBox.add(this.runPovCheck);
        runPovBox.add(Box.createGlue());
        povOptionsBox.add(runPovBox);
        Box displayBox = Box.createHorizontalBox();
        text = GT.$("Display While Rendering");
        this.displayWhileRenderingCheck = new JCheckBox(text, true);
        text = GT.$("Should POV-Ray attempt to display while rendering?");
        this.displayWhileRenderingCheck.setToolTipText(text);
        this.displayWhileRenderingCheck.addItemListener(updateItemListener);
        displayBox.add(this.displayWhileRenderingCheck);
        displayBox.add(Box.createGlue());
        povOptionsBox.add(displayBox);
        Box imageBox = Box.createHorizontalBox();
        imageBox.add(Box.createHorizontalStrut(10));
        Box imageSizeDetailBox = Box.createVerticalBox();
        Box imageSizeXYBox = Box.createHorizontalBox();
        text = GT.$("width:") + " ";
        this.imageSizeWidth = new JLabel(text);
        text = GT.$("Image width");
        this.imageSizeWidth.setToolTipText(text);
        imageSizeXYBox.add(this.imageSizeWidth);
        this.imageSizeTextWidth = new JFormattedTextField();
        this.imageSizeTextWidth.setValue(this.outputWidth);
        this.imageSizeTextWidth.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeXYBox.add(this.imageSizeTextWidth);
        imageSizeXYBox.add(Box.createHorizontalStrut(10));
        text = GT.$("height:") + " ";
        this.imageSizeHeight = new JLabel(text);
        text = GT.$("Image height");
        this.imageSizeHeight.setToolTipText(text);
        imageSizeXYBox.add(this.imageSizeHeight);
        this.imageSizeTextHeight = new JFormattedTextField();
        this.imageSizeTextHeight.setValue(this.outputHeight);
        this.imageSizeTextHeight.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeXYBox.add(this.imageSizeTextHeight);
        imageSizeXYBox.add(Box.createGlue());
        imageSizeDetailBox.add(imageSizeXYBox);
        Box imageSizeBox = Box.createHorizontalBox();
        text = GT.$("Fixed ratio : ");
        this.imageSizeRatioBox = new JCheckBox(text, true);
        text = GT.$("Use a fixed ratio for width:height");
        this.imageSizeRatioBox.setToolTipText(text);
        this.imageSizeRatioBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeBox.add(this.imageSizeRatioBox);
        imageSizeBox.add(Box.createHorizontalStrut(10));
        this.imageSizeRatioCombo = new JComboBox();
        text = GT.$("User defined");
        this.imageSizeRatioCombo.addItem(text);
        text = GT.$("Keep ratio of Jmol window");
        this.imageSizeRatioCombo.addItem(text);
        text = "4:3";
        this.imageSizeRatioCombo.addItem(text);
        text = "16:9";
        this.imageSizeRatioCombo.addItem(text);
        this.imageSizeRatioCombo.setSelectedIndex(1);
        this.imageSizeRatioCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeBox.add(this.imageSizeRatioCombo);
        imageSizeBox.add(Box.createGlue());
        imageSizeDetailBox.add(imageSizeBox);
        imageSizeDetailBox.add(Box.createGlue());
        imageBox.add(imageSizeDetailBox);
        imageBox.add(Box.createGlue());
        povOptionsBox.add(imageBox);
        this.imageSizeChanged();
        Box outputBox = Box.createHorizontalBox();
        outputBox.add(Box.createHorizontalStrut(10));
        this.outputFormatCombo = new JComboBox();
        text = GT.$("N - PNG");
        this.outputFormatCombo.addItem(text);
        text = GT.$("P - PPM");
        this.outputFormatCombo.addItem(text);
        text = GT.$("C - Compressed Targa-24");
        this.outputFormatCombo.addItem(text);
        text = GT.$("T - Uncompressed Targa-24");
        this.outputFormatCombo.addItem(text);
        this.outputFormatCombo.setSelectedIndex(0);
        this.outputFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.outputFormatChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        outputBox.add(this.outputFormatCombo);
        outputBox.add(Box.createGlue());
        povOptionsBox.add(outputBox);
        this.outputFormatChanged();
        Box alphaBox = Box.createHorizontalBox();
        text = GT.$("Alpha transparency");
        this.outputAlphaCheck = new JCheckBox(text, false);
        text = GT.$("Output Alpha transparency data");
        this.outputAlphaCheck.setToolTipText(text);
        this.outputAlphaCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.updateCommandLine();
            }
        });
        alphaBox.add(this.outputAlphaCheck);
        alphaBox.add(Box.createGlue());
        povOptionsBox.add(alphaBox);
        Box mosaicBox = Box.createHorizontalBox();
        text = GT.$("Mosaic preview");
        this.mosaicPreviewCheck = new JCheckBox(text, false);
        text = GT.$("Render the image in several passes");
        this.mosaicPreviewCheck.setToolTipText(text);
        this.mosaicPreviewCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        mosaicBox.add(this.mosaicPreviewCheck);
        mosaicBox.add(Box.createHorizontalStrut(10));
        text = GT.$("Start size : ");
        this.mosaicPreviewStart = new JLabel(text);
        text = GT.$("Initial size of the tiles");
        this.mosaicPreviewStart.setToolTipText(text);
        mosaicBox.add(this.mosaicPreviewStart);
        this.mosaicPreviewComboStart = new JComboBox();
        for (power = 0; power < 8; ++power) {
            this.mosaicPreviewComboStart.addItem(Integer.toString((int)Math.pow(2.0, power)));
        }
        this.mosaicPreviewComboStart.setSelectedIndex(3);
        this.mosaicPreviewComboStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        mosaicBox.add(this.mosaicPreviewComboStart);
        mosaicBox.add(Box.createHorizontalStrut(10));
        text = GT.$("End size : ");
        this.mosaicPreviewEnd = new JLabel(text);
        text = GT.$("Final size of the tiles");
        this.mosaicPreviewEnd.setToolTipText(text);
        mosaicBox.add(this.mosaicPreviewEnd);
        this.mosaicPreviewComboEnd = new JComboBox();
        for (power = 0; power < 8; ++power) {
            this.mosaicPreviewComboEnd.addItem(Integer.toString((int)Math.pow(2.0, power)));
        }
        this.mosaicPreviewComboEnd.setSelectedIndex(0);
        this.mosaicPreviewComboEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        mosaicBox.add(this.mosaicPreviewComboEnd);
        mosaicBox.add(Box.createGlue());
        povOptionsBox.add(mosaicBox);
        this.mosaicPreviewChanged();
        Box povrayPathBox = Box.createHorizontalBox();
        text = GT.$("Location of the POV-Ray Executable");
        povrayPathBox.setBorder(new TitledBorder(text));
        text = GT.$("Location of the POV-Ray Executable");
        povrayPathBox.setToolTipText(text);
        this.povrayPathLabel = new JTextField("");
        this.povrayPathLabel.setEditable(false);
        this.povrayPathLabel.setBorder(null);
        povrayPathBox.add(this.povrayPathLabel);
        text = GT.$("Select");
        this.povrayPathButton = new JButton(text);
        this.povrayPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.showPovrayPathDialog();
            }
        });
        povrayPathBox.add(this.povrayPathButton);
        povOptionsBox.add(povrayPathBox);
        mainBox.add(povOptionsBox);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createGlue());
        text = GT.$("Go!");
        this.goButton = new JButton(text);
        text = GT.$("Save file and possibly launch POV-Ray");
        this.goButton.setToolTipText(text);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.goPressed();
            }
        });
        buttonBox.add(this.goButton);
        text = GT.$("Cancel");
        JButton cancelButton = new JButton(text);
        text = GT.$("Cancel this dialog without saving");
        cancelButton.setToolTipText(text);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.cancelPressed();
            }
        });
        buttonBox.add(cancelButton);
        windowBox.add(mainBox);
        windowBox.add(buttonBox);
        this.getPathHistory();
        this.updateScreen();
        this.pack();
        this.centerDialog();
        this.setVisible(true);
    }

    public void setImageDimensions(int imageWidth, int imageHeight) {
        this.outputWidth = imageWidth;
        this.outputHeight = imageHeight;
        this.updateCommandLine();
    }

    void goPressed() {
        String basename;
        String filename = basename = this.saveField.getText();
        String savePath = this.savePathLabel.getText();
        File theFile = new File(savePath, filename);
        basename = filename = theFile.getAbsolutePath();
        int height = Integer.parseInt(this.imageSizeTextHeight.getValue().toString());
        int width = Integer.parseInt(this.imageSizeTextWidth.getValue().toString());
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("type", "Povray");
        params.put("fileName", filename);
        params.put("width", width);
        params.put("height", height);
        params.put("params", this.getINI());
        String data = this.vwr.generateOutputForExport(params);
        if (data == null) {
            return;
        }
        this.vwr.writeTextFile(filename + ".ini", data);
        boolean callPovray = this.runPovCheck.isSelected();
        if (callPovray) {
            String[] commandLineArgs = null;
            commandLineArgs = new String[]{this.povrayPathLabel.getText(), filename + ".ini"};
            try {
                Runtime.getRuntime().exec(commandLineArgs);
            }
            catch (IOException e) {
                Logger.errorEx("Caught IOException in povray exec", e);
                Logger.error("CmdLine:");
                for (int i = 0; i < commandLineArgs.length; ++i) {
                    Logger.error("  <" + commandLineArgs[i] + ">");
                }
            }
        }
        this.setVisible(false);
        this.saveHistory();
        this.dispose();
    }

    void cancelPressed() {
        this.setVisible(false);
        this.dispose();
    }

    void showSavePathDialog() {
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileSelectionMode(1);
        int button = myChooser.showDialog(this, GT.$("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            String savePath = newFile.isDirectory() ? newFile.toString() : newFile.getParent();
            this.savePathLabel.setText(savePath);
            this.updateCommandLine();
            this.pack();
        }
    }

    void showPovrayPathDialog() {
        JFileChooser myChooser = new JFileChooser();
        int button = myChooser.showDialog(this, GT.$("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            this.povrayPathLabel.setText(newFile.toString());
            this.updateCommandLine();
            this.pack();
        }
    }

    void imageSizeChanged() {
        boolean selected = true;
        boolean enabled = true;
        boolean ratioSelected = false;
        if (this.imageSizeRatioBox != null) {
            ratioSelected = this.imageSizeRatioBox.isSelected();
            this.imageSizeRatioBox.setEnabled(selected && enabled);
        }
        if (this.imageSizeWidth != null) {
            this.imageSizeWidth.setEnabled(selected && enabled);
        }
        if (this.imageSizeTextWidth != null) {
            this.imageSizeTextWidth.setEnabled(selected && enabled);
        }
        if (this.imageSizeHeight != null) {
            this.imageSizeHeight.setEnabled(selected && !ratioSelected && enabled);
        }
        if (this.imageSizeTextHeight != null) {
            this.imageSizeTextHeight.setEnabled(selected && !ratioSelected && enabled);
        }
        if (this.imageSizeRatioCombo != null) {
            this.imageSizeRatioCombo.setEnabled(selected && ratioSelected && enabled);
            if (this.imageSizeTextWidth != null && this.imageSizeTextHeight != null) {
                int width = Integer.parseInt(this.imageSizeTextWidth.getValue().toString());
                switch (this.imageSizeRatioCombo.getSelectedIndex()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int height = (int)((double)width * (double)this.outputHeight / (double)this.outputWidth);
                        this.imageSizeTextHeight.setValue(height);
                        break;
                    }
                    case 2: {
                        int height = (int)((double)width * 3.0 / 4.0);
                        this.imageSizeTextHeight.setValue(height);
                        break;
                    }
                    case 3: {
                        int height = (int)((double)width * 9.0 / 16.0);
                        this.imageSizeTextHeight.setValue(height);
                    }
                }
            }
        }
    }

    void outputFormatChanged() {
        if (this.outputFormatCheck != null) {
            boolean selected = this.outputFormatCheck.isSelected();
            boolean enabled = true;
            this.outputFormatCheck.setEnabled(enabled);
            if (this.outputFormatCombo != null) {
                this.outputFormatCombo.setEnabled(selected && enabled);
                switch (this.outputFormatCombo.getSelectedIndex()) {
                    case 0: {
                        this.outputExtension = ".png";
                        this.outputFileType = "N";
                        break;
                    }
                    case 1: {
                        this.outputExtension = ".ppm";
                        this.outputFileType = "P";
                        break;
                    }
                    case 2: {
                        this.outputExtension = ".tga";
                        this.outputFileType = "C";
                        break;
                    }
                    case 3: {
                        this.outputExtension = ".tga";
                        this.outputFileType = "T";
                    }
                }
            }
        }
    }

    void mosaicPreviewChanged() {
        if (this.mosaicPreviewCheck != null) {
            boolean selected = this.mosaicPreviewCheck.isSelected();
            boolean enabled = this.runPovCheck.isSelected();
            this.mosaicPreviewCheck.setEnabled(enabled);
            if (this.mosaicPreviewStart != null) {
                this.mosaicPreviewStart.setEnabled(selected && enabled);
            }
            if (this.mosaicPreviewComboStart != null) {
                this.mosaicPreviewComboStart.setEnabled(selected && enabled);
            }
            if (this.mosaicPreviewEnd != null) {
                this.mosaicPreviewEnd.setEnabled(selected && enabled);
            }
            if (this.mosaicPreviewComboEnd != null) {
                this.mosaicPreviewComboEnd.setEnabled(selected && enabled);
            }
        }
    }

    protected void updateScreen() {
        boolean callPovray = false;
        if (this.runPovCheck != null) {
            callPovray = this.runPovCheck.isSelected();
        }
        String text = null;
        text = callPovray ? GT.$("Go!") : GT.$("Save");
        if (this.goButton != null) {
            this.goButton.setText(text);
        }
        boolean useIni = true;
        if (this.antiAliasCheck != null) {
            this.antiAliasCheck.setEnabled(callPovray || useIni);
        }
        if (this.povrayPathButton != null) {
            this.povrayPathButton.setEnabled(callPovray || useIni);
        }
        this.imageSizeChanged();
        this.outputFormatChanged();
        this.updateCommandLine();
    }

    protected void updateCommandLine() {
    }

    protected String getCommandLine() {
        String basename = null;
        if (this.saveField != null) {
            basename = this.saveField.getText();
        }
        String savePath = null;
        if (this.savePathLabel != null) {
            savePath = this.savePathLabel.getText();
        }
        String povrayPath = null;
        if (this.povrayPathLabel != null) {
            povrayPath = this.povrayPathLabel.getText();
        }
        if (savePath == null || povrayPath == null || basename == null) {
            return "";
        }
        if (!savePath.endsWith(File.separator)) {
            savePath = savePath + File.separator;
        }
        String commandLine = this.doubleQuoteIfContainsSpace(povrayPath) + " +I" + this.simpleQuoteIfContainsSpace(savePath + basename + ".pov");
        commandLine = commandLine + " +O" + this.simpleQuoteIfContainsSpace(savePath + basename + this.outputExtension) + " +F" + this.outputFileType;
        if (this.outputAlphaCheck != null && this.outputAlphaCheck.isSelected()) {
            commandLine = commandLine + " +UA";
        }
        commandLine = commandLine + " +H" + this.imageSizeTextHeight.getValue() + " +W" + this.imageSizeTextWidth.getValue();
        commandLine = commandLine + " +A0.1";
        if (this.displayWhileRenderingCheck != null && this.displayWhileRenderingCheck.isSelected()) {
            commandLine = commandLine + " +D +P";
        }
        if (this.allFramesCheck != null && this.allFramesCheck.isSelected()) {
            commandLine = commandLine + " +KFI1";
            commandLine = commandLine + " +KFF" + this.vwr.ms.mc;
            commandLine = commandLine + " +KI1";
            commandLine = commandLine + " +KF" + this.vwr.ms.mc;
        }
        if (this.mosaicPreviewCheck != null && this.mosaicPreviewCheck.isSelected()) {
            commandLine = commandLine + " +SP" + this.mosaicPreviewComboStart.getSelectedItem() + " +EP" + this.mosaicPreviewComboEnd.getSelectedItem();
        }
        commandLine = commandLine + " -V";
        return commandLine;
    }

    private String getINI() {
        StringBuilder data = new StringBuilder();
        String savePath = this.savePathLabel.getText();
        if (!savePath.endsWith(File.separator)) {
            savePath = savePath + File.separator;
        }
        String basename = this.saveField.getText();
        data.append("Input_File_Name=" + savePath + basename + "\n");
        data.append("Output_to_File=true\n");
        data.append("Output_File_Type=" + this.outputFileType + "\n");
        data.append("Output_File_Name=" + savePath + basename + this.outputExtension + "\n");
        data.append("Height=" + this.imageSizeTextHeight.getValue() + "\n");
        data.append("Width=" + this.imageSizeTextWidth.getValue() + "\n");
        if (this.allFramesCheck != null && this.allFramesCheck.isSelected()) {
            data.append("Initial_Frame=1\n");
            data.append("Final_Frame=" + this.vwr.ms.mc + "\n");
            data.append("Initial_Clock=1\n");
            data.append("Final_Clock=" + this.vwr.ms.mc + "\n");
        }
        if (this.outputAlphaCheck != null && this.outputAlphaCheck.isSelected()) {
            data.append("Output_Alpha=true\n");
        }
        data.append("Antialias=true\n");
        data.append("Antialias_Threshold=0.1\n");
        if (this.displayWhileRenderingCheck != null && this.displayWhileRenderingCheck.isSelected()) {
            data.append("Display=true\n");
            data.append("Pause_When_Done=true\n");
        }
        if (this.mosaicPreviewCheck != null && this.mosaicPreviewCheck.isSelected()) {
            data.append("Preview_Start_Size=" + this.mosaicPreviewComboStart.getSelectedItem() + "\n");
            data.append("Preview_End_Size=" + this.mosaicPreviewComboEnd.getSelectedItem() + "\n");
        }
        data.append("Warning_Level=5\n");
        data.append("Verbose=false\n");
        return data.toString();
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    private void getPathHistory() {
        String savePath;
        String povrayPath;
        Properties props = JmolPanel.historyFile.getProperties();
        if (this.povrayPathLabel != null && (povrayPath = props.getProperty("povrayPath", System.getProperty("user.home"))) != null) {
            this.povrayPathLabel.setText(povrayPath);
        }
        if (this.savePathLabel != null && (savePath = props.getProperty("povraySavePath", System.getProperty("user.home"))) != null) {
            this.savePathLabel.setText(savePath);
        }
    }

    private void saveHistory() {
        Properties props = new Properties();
        props.setProperty("povrayPath", this.povrayPathLabel.getText());
        props.setProperty("povraySavePath", this.savePathLabel.getText());
        JmolPanel.historyFile.addProperties(props);
    }

    String doubleQuoteIfContainsSpace(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) != ' ') continue;
            return "\"" + str + "\"";
        }
        return str;
    }

    String simpleQuoteIfContainsSpace(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) != ' ') continue;
            return "'" + str + "'";
        }
        return str;
    }

    class PovrayWindowListener
    extends WindowAdapter {
        PovrayWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            PovrayDialog.this.cancelPressed();
            PovrayDialog.this.setVisible(false);
            PovrayDialog.this.dispose();
        }
    }
}

