/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.SettingVisitor;

public class MapListSetting
extends AbstractSetting<List<Map<String, String>>> {
    public MapListSetting(List<Map<String, String>> value) {
        super(value);
        this.consistencyTest();
    }

    public MapListSetting copy() {
        if (this.value == null) {
            return new MapListSetting(null);
        }
        ArrayList copy = new ArrayList(((List)this.value).size());
        for (Map map : (List)this.value) {
            LinkedHashMap mapCopy = new LinkedHashMap(map);
            copy.add(Collections.unmodifiableMap(mapCopy));
        }
        return new MapListSetting(Collections.unmodifiableList(copy));
    }

    private void consistencyTest() {
        if (this.value == null) {
            return;
        }
        if (((List)this.value).contains(null)) {
            throw new IllegalArgumentException("Error: Null as list element in preference setting");
        }
        for (Map map : (List)this.value) {
            if (!(map instanceof SortedMap) && map.containsKey(null)) {
                throw new IllegalArgumentException("Error: Null as map key in preference setting");
            }
            if (!map.containsValue(null)) continue;
            throw new IllegalArgumentException("Error: Null as map value in preference setting");
        }
    }

    @Override
    public void visit(SettingVisitor visitor) {
        visitor.visit(this);
    }

    public MapListSetting getNullInstance() {
        return new MapListSetting(null);
    }
}

