/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.PlatformUtil;
import net.osmand.data.FavouritePoint;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.api.SQLiteAPI;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class FavouritesDbHelper {
    private static final Log log = PlatformUtil.getLog(FavouritesDbHelper.class);
    public static final String FILE_TO_SAVE = "favourites.gpx";
    public static final String BACKUP_FOLDER = "backup";
    public static final int BACKUP_CNT = 20;
    public static final String FILE_TO_BACKUP = "favourites_bak.gpx";
    private List<FavouritePoint> cachedFavoritePoints = new ArrayList<FavouritePoint>();
    private List<FavoriteGroup> favoriteGroups = new ArrayList<FavoriteGroup>();
    private Map<String, FavoriteGroup> flatGroups = new LinkedHashMap<String, FavoriteGroup>();
    private final OsmWindow context;
    protected static final String HIDDEN = "HIDDEN";
    private static final String DELIMETER = "__";
    private static final int DATABASE_VERSION = 2;
    public static final String FAVOURITE_DB_NAME = "favourite";
    private static final String FAVOURITE_TABLE_NAME = "favourite";
    private static final String FAVOURITE_COL_NAME = "name";
    private static final String FAVOURITE_COL_CATEGORY = "category";
    private static final String FAVOURITE_COL_LAT = "latitude";
    private static final String FAVOURITE_COL_LON = "longitude";
    private static final String FAVOURITE_TABLE_CREATE = "CREATE TABLE favourite (name TEXT, category TEXT, latitude double, longitude double);";
    private SQLiteAPI.SQLiteConnection conn;

    public FavouritesDbHelper(OsmWindow context) {
        this.context = context;
    }

    public void loadFavorites() {
        File dbPath;
        this.flatGroups.clear();
        this.favoriteGroups.clear();
        File internalFile = this.getInternalFile();
        if (!internalFile.exists() && (dbPath = this.context.getDatabasePath("favourite")).exists()) {
            this.loadAndCheckDatabasePoints();
            this.saveCurrentPointsIntoFile();
        }
        LinkedHashMap<String, FavouritePoint> points = new LinkedHashMap<String, FavouritePoint>();
        LinkedHashMap<String, FavouritePoint> extPoints = new LinkedHashMap<String, FavouritePoint>();
        this.loadGPXFile(internalFile, points);
        this.loadGPXFile(this.getExternalFile(), extPoints);
        boolean changed = this.merge(extPoints, points);
        for (FavouritePoint pns : points.values()) {
            FavoriteGroup group = this.getOrCreateGroup(pns, 0);
            group.points.add(pns);
        }
        this.sortAll();
        this.recalculateCachedFavPoints();
        if (changed) {
            this.saveCurrentPointsIntoFile();
        }
        this.favouritesUpdated();
    }

    private void favouritesUpdated() {
    }

    private boolean merge(Map<String, FavouritePoint> source, Map<String, FavouritePoint> destination) {
        boolean changed = false;
        for (String ks : source.keySet()) {
            if (destination.containsKey(ks)) continue;
            changed = true;
            destination.put(ks, source.get(ks));
        }
        return changed;
    }

    private File getInternalFile() {
        return this.context.getFileStreamPath(FILE_TO_BACKUP);
    }

    public void delete(Set<FavoriteGroup> groupsToDelete, Set<FavouritePoint> favoritesSelected) {
        if (favoritesSelected != null) {
            for (FavouritePoint p : favoritesSelected) {
                FavoriteGroup group = this.flatGroups.get(p.getCategory());
                if (group != null) {
                    group.points.remove(p);
                }
                this.cachedFavoritePoints.remove(p);
            }
        }
        if (groupsToDelete != null) {
            for (FavoriteGroup g : groupsToDelete) {
                this.flatGroups.remove(g.name);
                this.favoriteGroups.remove(g);
                this.cachedFavoritePoints.removeAll(g.points);
            }
        }
        this.saveCurrentPointsIntoFile();
    }

    public boolean deleteFavourite(FavouritePoint p) {
        return this.deleteFavourite(p, true);
    }

    public boolean deleteFavourite(FavouritePoint p, boolean saveImmediately) {
        if (p != null) {
            FavoriteGroup group = this.flatGroups.get(p.getCategory());
            if (group != null) {
                group.points.remove(p);
            }
            this.cachedFavoritePoints.remove(p);
        }
        if (saveImmediately) {
            this.saveCurrentPointsIntoFile();
        }
        return true;
    }

    public boolean addFavourite(FavouritePoint p) {
        return this.addFavourite(p, true);
    }

    public boolean addFavourite(FavouritePoint p, boolean saveImmediately) {
        if (p.getName().equals("") && this.flatGroups.containsKey(p.getCategory())) {
            return true;
        }
        FavoriteGroup group = this.getOrCreateGroup(p, 0);
        if (!p.getName().equals("")) {
            p.setVisible(group.visible);
            p.setColor(group.color);
            group.points.add(p);
            this.cachedFavoritePoints.add(p);
        }
        if (saveImmediately) {
            this.sortAll();
            this.saveCurrentPointsIntoFile();
        }
        return true;
    }

    public static String checkEmoticons(String name) {
        char[] chars = name.toCharArray();
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index < chars.length) {
            char ch2;
            char ch1 = chars[index];
            if (ch1 == '\ud83c') {
                ch2 = chars[index + 1];
                if (ch2 >= '\udf00' && ch2 <= '\udfff') {
                    index += 2;
                    continue;
                }
            } else if (ch1 == '\ud83d' && (ch2 = chars[index + 1]) >= '\udc00' && ch2 <= '\uddff') {
                index += 2;
                continue;
            }
            builder.append(ch1);
            ++index;
        }
        builder.trimToSize();
        return builder.toString();
    }

    public boolean editFavouriteName(FavouritePoint p, String newName, String category, String descr) {
        String oldCategory = p.getCategory();
        p.setName(newName);
        p.setCategory(category);
        p.setDescription(descr);
        if (!oldCategory.equals(category)) {
            FavoriteGroup old = this.flatGroups.get(oldCategory);
            if (old != null) {
                old.points.remove(p);
            }
            FavoriteGroup pg = this.getOrCreateGroup(p, 0);
            p.setVisible(pg.visible);
            p.setColor(pg.color);
            pg.points.add(p);
        }
        this.sortAll();
        this.saveCurrentPointsIntoFile();
        return true;
    }

    public boolean editFavourite(FavouritePoint p, double lat, double lon) {
        p.setLatitude(lat);
        p.setLongitude(lon);
        this.saveCurrentPointsIntoFile();
        return true;
    }

    public void saveCurrentPointsIntoFile() {
        try {
            LinkedHashMap<String, FavouritePoint> deletedInMemory = new LinkedHashMap<String, FavouritePoint>();
            this.loadGPXFile(this.getInternalFile(), deletedInMemory);
            for (FavouritePoint fp : this.cachedFavoritePoints) {
                deletedInMemory.remove(this.getKey(fp));
            }
            this.saveFile(this.cachedFavoritePoints, this.getInternalFile());
            this.saveExternalFile(deletedInMemory.keySet());
            this.backup(this.getBackupFile(), this.getExternalFile());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void backup(File backupFile, File externalFile) {
        try {
            File f = new File(backupFile.getParentFile(), backupFile.getName());
            FileOutputStream fout = new FileOutputStream(f);
            fout.write(66);
            fout.write(90);
            CBZip2OutputStream out = new CBZip2OutputStream(fout);
            FileInputStream fis = new FileInputStream(externalFile);
            Algorithms.streamCopy(fis, out);
            fis.close();
            out.close();
            fout.close();
        }
        catch (Exception e) {
            log.warn((Object)"Backup failed", (Throwable)e);
        }
    }

    public String exportFavorites() {
        return this.saveExternalFile(null);
    }

    private String saveExternalFile(Set<String> deleted) {
        LinkedHashMap<String, FavouritePoint> all = new LinkedHashMap<String, FavouritePoint>();
        this.loadGPXFile(this.getExternalFile(), all);
        ArrayList<FavouritePoint> favoritePoints = new ArrayList<FavouritePoint>(this.cachedFavoritePoints);
        if (deleted != null) {
            for (String key : deleted) {
                all.remove(key);
            }
        }
        for (FavouritePoint p : favoritePoints) {
            all.remove(this.getKey(p));
        }
        favoritePoints.addAll(all.values());
        return this.saveFile(favoritePoints, this.getExternalFile());
    }

    private String getKey(FavouritePoint p) {
        return p.getName() + DELIMETER + p.getCategory();
    }

    public boolean deleteGroup(FavoriteGroup group) {
        boolean remove = this.favoriteGroups.remove(group);
        if (remove) {
            this.flatGroups.remove(group.name);
            this.saveCurrentPointsIntoFile();
            return true;
        }
        return false;
    }

    public File getExternalFile() {
        return new File(this.context.getAppPath(null), FILE_TO_SAVE);
    }

    public File getBackupFile() {
        int back;
        File fld = new File(this.context.getAppPath(null), BACKUP_FOLDER);
        if (!fld.exists()) {
            fld.mkdirs();
        }
        String backPrefix = "" + back;
        File firstModified = null;
        long firstModifiedMin = System.currentTimeMillis();
        for (back = 1; back <= 20; ++back) {
            File bak;
            backPrefix = "" + back;
            if (back < 10) {
                backPrefix = "0" + backPrefix;
            }
            if (!(bak = new File(fld, "favourites_bak_" + backPrefix + ".gpx.bz2")).exists()) {
                return bak;
            }
            if (bak.lastModified() >= firstModifiedMin) continue;
            firstModified = bak;
            firstModifiedMin = bak.lastModified();
        }
        return firstModified;
    }

    public String saveFile(List<FavouritePoint> favoritePoints, File f) {
        GPXUtilities.GPXFile gpx = this.asGpxFile(favoritePoints);
        return GPXUtilities.writeGpxFile(f, gpx, this.context);
    }

    public GPXUtilities.GPXFile asGpxFile() {
        return this.asGpxFile(this.cachedFavoritePoints);
    }

    private GPXUtilities.GPXFile asGpxFile(List<FavouritePoint> favoritePoints) {
        GPXUtilities.GPXFile gpx = new GPXUtilities.GPXFile();
        for (FavouritePoint p : favoritePoints) {
            GPXUtilities.WptPt pt = new GPXUtilities.WptPt();
            pt.lat = p.getLatitude();
            pt.lon = p.getLongitude();
            if (!p.isVisible()) {
                pt.getExtensionsToWrite().put(HIDDEN, "true");
            }
            if (p.getColor() != 0) {
                pt.setColor(p.getColor());
            }
            pt.name = p.getName();
            pt.desc = p.getDescription();
            if (p.getCategory().length() > 0) {
                pt.category = p.getCategory();
            }
            gpx.points.add(pt);
        }
        return gpx;
    }

    public void addEmptyCategory(String name) {
        FavoriteGroup group = new FavoriteGroup();
        group.name = name;
        this.favoriteGroups.add(group);
        this.flatGroups.put(name, group);
    }

    public void addEmptyCategory(String name, int color2) {
        FavoriteGroup group = new FavoriteGroup();
        group.name = name;
        group.color = color2;
        this.favoriteGroups.add(group);
        this.flatGroups.put(name, group);
    }

    public List<FavouritePoint> getFavouritePoints() {
        return this.cachedFavoritePoints;
    }

    public List<FavoriteGroup> getFavoriteGroups() {
        return this.favoriteGroups;
    }

    public boolean groupExists(String name) {
        String nameLowercase = name.toLowerCase();
        for (String groupName : this.flatGroups.keySet()) {
            if (!groupName.toLowerCase().equals(nameLowercase)) continue;
            return true;
        }
        return false;
    }

    public FavoriteGroup getGroup(FavouritePoint p) {
        if (this.flatGroups.containsKey(p.getCategory())) {
            return this.flatGroups.get(p.getCategory());
        }
        return null;
    }

    public FavoriteGroup getGroup(String name) {
        if (this.flatGroups.containsKey(name)) {
            return this.flatGroups.get(name);
        }
        return null;
    }

    private FavouritePoint findFavoriteByAllProperties(String category, String name, double lat, double lon) {
        if (this.flatGroups.containsKey(category)) {
            FavoriteGroup fg = this.flatGroups.get(category);
            for (FavouritePoint fv : fg.points) {
                if (!name.equals(fv.getName()) || lat != fv.getLatitude() || lon != fv.getLongitude()) continue;
                return fv;
            }
        }
        return null;
    }

    private void recalculateCachedFavPoints() {
        ArrayList<FavouritePoint> temp = new ArrayList<FavouritePoint>();
        for (FavoriteGroup f : this.favoriteGroups) {
            temp.addAll(f.points);
        }
        this.cachedFavoritePoints = temp;
    }

    public void sortAll() {
        final Collator collator = Collator.getInstance();
        collator.setStrength(1);
        Collections.sort(this.favoriteGroups, new Comparator<FavoriteGroup>(){

            @Override
            public int compare(FavoriteGroup lhs, FavoriteGroup rhs) {
                return collator.compare(lhs.name, rhs.name);
            }
        });
        Comparator<FavouritePoint> favoritesComparator = FavouritesDbHelper.getComparator();
        for (FavoriteGroup g : this.favoriteGroups) {
            Collections.sort(g.points, favoritesComparator);
        }
        if (this.cachedFavoritePoints != null) {
            Collections.sort(this.cachedFavoritePoints, favoritesComparator);
        }
    }

    public static Comparator<FavouritePoint> getComparator() {
        final Collator collator = Collator.getInstance();
        collator.setStrength(1);
        Comparator<FavouritePoint> favoritesComparator = new Comparator<FavouritePoint>(){

            @Override
            public int compare(FavouritePoint o1, FavouritePoint o2) {
                int res;
                String s1 = o1.getName();
                String s2 = o2.getName();
                int i1 = Algorithms.extractIntegerNumber(s1);
                int i2 = Algorithms.extractIntegerNumber(s2);
                String ot1 = Algorithms.extractIntegerPrefix(s1);
                String ot2 = Algorithms.extractIntegerPrefix(s2);
                if (ot1.length() == 0) {
                    ot1 = s1;
                }
                if (ot2.length() == 0) {
                    ot2 = s2;
                }
                if ((res = collator.compare(ot1, ot2)) == 0) {
                    res = i1 - i2;
                }
                if (res == 0) {
                    res = collator.compare(s1, s2);
                }
                return res;
            }
        };
        return favoritesComparator;
    }

    private boolean loadGPXFile(File file, Map<String, FavouritePoint> points) {
        if (!file.exists()) {
            return false;
        }
        GPXUtilities.GPXFile res = GPXUtilities.loadGPXFile(this.context, file);
        if (res.warning != null) {
            return false;
        }
        for (GPXUtilities.WptPt p : res.points) {
            int c;
            String categoryName;
            String name = p.name;
            String string2 = categoryName = p.category != null ? p.category : "";
            if (name == null) {
                name = "";
            }
            if ("".equals(categoryName.trim()) && (c = name.lastIndexOf(95)) != -1) {
                categoryName = name.substring(c + 1);
                name = name.substring(0, c);
            }
            FavouritePoint fp = new FavouritePoint(p.lat, p.lon, name, categoryName);
            fp.setDescription(p.desc);
            fp.setColor(p.getColor(0));
            fp.setVisible(!p.getExtensionsToRead().containsKey(HIDDEN));
            points.put(this.getKey(fp), fp);
        }
        return true;
    }

    public void editFavouriteGroup(FavoriteGroup group, String newName, int color2, boolean visible) {
        FavoriteGroup gr;
        if (color2 != 0 && group.color != color2) {
            gr = this.flatGroups.get(group.name);
            group.color = color2;
            for (FavouritePoint p : gr.points) {
                p.setColor(color2);
            }
        }
        if (group.visible != visible) {
            gr = this.flatGroups.get(group.name);
            group.visible = visible;
            for (FavouritePoint p : gr.points) {
                p.setVisible(visible);
            }
        }
        if (!group.name.equals(newName)) {
            boolean existing;
            gr = this.flatGroups.remove(group.name);
            gr.name = newName;
            FavoriteGroup renamedGroup = this.flatGroups.get(gr.name);
            boolean bl = existing = renamedGroup != null;
            if (renamedGroup == null) {
                renamedGroup = gr;
                this.flatGroups.put(gr.name, gr);
            } else {
                this.favoriteGroups.remove(gr);
            }
            for (FavouritePoint p : gr.points) {
                p.setCategory(newName);
                if (!existing) continue;
                renamedGroup.points.add(p);
            }
        }
        this.saveCurrentPointsIntoFile();
    }

    protected void createDefaultCategories() {
        this.addEmptyCategory(this.context.getString(412));
        this.addEmptyCategory(this.context.getString(413));
        this.addEmptyCategory(this.context.getString(414));
        this.addEmptyCategory(this.context.getString(415));
    }

    private FavoriteGroup getOrCreateGroup(FavouritePoint p, int defColor) {
        if (this.flatGroups.containsKey(p.getCategory())) {
            return this.flatGroups.get(p.getCategory());
        }
        FavoriteGroup group = new FavoriteGroup();
        group.name = p.getCategory();
        group.visible = p.isVisible();
        group.color = p.getColor();
        this.flatGroups.put(group.name, group);
        this.favoriteGroups.add(group);
        if (group.color == 0) {
            group.color = defColor;
        }
        return group;
    }

    private SQLiteAPI.SQLiteConnection openConnection(boolean readonly) {
        this.conn = this.context.getSQLiteAPI().getOrCreateDatabase("favourite", readonly);
        if (this.conn.getVersion() == 0 || 2 != this.conn.getVersion()) {
            if (readonly) {
                this.conn.close();
                this.conn = this.context.getSQLiteAPI().getOrCreateDatabase("favourite", readonly);
            }
            if (this.conn.getVersion() == 0) {
                this.onCreate(this.conn);
            } else {
                this.onUpgrade(this.conn, this.conn.getVersion(), 2);
            }
            this.conn.setVersion(2);
        }
        return this.conn;
    }

    public void onCreate(SQLiteAPI.SQLiteConnection db) {
        db.execSQL(FAVOURITE_TABLE_CREATE);
    }

    public void onUpgrade(SQLiteAPI.SQLiteConnection db, int oldVersion, int newVersion) {
        if (oldVersion == 1) {
            db.execSQL("ALTER TABLE favourite ADD category text");
            db.execSQL("UPDATE favourite SET category = ?", new Object[]{""});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAndCheckDatabasePoints() {
        if (this.favoriteGroups == null) {
            SQLiteAPI.SQLiteConnection db = this.openConnection(true);
            if (db != null) {
                try {
                    SQLiteAPI.SQLiteCursor query = db.rawQuery("SELECT name, category, latitude,longitude FROM favourite", null);
                    this.cachedFavoritePoints.clear();
                    if (query.moveToFirst()) {
                        do {
                            String name = query.getString(0);
                            String cat = query.getString(1);
                            FavouritePoint p = new FavouritePoint();
                            p.setName(name);
                            p.setCategory(cat);
                            FavoriteGroup group = this.getOrCreateGroup(p, 0);
                            if (name.equals("")) continue;
                            p.setLatitude(query.getDouble(2));
                            p.setLongitude(query.getDouble(3));
                            group.points.add(p);
                        } while (query.moveToNext());
                    }
                    query.close();
                }
                finally {
                    db.close();
                }
                this.sortAll();
            }
            this.recalculateCachedFavPoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFavouriteDB(FavouritePoint p) {
        SQLiteAPI.SQLiteConnection db = this.openConnection(false);
        if (db != null) {
            try {
                db.execSQL("DELETE FROM favourite WHERE category = ? AND " + this.whereNameLatLon(), new Object[]{p.getCategory(), p.getName(), p.getLatitude(), p.getLongitude()});
                FavouritePoint fp = this.findFavoriteByAllProperties(p.getCategory(), p.getName(), p.getLatitude(), p.getLongitude());
                if (fp != null) {
                    FavoriteGroup group = this.flatGroups.get(p.getCategory());
                    if (group != null) {
                        group.points.remove(fp);
                    }
                    this.cachedFavoritePoints.remove(fp);
                }
                this.saveCurrentPointsIntoFile();
            }
            finally {
                db.close();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFavouriteDB(FavouritePoint p) {
        if (p.getName().equals("") && this.flatGroups.containsKey(p.getCategory())) {
            return true;
        }
        SQLiteAPI.SQLiteConnection db = this.openConnection(false);
        if (db != null) {
            try {
                db.execSQL("INSERT INTO favourite (name, category, latitude, longitude) VALUES (?, ?, ?, ?)", new Object[]{p.getName(), p.getCategory(), p.getLatitude(), p.getLongitude()});
                FavoriteGroup group = this.getOrCreateGroup(p, 0);
                if (!p.getName().equals("")) {
                    p.setVisible(group.visible);
                    p.setColor(group.color);
                    group.points.add(p);
                    this.cachedFavoritePoints.add(p);
                }
                this.saveCurrentPointsIntoFile();
            }
            finally {
                db.close();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editFavouriteNameDB(FavouritePoint p, String newName, String category) {
        SQLiteAPI.SQLiteConnection db = this.openConnection(false);
        if (db != null) {
            try {
                String oldCategory = p.getCategory();
                db.execSQL("UPDATE favourite SET name = ?, category= ? WHERE " + this.whereNameLatLon(), new Object[]{newName, category, p.getName(), p.getLatitude(), p.getLongitude()});
                p.setName(newName);
                p.setCategory(category);
                if (!oldCategory.equals(category)) {
                    FavoriteGroup old = this.flatGroups.get(oldCategory);
                    if (old != null) {
                        old.points.remove(p);
                    }
                    FavoriteGroup pg = this.getOrCreateGroup(p, 0);
                    p.setVisible(pg.visible);
                    p.setColor(pg.color);
                    pg.points.add(p);
                }
                this.sortAll();
            }
            finally {
                db.close();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editFavouriteDB(FavouritePoint p, double lat, double lon) {
        SQLiteAPI.SQLiteConnection db = this.openConnection(false);
        if (db != null) {
            try {
                db.execSQL("UPDATE favourite SET latitude = ?, longitude = ? WHERE " + this.whereNameLatLon(), new Object[]{lat, lon, p.getName(), p.getLatitude(), p.getLongitude()});
                p.setLatitude(lat);
                p.setLongitude(lon);
                this.saveCurrentPointsIntoFile();
            }
            finally {
                db.close();
            }
            return true;
        }
        return false;
    }

    private String whereNameLatLon() {
        String singleFavourite = " name= ? AND latitude = ? AND longitude = ?";
        return singleFavourite;
    }

    public static class FavoriteGroup {
        public String name;
        public boolean visible = true;
        public int color;
        public List<FavouritePoint> points = new ArrayList<FavouritePoint>();
    }

    public static interface FavoritesUpdatedListener {
        public void updateFavourites();
    }
}

