/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.download;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import net.osmand.PlatformUtil;
import net.osmand.map.OsmandRegions;
import net.osmand.plus.download.DownloadActivityType;
import net.osmand.plus.download.DownloadResourceGroup;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;

public class IndexItem
implements Comparable<IndexItem> {
    private static final Log log = PlatformUtil.getLog(IndexItem.class);
    String description;
    String fileName;
    String size;
    long timestamp;
    long contentSize;
    long containerSize;
    DownloadActivityType type;
    boolean extra;
    boolean outdated;
    boolean downloaded;
    long localTimestamp;
    DownloadResourceGroup relatedGroup;

    public IndexItem(String fileName, String description, long timestamp, String size, long contentSize, long containerSize, DownloadActivityType tp) {
        this.fileName = fileName;
        this.description = description;
        this.timestamp = timestamp;
        this.size = size;
        this.contentSize = contentSize;
        this.containerSize = containerSize;
        this.type = tp;
    }

    public DownloadActivityType getType() {
        return this.type;
    }

    public void setRelatedGroup(DownloadResourceGroup relatedGroup) {
        this.relatedGroup = relatedGroup;
    }

    public DownloadResourceGroup getRelatedGroup() {
        return this.relatedGroup;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSize() {
        return this.containerSize;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public double getContentSizeMB() {
        return (double)this.contentSize / 1048576.0;
    }

    public double getArchiveSizeMB() {
        return (double)this.containerSize / 1048576.0;
    }

    public String getSizeDescription() {
        return this.size + " MB";
    }

    public DownloadEntry createDownloadEntry(OsmWindow ctx) {
        DownloadEntry entry;
        String fileName = this.fileName;
        File parent = this.type.getDownloadFolder(ctx, this);
        boolean preventMediaIndexing = this.type.preventMediaIndexing(ctx, this);
        if (parent != null) {
            parent.mkdirs();
            if (preventMediaIndexing) {
                try {
                    new File(parent, ".nomedia").createNewFile();
                }
                catch (IOException e) {
                    log.error((Object)"IOException", (Throwable)e);
                }
            }
        }
        if (parent == null || !parent.exists()) {
            entry = null;
        } else {
            entry = new DownloadEntry();
            entry.type = this.type;
            entry.baseName = this.getBasename();
            entry.urlToDownload = entry.type.getBaseUrl(ctx, fileName) + entry.type.getUrlSuffix(ctx);
            entry.zipStream = this.type.isZipStream(ctx, this);
            entry.unzipFolder = this.type.isZipFolder(ctx, this);
            entry.dateModified = this.timestamp;
            entry.sizeMB = (float)this.contentSize / 1048576.0f;
            entry.targetFile = this.getTargetFile(ctx);
        }
        return entry;
    }

    public String getTargetFileName() {
        return this.type.getTargetFileName(this);
    }

    public String getBasename() {
        return this.type.getBasename(this);
    }

    public File getTargetFile(OsmWindow ctx) {
        String basename = this.type == DownloadActivityType.HILLSHADE_FILE ? ("Hillshade_" + this.getBasename()).replace("_", " ") : this.getBasename();
        return new File(this.type.getDownloadFolder(ctx, this), basename + this.type.getUnzipExtension(ctx, this));
    }

    public File getBackupFile(OsmWindow ctx) {
        File backup = new File(ctx.getAppPath("backup/"), this.getTargetFile(ctx).getName());
        return backup;
    }

    @Override
    public int compareTo(IndexItem another) {
        return this.getFileName().compareTo(another.getFileName());
    }

    public String getDaysBehind(OsmWindow app) {
        if (this.localTimestamp > 0L) {
            long days = Math.max(1L, (this.getTimestamp() - this.localTimestamp) / 86400000L + 1L);
            return days + " " + app.getString(1678);
        }
        return "";
    }

    public String getRemoteDate(DateFormat dateFormat) {
        if (this.timestamp <= 0L) {
            return "";
        }
        return dateFormat.format(new Date(this.timestamp));
    }

    public String getLocalDate(DateFormat dateFormat) {
        if (this.localTimestamp <= 0L) {
            return "";
        }
        return dateFormat.format(new Date(this.localTimestamp));
    }

    public boolean isOutdated() {
        return this.outdated && this.getType() != DownloadActivityType.HILLSHADE_FILE;
    }

    public void setOutdated(boolean outdated) {
        this.outdated = outdated;
    }

    public void setDownloaded(boolean downloaded) {
        this.downloaded = downloaded;
    }

    public void setLocalTimestamp(long localTimestamp) {
        this.localTimestamp = localTimestamp;
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public String getVisibleName(OsmWindow ctx, OsmandRegions osmandRegions) {
        return this.type.getVisibleName(this, ctx, osmandRegions, true);
    }

    public String getVisibleName(OsmWindow ctx, OsmandRegions osmandRegions, boolean includingParent) {
        return this.type.getVisibleName(this, ctx, osmandRegions, includingParent);
    }

    public String getVisibleDescription(OsmWindow clctx) {
        return this.type.getVisibleDescription(this, clctx);
    }

    public String getDate(DateFormat format) {
        return format.format(new Date(this.timestamp));
    }

    public static class DownloadEntry {
        public long dateModified;
        public double sizeMB;
        public File targetFile;
        public boolean zipStream;
        public boolean unzipFolder;
        public File fileToDownload;
        public String baseName;
        public String urlToDownload;
        public boolean isAsset;
        public String assetName;
        public DownloadActivityType type;

        public DownloadEntry() {
        }

        public DownloadEntry(String assetName, String fileName, long dateModified) {
            this.dateModified = dateModified;
            this.targetFile = new File(fileName);
            this.assetName = assetName;
            this.isAsset = true;
        }
    }
}

