/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

public class Anchor {
    public static final Anchor LEFT_BOTTOM = new Anchor(0);
    public static final Anchor CENTER = new Anchor(1);
    public static final Anchor RIGHT_TOP = new Anchor(2);
    private static final String LEFT_VALUE = "left";
    private static final String RIGHT_VALUE = "right";
    private static final String CENTER_VALUE = "center";
    private static final String TOP_VALUE = "top";
    private static final String BOTTOM_VALUE = "bottom";
    private final int _factor;

    public static Anchor getHorizontalAnchor(ConfigParameters config, String key, Anchor defaultValue) {
        Anchor result = defaultValue;
        String anchor = config.get(key, null);
        if (anchor != null) {
            if (anchor.equals(LEFT_VALUE)) {
                result = LEFT_BOTTOM;
            } else if (anchor.equals(CENTER_VALUE)) {
                result = CENTER;
            } else if (anchor.equals(RIGHT_VALUE)) {
                result = RIGHT_TOP;
            } else {
                throw new FactoryException(config, key, "Invalid horizontal anchor.");
            }
        }
        return result;
    }

    public static Anchor getVerticalAnchor(ConfigParameters config, String key, Anchor defaultValue) {
        Anchor result = defaultValue;
        String anchor = config.get(key, null);
        if (anchor != null) {
            if (anchor.equals(BOTTOM_VALUE)) {
                result = LEFT_BOTTOM;
            } else if (anchor.equals(CENTER_VALUE)) {
                result = CENTER;
            } else if (anchor.equals(TOP_VALUE)) {
                result = RIGHT_TOP;
            } else {
                throw new FactoryException(config, key, "Invalid vertcal anchor.");
            }
        }
        return result;
    }

    private Anchor(int factor) {
        this._factor = factor;
    }

    public int getFactor() {
        return this._factor;
    }
}

