/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

public class FoxSignature {
    private static final long[] masks = new long[127];

    public static void printMe() {
        for (int i = 0; i < masks.length; ++i) {
            if (masks[i] <= 0L) continue;
            char ch = (char)i;
            System.err.println("ch=" + ch + " " + masks[i]);
        }
    }

    private static long getMask(char ch) {
        if (ch < masks.length) {
            return masks[ch];
        }
        return 0L;
    }

    public static long getFoxSignature(String s) {
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            result |= FoxSignature.getMask(s.charAt(i));
        }
        return result;
    }

    public static String backToString(long check) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < masks.length; ++i) {
            if (masks[i] == 0L || (check & masks[i]) == 0L) continue;
            char ch = (char)i;
            sb.append(ch);
        }
        return sb.toString();
    }

    static {
        String full = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~";
        long m = 1L;
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~".length(); ++i) {
            char ch = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~".charAt(i);
            FoxSignature.masks[ch] = m;
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
                FoxSignature.masks[ch] = m;
            }
            m <<= 1;
        }
    }
}

