/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryArrowAndCircle;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircle;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleConnect;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleCross;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleCrowfoot;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleLine;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCrowfoot;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryDiamond;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryDoubleLine;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryHalfArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryLineCrowfoot;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryNotNavigable;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryParenthesis;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryPlus;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactorySquarre;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryTriangle;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public enum LinkDecor {
    NONE(2, false, 0.0),
    EXTENDS(30, false, 2.0),
    COMPOSITION(15, true, 1.3),
    AGREGATION(15, false, 1.3),
    NOT_NAVIGABLE(1, false, 0.5),
    CROWFOOT(10, true, 0.8),
    CIRCLE_CROWFOOT(14, false, 0.8),
    CIRCLE_LINE(10, false, 0.8),
    DOUBLE_LINE(7, false, 0.7),
    LINE_CROWFOOT(10, false, 0.8),
    ARROW(10, true, 0.5),
    ARROW_TRIANGLE(10, true, 0.8),
    ARROW_AND_CIRCLE(10, false, 0.5),
    CIRCLE(0, false, 0.5),
    CIRCLE_FILL(0, false, 0.5),
    CIRCLE_CONNECT(0, false, 0.5),
    PARENTHESIS(0, false, 1.0),
    SQUARE(0, false, 0.5),
    CIRCLE_CROSS(0, false, 0.5),
    PLUS(0, false, 1.5),
    HALF_ARROW(0, false, 1.5),
    SQUARRE_toberemoved(30, false, 0.0);

    private final double arrowSize;
    private final int margin;
    private final boolean fill;

    private LinkDecor(int margin, boolean fill, double arrowSize) {
        this.margin = margin;
        this.fill = fill;
        this.arrowSize = arrowSize;
    }

    public int getMargin() {
        return this.margin;
    }

    public boolean isFill() {
        return this.fill;
    }

    public double getArrowSize() {
        return this.arrowSize;
    }

    public ExtremityFactory getExtremityFactory(HColor backgroundColor) {
        if (this == PLUS) {
            return new ExtremityFactoryPlus();
        }
        if (this == HALF_ARROW) {
            return new ExtremityFactoryHalfArrow();
        }
        if (this == ARROW_TRIANGLE) {
            return new ExtremityFactoryTriangle();
        }
        if (this == CROWFOOT) {
            return new ExtremityFactoryCrowfoot();
        }
        if (this == CIRCLE_CROWFOOT) {
            return new ExtremityFactoryCircleCrowfoot();
        }
        if (this == LINE_CROWFOOT) {
            return new ExtremityFactoryLineCrowfoot();
        }
        if (this == CIRCLE_LINE) {
            return new ExtremityFactoryCircleLine();
        }
        if (this == DOUBLE_LINE) {
            return new ExtremityFactoryDoubleLine();
        }
        if (this == CIRCLE_CROSS) {
            return new ExtremityFactoryCircleCross();
        }
        if (this == ARROW) {
            return new ExtremityFactoryArrow();
        }
        if (this == ARROW_AND_CIRCLE) {
            return new ExtremityFactoryArrowAndCircle();
        }
        if (this == NOT_NAVIGABLE) {
            return new ExtremityFactoryNotNavigable();
        }
        if (this == AGREGATION) {
            return new ExtremityFactoryDiamond(false, backgroundColor);
        }
        if (this == COMPOSITION) {
            return new ExtremityFactoryDiamond(true, backgroundColor);
        }
        if (this == CIRCLE) {
            return new ExtremityFactoryCircle(false);
        }
        if (this == CIRCLE_FILL) {
            return new ExtremityFactoryCircle(true);
        }
        if (this == SQUARE) {
            return new ExtremityFactorySquarre();
        }
        if (this == PARENTHESIS) {
            return new ExtremityFactoryParenthesis();
        }
        if (this == CIRCLE_CONNECT) {
            return new ExtremityFactoryCircleConnect();
        }
        return null;
    }
}

