/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.BoardCollection;
import net.sourceforge.plantuml.graph.KenavoCostComputer;
import net.sourceforge.plantuml.graph.Move;

public class BoardExplorer {
    private final BoardCollection all = new BoardCollection(new KenavoCostComputer());

    public BoardExplorer(Board init) {
        this.all.add(init);
    }

    public double getBestCost() {
        return this.all.getBestCost();
    }

    public Board getBestBoard() {
        return this.all.getBestBoard();
    }

    public int collectionSize() {
        return this.all.size();
    }

    public boolean onePass() {
        Board smallest = this.all.getAndSetExploredSmallest();
        if (smallest == null) {
            return true;
        }
        Set<Board> moves = this.nextBoards(smallest);
        for (Board newBoard : moves) {
            if (this.all.contains(newBoard)) continue;
            this.all.add(newBoard);
        }
        return false;
    }

    public Set<Board> nextBoards(Board board) {
        HashSet<Board> result = new HashSet<Board>();
        for (Move m : board.getAllPossibleMoves()) {
            Board copy = board.copy();
            copy.applyMove(m);
            result.add(copy);
        }
        return result;
    }
}

