/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graph2.Dijkstra;
import net.sourceforge.plantuml.graph2.GeomUtils;
import net.sourceforge.plantuml.graph2.Neighborhood2;
import net.sourceforge.plantuml.graph2.Singularity2;

public class Plan {
    private final Map<Point2D.Double, Singularity2> points = new LinkedHashMap<Point2D.Double, Singularity2>();
    private final Collection<Line2D.Double> lines = new ArrayList<Line2D.Double>();

    public void addPoint2D(Point2D.Double point) {
        if (this.points.containsKey(point)) {
            throw new IllegalArgumentException();
        }
        this.points.put(point, new Singularity2(point));
    }

    public void debugPrint() {
        Log.println("PLAN PRINT");
        for (Singularity2 s : this.points.values()) {
            Log.println("s=" + s);
        }
        for (Line2D.Double l : this.lines) {
            Log.println(GeomUtils.toString(l));
        }
    }

    public void createLink(Point2D p1, Point2D p2) {
        Singularity2 s1 = this.points.get(p1);
        Singularity2 s2 = this.points.get(p2);
        if (s1 == null || s2 == null) {
            throw new IllegalArgumentException();
        }
        Line2D.Double line = new Line2D.Double(p1, p2);
        s1.addLineSegment(line);
        s2.addLineSegment(line);
        this.lines.add(line);
    }

    Singularity2 getSingularity(Point2D pt) {
        Singularity2 result = this.points.get(pt);
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    List<Neighborhood2> getShortestPathToInternal(Point2D start, Point2D end) {
        Dijkstra dijkstra = new Dijkstra();
        if (!this.points.containsKey(start) || !this.points.containsKey(end)) {
            throw new IllegalArgumentException();
        }
        Dijkstra.Vertex vStart = dijkstra.addVertex(start);
        Dijkstra.Vertex vEnd = dijkstra.addVertex(end);
        LinkedHashMap<Neighborhood2, Dijkstra.Vertex> vertexes = new LinkedHashMap<Neighborhood2, Dijkstra.Vertex>();
        for (Singularity2 s : this.points.values()) {
            for (Neighborhood2 n : s.getNeighborhoods()) {
                Dijkstra.Vertex v = dijkstra.addVertex(n);
                vertexes.put(n, v);
                if (n.getCenter().equals(start)) {
                    vStart.addAdjacencies(v, 0.01);
                }
                if (!n.getCenter().equals(end)) continue;
                v.addAdjacencies(vEnd, 0.01);
            }
        }
        for (Dijkstra.Vertex v1 : vertexes.values()) {
            for (Dijkstra.Vertex v2 : vertexes.values()) {
                Line2D.Double line;
                Neighborhood2 n1 = (Neighborhood2)v1.getData();
                Neighborhood2 n2 = (Neighborhood2)v2.getData();
                if (n1.getCenter().equals(n2.getCenter()) || this.isStrictCrossing(line = new Line2D.Double(n1.getCenter(), n2.getCenter())) || !n1.isConnectable(n2)) continue;
                double dist = n1.getCenter().distance(n2.getCenter());
                v1.addAdjacencies(v2, dist);
                v2.addAdjacencies(v1, dist);
            }
        }
        List<Dijkstra.Vertex> list = dijkstra.getShortestPathTo(vStart, vEnd);
        if (list.size() < 2) {
            throw new IllegalStateException("list=" + list);
        }
        ArrayList<Neighborhood2> result = new ArrayList<Neighborhood2>();
        for (Dijkstra.Vertex v : list.subList(1, list.size() - 1)) {
            result.add((Neighborhood2)v.getData());
        }
        return result;
    }

    public List<Point2D.Double> getIntermediatePoints(Point2D start, Point2D end) {
        ArrayList<Point2D.Double> result = new ArrayList<Point2D.Double>();
        List<Neighborhood2> list = this.getShortestPathToInternal(start, end);
        for (int i = 1; i < list.size() - 1; ++i) {
            Neighborhood2 n = list.get(i);
            Point2D.Double before = list.get(i - 1).getCenter();
            Point2D.Double after = list.get(i + 1).getCenter();
            Point2D.Double pointInNeighborhood = n.getPointInNeighborhood(this.getMindist(n.getCenter()) / 2.0, before, after);
            result.add(pointInNeighborhood);
        }
        return result;
    }

    private boolean isStrictCrossing(Line2D.Double line) {
        for (Line2D.Double l : this.lines) {
            if (!Plan.intersectsLineStrict(l, line)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersectsLineStrict(Line2D.Double l1, Line2D.Double l2) {
        assert (Plan.intersectsLineStrictInternal(l1, l2) == Plan.intersectsLineStrictInternal(l2, l1));
        assert (Plan.intersectsLineStrictInternal(l1, l2) == Plan.intersectsLineStrictInternal(Plan.inverse(l1), l2));
        assert (Plan.intersectsLineStrictInternal(l1, l2) == Plan.intersectsLineStrictInternal(l1, Plan.inverse(l2)));
        assert (Plan.intersectsLineStrictInternal(l1, l2) == Plan.intersectsLineStrictInternal(Plan.inverse(l1), Plan.inverse(l2)));
        return Plan.intersectsLineStrictInternal(l1, l2);
    }

    private static Line2D.Double inverse(Line2D.Double line) {
        return new Line2D.Double(line.getP2(), line.getP1());
    }

    private static boolean intersectsLineStrictInternal(Line2D.Double l1, Line2D.Double l2) {
        if (!l1.intersectsLine(l2)) {
            return false;
        }
        assert (l1.intersectsLine(l2));
        Point2D.Double l1a = (Point2D.Double)l1.getP1();
        Point2D.Double l1b = (Point2D.Double)l1.getP2();
        Point2D.Double l2a = (Point2D.Double)l2.getP1();
        Point2D.Double l2b = (Point2D.Double)l2.getP2();
        if (!(l1a.equals(l2a) || l1a.equals(l2b) || l1b.equals(l2a) || l1b.equals(l2b))) {
            return true;
        }
        if (l1a.equals(l2b)) {
            Point2D.Double tmp = l2a;
            l2a = l2b;
            l2b = tmp;
        } else if (l2a.equals(l1b)) {
            Point2D.Double tmp = l1a;
            l1a = l1b;
            l1b = tmp;
        } else if (l1b.equals(l2b)) {
            Point2D.Double tmp = l2a;
            l2a = l2b;
            l2b = tmp;
            tmp = l1a;
            l1a = l1b;
            l1b = tmp;
        }
        assert (l1a.equals(l2a));
        return false;
    }

    final double getMindist(Point2D.Double pt) {
        double v;
        double result = Double.MAX_VALUE;
        for (Point2D point2D : this.points.keySet()) {
            if (pt.equals(point2D)) continue;
            v = point2D.distance(pt);
            if (v < 1.0E-4) {
                throw new IllegalStateException();
            }
            result = Math.min(result, v);
        }
        for (Line2D line2D : this.lines) {
            if (line2D.getP1().equals(pt) || line2D.getP2().equals(pt)) continue;
            v = line2D.ptSegDist(pt);
            if (result < 1.0E-4) {
                throw new IllegalStateException("pt=" + pt + " line=" + GeomUtils.toString(line2D));
            }
            result = Math.min(result, v);
        }
        if (result == 0.0) {
            throw new IllegalStateException();
        }
        return result;
    }
}

