/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graph2.GeomUtils;

public class Polyline2 {
    private final List<Line2D.Double> lines = new ArrayList<Line2D.Double>();
    private Point2D lastCurrent;
    private final Point2D end;
    private boolean debug = false;

    public Polyline2(Point2D start, Point2D end) {
        this.lastCurrent = start;
        this.end = end;
    }

    public void addLine(Line2D.Double newLine) {
        if (!this.lastCurrent.equals(newLine.getP1())) {
            this.lines.add(new Line2D.Double(this.lastCurrent, newLine.getP1()));
        }
        this.lines.add(newLine);
        this.lastCurrent = newLine.getP2();
    }

    public void draw(Graphics2D g2d) {
        this.close();
        if (this.debug) {
            g2d.setColor(Color.GREEN);
            this.drawDebug(g2d);
        }
        g2d.setColor(Color.BLUE);
        ArrayList<Point2D.Double> centers = new ArrayList<Point2D.Double>();
        for (Line2D.Double l : this.lines) {
            centers.add(GeomUtils.getCenter(l));
        }
        g2d.draw(new Line2D.Double(this.lines.get(0).getP1(), (Point2D)centers.get(0)));
        g2d.draw(new Line2D.Double((Point2D)centers.get(centers.size() - 1), this.end));
        for (int i = 0; i < this.lines.size() - 1; ++i) {
            Point2D c1 = (Point2D)centers.get(i);
            Point2D c2 = (Point2D)centers.get(i + 1);
            Point2D ctrl = this.lines.get(i).getP2();
            assert (ctrl.equals(this.lines.get(i + 1).getP1()));
            QuadCurve2D.Double quad = new QuadCurve2D.Double(c1.getX(), c1.getY(), ctrl.getX(), ctrl.getY(), c2.getX(), c2.getY());
            g2d.draw(quad);
        }
        if (this.debug) {
            for (Point2D.Double c : centers) {
                GeomUtils.fillPoint2D(g2d, c);
            }
        }
    }

    private void drawDebug(Graphics2D g2d) {
        for (Line2D.Double l : this.lines) {
            g2d.draw(l);
            GeomUtils.fillPoint2D(g2d, l.getP1());
            GeomUtils.fillPoint2D(g2d, l.getP2());
        }
    }

    private void close() {
        if (!this.lastCurrent.equals(this.end)) {
            this.lines.add(new Line2D.Double(this.lastCurrent, this.end));
        }
    }
}

