/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.postit.AreaLayout;
import net.sourceforge.plantuml.postit.PostIt;

public class AreaLayoutFixedWidth
implements AreaLayout {
    private final double width;

    public AreaLayoutFixedWidth(double width) {
        this.width = width;
    }

    @Override
    public Map<PostIt, Point2D> getPositions(Collection<PostIt> all, StringBounder stringBounder) {
        double x = 0.0;
        double y = 0.0;
        double maxY = 0.0;
        LinkedHashMap<PostIt, Point2D.Double> result = new LinkedHashMap<PostIt, Point2D.Double>();
        for (PostIt p : all) {
            Dimension2D dim = p.getDimension(stringBounder);
            if (x + dim.getWidth() > this.width) {
                x = 0.0;
                y = maxY;
            }
            result.put(p, new Point2D.Double(x, y));
            x += dim.getWidth();
            maxY = Math.max(maxY, y + dim.getHeight());
        }
        return Collections.unmodifiableMap(result);
    }
}

