/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.TextBlockMap;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageMap
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock entries;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageMap(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        this.roundCorner = skinParam.getRoundCorner(CornerParam.DEFAULT, null);
        this.name = TextBlockUtils.withMargin(entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.OBJECT, stereotype), HorizontalAlignment.CENTER, skinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : Display.create(stereotype.getLabels(skinParam.guillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.entries = entity.getBodier().getBody(FontParam.OBJECT_ATTRIBUTE, skinParam, false, false, entity.getStereotype());
        this.url = entity.getUrl99();
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        return ((WithPorts)((Object)this.entries)).getPorts(stringBounder).translateY(dimTitle.getHeight());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        Dimension2D dimFields = this.entries.calculateDimension(stringBounder);
        double width = Math.max(dimFields.getWidth(), dimTitle.getWidth() + (double)(2 * this.xMarginCircle));
        if (width < this.getSkinParam().minClassWidth()) {
            width = this.getSkinParam().minClassWidth();
        }
        double height = this.getMethodOrFieldHeight(dimFields) + dimTitle.getHeight();
        return new Dimension2DDouble(width, height);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(this.roundCorner);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            rect.setDeltaShadow(4.0);
        }
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.objectBorder));
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.objectBackground);
        }
        ug = ug.apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UStroke stroke = this.getStroke();
        ug.apply(stroke).draw(rect);
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        if (this.stereo != null) {
            header.add(this.stereo);
        }
        header.add(this.name);
        header.drawU(ug, dimTotal.getWidth(), dimTitle.getHeight());
        UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
        ((TextBlockMap)this.entries).setTotalWidth(dimTotal.getWidth());
        this.entries.drawU(ug2.apply(UTranslate.dy(dimTitle.getHeight())));
        if (this.url != null) {
            ug.closeAction();
        }
    }

    private UStroke getStroke() {
        UStroke stroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (stroke == null) {
            stroke = this.getSkinParam().getThickness(LineParam.objectBorder, this.getStereo());
        }
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    private double getMethodOrFieldHeight(Dimension2D dim) {
        double fieldsHeight = dim.getHeight();
        if (fieldsHeight == 0.0 && this.getEntity().getLeafType() != LeafType.MAP) {
            return this.marginEmptyFieldsOrMethod;
        }
        return fieldsHeight;
    }

    private Dimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private Dimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        Dimension2D stereoDim = this.stereo == null ? new Dimension2DDouble(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        Dimension2DDouble nameAndStereo = new Dimension2DDouble(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE_HTML_FOR_PORTS;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

