/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class CallUserFunction
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%call_user_func", 1);
    }

    @Override
    public boolean canCover(int nbArg) {
        return nbArg > 0;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values) throws EaterException, EaterExceptionLocated {
        List<TValue> args;
        String fname = values.get(0).toString();
        TFunctionSignature signature = new TFunctionSignature(fname, (args = values.subList(1, values.size())).size());
        TFunction func = context.getFunctionSmart(signature);
        if (func == null) {
            throw EaterException.unlocated("Cannot find void function " + fname);
        }
        return func.executeReturnFunction(context, memory, location, args);
    }
}

