/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.DatatypeConverter;
import net.sf.sdedit.util.PWriter;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Ref;
import net.sf.sdedit.util.UIUtilities;

public class Utilities {
    private static Map<Class<?>, Class<?>> primitiveClasses = new HashMap();
    private static CL cl;
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    private static final Map<String, String> keys;

    private Utilities() {
    }

    private static CL cl() {
        if (cl == null) {
            cl = new CL();
        }
        return cl;
    }

    public static PrintWriter createPrintWriter() {
        return PWriter.create();
    }

    public static PrintWriter createPrintWriter(File file, String encoding) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outputStream, encoding);
            PrintWriter pw = new PrintWriter(osw);
            return pw;
        }
        catch (IOException e) {
            ((OutputStream)outputStream).close();
            throw e;
        }
    }

    public static String toString(PrintWriter pw) {
        pw.flush();
        return pw.toString();
    }

    public static void erase(File file, boolean recursive) {
        File[] files;
        if (recursive && (files = file.listFiles()) != null) {
            for (File _file : files) {
                Utilities.erase(_file, true);
            }
        }
        file.delete();
    }

    private static int cast(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static byte[] toByteArray(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            String hex = hexString.substring(i, i + 2);
            bytes[i / 2] = (byte)Integer.parseInt(hex, 16);
        }
        return bytes;
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String h = Integer.toHexString(Utilities.cast(bytes[i]));
            if (h.length() == 1) {
                h = "0" + h;
            }
            sb.append(h);
        }
        return sb.toString();
    }

    public static String cutToSize(String string, Charset charset, int length) {
        if (string == null) {
            return null;
        }
        if (length < 1) {
            return "";
        }
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer cb = CharBuffer.wrap(string.toCharArray());
        ByteBuffer bb = ByteBuffer.allocate(length);
        encoder.encode(cb, bb, false);
        bb.position(0);
        cb.clear();
        decoder.decode(bb, cb, false);
        int p = cb.position();
        char[] chars = new char[p];
        cb.position(0);
        cb.get(chars, 0, p);
        if (p == 1 && chars[0] == '\u0000' && string.length() > 1) {
            return "";
        }
        return new String(chars);
    }

    public static String toString(Date date) {
        return Utilities.toString(date, null);
    }

    public static Class<?> loadClass(String name, byte[] code) throws ClassNotFoundException {
        Utilities.cl().addClass(name, code);
        return Utilities.cl().loadClass(name);
    }

    public static byte[] zip(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        ZipEntry ze = new ZipEntry("X");
        zos.putNextEntry(ze);
        Utilities.pipe(is, zos);
        zos.closeEntry();
        zos.flush();
        zos.close();
        return bos.toByteArray();
    }

    public static byte[] unzip(byte[] bytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ZipInputStream zis = new ZipInputStream(bis);
            zis.getNextEntry();
            return Utilities.toByteArray(zis, -1);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Date toDate(String string, String format) {
        Date d;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(true);
        try {
            d = dateFormat.parse(string);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe);
        }
        return d;
    }

    public static String toString(Date date, String format) {
        DateFormat dateFormat = format != null ? new SimpleDateFormat(format) : DateFormat.getInstance();
        return dateFormat.format(date);
    }

    private static <T> T getFirst(Collection<T> set, boolean remove) {
        Iterator<T> iterator = set.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("The set is empty");
        }
        T first = iterator.next();
        if (remove) {
            iterator.remove();
        }
        return first;
    }

    public static <T> T pollFirst(Collection<T> set) {
        return Utilities.getFirst(set, true);
    }

    public static <T> T peekFirst(Collection<T> set) {
        return Utilities.getFirst(set, false);
    }

    public static <T, S extends T, U extends T> T nvl(S obj, U nullObject) {
        if (obj != null) {
            return obj;
        }
        return nullObject;
    }

    public static String lpad(String str, char pad, int len) {
        while (str.length() < len) {
            str = pad + "" + str;
        }
        return str;
    }

    public static int[] makeInts(int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("from=" + from + ", to=" + to);
        }
        int[] ints = new int[to - from + 1];
        for (int i = from; i <= to; ++i) {
            ints[i] = from + i;
        }
        return ints;
    }

    public static Object nvl2(Object obj, Object obj1, Object obj2) {
        return obj == null ? obj2 : obj1;
    }

    public static <T> LinkedList<T> singletonList(T element) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(element);
        return list;
    }

    public static String pad(char c, int length) {
        char[] characters = new char[length];
        Arrays.fill(characters, c);
        return new String(characters);
    }

    public static String getSimpleName(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static <T> T peek(Collection<T> set) {
        Iterator<T> iterator = set.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("The set is empty");
        }
        T first = iterator.next();
        return first;
    }

    public static String substring(String string, int pos, int length) {
        if (string.length() - pos <= length) {
            return string.substring(pos);
        }
        return string.substring(pos, pos + length);
    }

    public static String join(String token, Object[] objects) {
        if (objects != null) {
            String[] strings = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                strings[i] = objects[i].toString();
            }
            return Utilities.join(token, strings);
        }
        return "";
    }

    public static String join(String token, Collection<String> strings) {
        return Utilities.join(token, strings.toArray(new String[strings.size()]));
    }

    public static String join(String token, String[] strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < strings.length - 1; ++x) {
            sb.append(strings[x]);
            sb.append(token);
        }
        sb.append(strings[strings.length - 1]);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findMainClass(File jarFile) throws IOException {
        JarFile jf = new JarFile(jarFile);
        try {
            String mainClass;
            Manifest manifest = jf.getManifest();
            if (manifest == null) {
                String string = null;
                return string;
            }
            String string = mainClass = manifest.getMainAttributes().getValue("Main-Class");
            return string;
        }
        finally {
            jf.close();
        }
    }

    public static String findUniqueName(String name, List<String> names) {
        HashSet<String> nameSet = new HashSet<String>(names);
        if (!nameSet.contains(name)) {
            return name;
        }
        int i = 1;
        String trial;
        while (names.contains(trial = name + "-" + i)) {
            ++i;
        }
        return trial;
    }

    public static <T> boolean contains(T[] array, T elem) {
        return Utilities.indexOf(array, elem) >= 0;
    }

    public static <T> int indexOf(T[] array, T elem) {
        int i = 0;
        for (T t : array) {
            if (t.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static URL getResource(String name) {
        URL res = Utilities.class.getResource("/resource/" + name);
        return res;
    }

    public static <T> T[] reverse(T[] array) {
        Class<?> elemClass = array.getClass().getComponentType();
        int l = array.length;
        Object[] reverse = (Object[])Array.newInstance(elemClass, l);
        for (int i = 0; i < array.length; ++i) {
            reverse[l - i - 1] = array[i];
        }
        return reverse;
    }

    public static File toFile(URL url) {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return file;
    }

    public static <T, C extends Collection<T>> Collection<T> toCollection(Class<C> cls, T[] array) {
        try {
            Collection collection = (Collection)cls.newInstance();
            for (T t : array) {
                collection.add(t);
            }
            return collection;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    public static <T, S extends T, U extends T> T[] joinArrays(S[] array0, U[] array1, Class<T> elementClass) {
        int l0 = Array.getLength(array0);
        int l1 = Array.getLength(array1);
        Object[] array = (Object[])Array.newInstance(elementClass, l0 + l1);
        System.arraycopy(array0, 0, array, 0, l0);
        System.arraycopy(array1, 0, array, l0, l1);
        return array;
    }

    public static <T, C extends Collection<T>> Collection<T> flatten(Class<C> cls, Collection<? extends Collection<T>> collections) {
        try {
            Collection flatCollection = (Collection)cls.newInstance();
            for (Collection<T> collection : collections) {
                flatCollection.addAll(collection);
            }
            return flatCollection;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    public static byte[] toByteArray(InputStream inputStream, int size) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long length = size == -1 ? Long.MAX_VALUE : (long)size;
        Utilities.pipe(inputStream, out, length);
        return out.toByteArray();
    }

    public static byte[] load(File file) throws IOException {
        InputStream in = new FileInputStream(file);
        try {
            in = new BufferedInputStream(in);
            byte[] byArray = Utilities.toByteArray(in, -1);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, byte[] bytes) throws IOException {
        OutputStream os = new FileOutputStream(file);
        try {
            os = new BufferedOutputStream(os);
            for (int i = 0; i < bytes.length; i += 2048) {
                int len = Math.min(bytes.length - i, 2048);
                os.write(bytes, i, len);
            }
        }
        finally {
            os.close();
        }
    }

    public static String classesString(Object[] objects, boolean simple) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = objects[i] == null ? "null" : (simple ? objects[i].getClass().getSimpleName() : objects[i].getClass().getName());
        }
        return "[" + Utilities.join(",", strings) + "]";
    }

    public static String classesString(Collection<?> objects, boolean simple) {
        return Utilities.classesString(objects.toArray(), simple);
    }

    public static <T> T[] castArray(Object[] array, Class<T> componentType) {
        Object[] result = (Object[])Array.newInstance(componentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = componentType.cast(array[i]);
        }
        return result;
    }

    public static <T> Iterable<T> castIterable(final Object iterable, final Class<T> itemClass) {
        if (iterable == null) {
            return null;
        }
        if (iterable.getClass().isArray()) {
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new Iterator<T>(){
                        int i = 0;

                        @Override
                        public boolean hasNext() {
                            return this.i < Array.getLength(iterable);
                        }

                        @Override
                        public T next() {
                            return itemClass.cast(Array.get(iterable, this.i++));
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        if (Iterable.class.isAssignableFrom(iterable.getClass())) {
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new Iterator<T>(){
                        Iterator<?> iter;
                        {
                            this.iter = ((Iterable)iterable).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iter.hasNext();
                        }

                        @Override
                        public T next() {
                            return itemClass.cast(this.iter.next());
                        }

                        @Override
                        public void remove() {
                            this.iter.remove();
                        }
                    };
                }
            };
        }
        throw new IllegalArgumentException(iterable.getClass().getName() + " is not iterable");
    }

    public static <T> Iterable<T> wrap(final Iterator<?> iterator, final Class<T> elemClass) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return elemClass.cast(iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(URL url, Charset charset) throws IOException {
        InputStream stream = url.openStream();
        try {
            PWriter pw = PWriter.create();
            for (String line : Utilities.readLines(stream, charset)) {
                pw.println(line);
            }
            pw.flush();
            String string = pw.toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    public static void pipe(InputStream from, OutputStream to) throws IOException {
        Utilities.pipe(from, to, Long.MAX_VALUE);
    }

    public static void pipe(InputStream from, OutputStream to, long size) throws IOException {
        int EOF2 = -1;
        int BUFFER_SIZE = 1024;
        byte[] buffer = new byte[1024];
        long total = 0L;
        long diff;
        int length;
        while ((length = (diff = size - total) >= 1024L ? 1024 : (int)diff) > 0) {
            int n = from.read(buffer, 0, length);
            if (n == -1) {
                return;
            }
            to.write(buffer, 0, n);
            total += (long)n;
        }
        return;
    }

    public static Iterable<String> readLines(String command, Ref<InputStream> streamRef, Charset charset) throws IOException {
        Process proc = Runtime.getRuntime().exec(command);
        InputStream stream = proc.getInputStream();
        if (streamRef != null) {
            streamRef.t = stream;
        }
        return Utilities.readLines(stream, charset);
    }

    public static Iterable<String> readLines(String command, Charset charset) throws IOException {
        return Utilities.readLines(command, null, charset);
    }

    public static Iterable<String> readLines(File file, Ref<InputStream> streamRef, Charset charset) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        if (streamRef != null) {
            streamRef.t = stream;
        }
        return Utilities.readLines(stream, charset);
    }

    public static Iterable<String> readLines(File file, Charset charset) throws IOException {
        return Utilities.readLines(file, null, charset);
    }

    public static Iterable<String> readLines(URL url, Charset charset) throws IOException {
        return Utilities.readLines(url.openStream(), charset);
    }

    public static Iterable<String> readLines(final InputStream stream, Charset charset) throws IOException {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private String currentLine;

                    @Override
                    public boolean hasNext() {
                        try {
                            this.currentLine = reader.readLine();
                            if (this.currentLine == null) {
                                stream.close();
                            }
                        }
                        catch (IOException e) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw new IllegalStateException("Cannot read file", e);
                        }
                        return this.currentLine != null;
                    }

                    @Override
                    public String next() {
                        return this.currentLine;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Class<?> getWrapperClass(Class<?> primitiveClass) {
        return primitiveClasses.get(primitiveClass);
    }

    public static boolean isPrimitiveClass(Class<?> cls) {
        return Utilities.getWrapperClass(cls) != null;
    }

    public static String getDuration(long milliseconds, String format) {
        long ms = milliseconds - 3600000L;
        return Utilities.toString(new Date(ms), format);
    }

    public static <S, T> Pair<S, T> pair(S arg1, T arg2) {
        return new Pair<S, T>(arg1, arg2);
    }

    public static Object getField(Object obj, String name) {
        Object value;
        Field field;
        Class<?> klass;
        if (obj instanceof String) {
            try {
                klass = Class.forName((String)obj);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("class not found: " + obj);
            }
            obj = null;
        } else {
            klass = obj.getClass();
        }
        try {
            field = klass.getDeclaredField(name);
        }
        catch (Exception e) {
            try {
                field = klass.getField(name);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Field not available: " + klass.getName() + "." + name);
            }
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            value = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Field cannot be accessed: " + klass.getName() + "." + name);
        }
        return value;
    }

    public static Object invoke(String methodName, Object object, Object ... args) {
        Object result;
        Class<?> theClass;
        Object target = null;
        if (object instanceof String) {
            try {
                theClass = Class.forName((String)object);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (object instanceof Class) {
            theClass = (Class<?>)object;
        } else {
            theClass = object.getClass();
            target = object;
        }
        Method method = Utilities.resolveMethod(theClass, methodName, args);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            result = method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot access method " + methodName + " of " + object.getClass().getName());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
        return result;
    }

    public static <T> T clone(T t) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(t);
            out.flush();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(in);
            Object copy = ois.readObject();
            in.close();
            out.close();
            return (T)copy;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new IllegalStateException(th);
        }
    }

    public static Method resolveMethod(Class<?> clazz, String name, Object[] args) {
        Method[] methods = Utilities.joinArrays(clazz.getMethods(), clazz.getDeclaredMethods(), Method.class);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(name)) continue;
            Class<?>[] classes = m.getParameterTypes();
            if (args == null) {
                if (classes.length != 0) continue;
                return m;
            }
            boolean match = args.length == classes.length;
            for (int j = 0; match && j < args.length; ++j) {
                match = classes[j].isAssignableFrom(args[j].getClass()) || primitiveClasses.get(classes[j]) == args[j].getClass();
            }
            if (!match) continue;
            return m;
        }
        return null;
    }

    public static <T> Constructor<T> resolveConstructor(Class<T> clazz, Object ... args) {
        Constructor<?> c = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] classes = constructor.getParameterTypes();
            if (args.length == 0) {
                if (classes.length != 0) continue;
                c = constructor;
                break;
            }
            boolean match = args.length == classes.length;
            for (int j = 0; match && j < args.length; ++j) {
                match = classes[j].isAssignableFrom(args[j].getClass()) || primitiveClasses.get(classes[j]) == args[j].getClass();
            }
            if (!match) continue;
            c = constructor;
            break;
        }
        return c;
    }

    public static <T> boolean in(T element, T ... set) {
        for (T s : set) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static Method findMethod(Class<?> clazz, String name, boolean declared) {
        for (Method method : declared ? clazz.getDeclaredMethods() : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static <T> boolean computeDifference(Set<T> set0, Set<T> set1, Ref<Set<T>> set0Only, Ref<Set<T>> set1Only) {
        try {
            set0Only.t = set0.getClass().newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate another " + set0.getClass().getName(), e);
        }
        try {
            set1Only.t = set1.getClass().newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate another " + set1.getClass().getName(), e);
        }
        ((Set)set0Only.t).addAll(set0);
        ((Set)set1Only.t).addAll(set1);
        ((Set)set0Only.t).removeAll(set1);
        ((Set)set1Only.t).removeAll(set0);
        return ((Set)set0Only.t).isEmpty() && ((Set)set1Only.t).isEmpty();
    }

    public static Number round(Number number, Number unit) {
        double u;
        double n = number.doubleValue();
        double r = Math.IEEEremainder(n, u = unit.doubleValue());
        n = r < n / 2.0 ? (n -= r) : n + u - r;
        return new Double(n);
    }

    @Deprecated
    public static InputStream filter(String command, InputStream input, File workingDir) throws IOException {
        if (workingDir == null) {
            workingDir = new File(".");
        }
        Process process = Runtime.getRuntime().exec(command, new String[0], workingDir);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (input != null) {
            Utilities.pipe(input, process.getOutputStream());
        }
        return process.getInputStream();
    }

    public static int iIn(Object object, Object ... objects) {
        return Utilities.indexOf(objects, object);
    }

    public static File[] chooseFiles(JFileChooser fileChooser, Component component, boolean open, boolean multiple, String message, String file, String ... filter) {
        File[] files;
        fileChooser.setMultiSelectionEnabled(multiple);
        for (FileFilter fileFilter : fileChooser.getChoosableFileFilters()) {
            if (!(fileFilter instanceof MyFileFilter)) continue;
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        if (filter.length > 0) {
            int dot;
            for (int i = 0; i < filter.length; i += 2) {
                FileFilter fileFilter;
                final String description = filter[i];
                String suffix = filter[i + 1].toLowerCase();
                fileFilter = new MyFileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName().toLowerCase();
                        return name.endsWith(this.suffix);
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }
                };
                ((MyFileFilter)fileFilter).suffix = suffix;
                fileChooser.addChoosableFileFilter(fileFilter);
            }
            if (file != null && (dot = file.lastIndexOf(46)) >= 0) {
                String type = file.substring(dot + 1);
                for (FileFilter _filter : fileChooser.getChoosableFileFilters()) {
                    if (!(_filter instanceof MyFileFilter) || !((MyFileFilter)_filter).suffix.equals(type)) continue;
                    fileChooser.setFileFilter(_filter);
                    break;
                }
            }
        }
        fileChooser.setDialogTitle(message);
        int ret = open ? fileChooser.showOpenDialog(component) : fileChooser.showSaveDialog(component);
        if (ret == 0) {
            if (multiple) {
                files = fileChooser.getSelectedFiles() == null || fileChooser.getSelectedFiles().length == 0 ? null : fileChooser.getSelectedFiles();
            } else {
                FileFilter selectedFilter;
                File selectedFile = fileChooser.getSelectedFile();
                if (!open && (selectedFilter = fileChooser.getFileFilter()) instanceof MyFileFilter) {
                    String type = ((MyFileFilter)selectedFilter).suffix;
                    selectedFile = UIUtilities.affixType(selectedFile, type);
                }
                files = new File[]{selectedFile};
            }
        } else {
            files = null;
        }
        return files;
    }

    public static String generateKey() {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("DESede");
            return Utilities.toHexString(keygen.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] encrypt(byte[] bytes, String hexKey) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        SecretKeySpec key = new SecretKeySpec(Utilities.toByteArray(hexKey), "DESede");
        try {
            cipher = Cipher.getInstance("DESede");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        cipher.init(1, key);
        return cipher.doFinal(bytes);
    }

    public static List<Integer> getHashCodes(Collection<? extends Object> objects) {
        LinkedList<Integer> hashCodes = new LinkedList<Integer>();
        for (Object object : objects) {
            hashCodes.add(System.identityHashCode(object));
        }
        return hashCodes;
    }

    public static byte[] decrypt(byte[] bytes, String hexKey) throws NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec key = new SecretKeySpec(Utilities.toByteArray(hexKey), "DESede");
        try {
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(2, key);
            return cipher.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PropertyDescriptor[] getProperties(Class<?> cls) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(cls);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Unable to introspect " + cls.getName(), e);
        }
    }

    private static <T> T newInstance(Class<?> clazz, Class<T> interfaceType, Object ... args) {
        T t;
        Object obj;
        Constructor<?> constructor = Utilities.resolveConstructor(clazz, args);
        if (constructor == null) {
            throw new IllegalArgumentException("constructor not found: " + clazz.getName() + "#" + Utilities.classesString(args, false));
        }
        try {
            obj = constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("cannot instantiate class: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot access constructor of class: " + clazz.getName(), e);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            throw new IllegalArgumentException(ite);
        }
        try {
            t = interfaceType.cast(obj);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("cannot cast new instance of " + clazz.getName() + " to interface type " + interfaceType.getName());
        }
        return t;
    }

    public static <T> T newInstance(String cls, Class<T> interfaceType, Object ... args) {
        Class<?> clazz;
        try {
            clazz = Class.forName(cls);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("class not found: " + cls, e);
        }
        return Utilities.newInstance(clazz, interfaceType, args);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        return Utilities.newInstance(clazz, clazz, args);
    }

    public static String replaceFirst(String string, String oldString, String newString) {
        int i;
        String result = string;
        if (string != null && (i = string.indexOf(oldString)) >= 0) {
            result = string.substring(0, i) + newString;
            if (i + oldString.length() < string.length() - 1) {
                result = result + string.substring(i + oldString.length());
            }
        }
        return result;
    }

    public static URL asURL(Class<?> clazz) {
        int pkg = clazz.getPackage() == null ? 0 : clazz.getPackage().getName().length() + 1;
        String className = clazz.getName().substring(pkg);
        String resourceName = className.replace('.', '$') + ".class";
        URL url = clazz.getResource(resourceName);
        return url;
    }

    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(object);
            os.flush();
            os.close();
            byte[] bytes = bos.toByteArray();
            return bytes;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot replicate object of type " + object.getClass().getName(), e);
        }
    }

    public static <T> T deserialize(byte[] bytes, final ClassLoader classloader, Class<T> cls) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            final HashMap<String, Class<Object>> primClasses = new HashMap<String, Class<Object>>(8, 1.0f);
            primClasses.put("boolean", Boolean.TYPE);
            primClasses.put("byte", Byte.TYPE);
            primClasses.put("char", Character.TYPE);
            primClasses.put("short", Short.TYPE);
            primClasses.put("int", Integer.TYPE);
            primClasses.put("long", Long.TYPE);
            primClasses.put("float", Float.TYPE);
            primClasses.put("double", Double.TYPE);
            primClasses.put("void", Void.TYPE);
            ObjectInputStream is = new ObjectInputStream(bis){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, classloader);
                    }
                    catch (ClassNotFoundException ex) {
                        Class cl = (Class)primClasses.get(name);
                        if (cl != null) {
                            return cl;
                        }
                        throw ex;
                    }
                }
            };
            Object t = is.readObject();
            is.close();
            return (T)t;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot replicate object of type " + cls.getName(), e);
        }
    }

    public static <T> T replicate(T object, ClassLoader classloader) {
        if (object == null) {
            return null;
        }
        byte[] bytes = Utilities.serialize(object);
        Class<?> cls = object.getClass();
        return (T)Utilities.deserialize(bytes, classloader, cls);
    }

    private static String changeNewlines(String string, String newline) {
        string = string.replaceAll(CR, "");
        string = string.replaceAll(LF, newline);
        return string;
    }

    public static String unixEncode(String string) {
        return Utilities.changeNewlines(string, LF);
    }

    public static String dosEncode(String string) {
        return Utilities.changeNewlines(string, CRLF);
    }

    public static String platformEncode(String string) {
        return Utilities.changeNewlines(string, System.getProperty("line.separator"));
    }

    public static String toString(byte[] bytes, String encoding) {
        String string;
        try {
            string = new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Illegal encoding: " + encoding);
        }
        return string;
    }

    public static byte[] getBytes(String string, String encoding) {
        byte[] bytes;
        try {
            bytes = string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Illegal encoding: " + encoding);
        }
        return bytes;
    }

    private static double getHue(int idx, double initialAngle) {
        int ridx = 0;
        int i = 0;
        while (i < 31) {
            ++i;
            ridx = ridx << 1 | idx & 1;
            idx >>>= 1;
        }
        return initialAngle + 1.0 * (double)ridx / -2.147483648E9;
    }

    public static Color getColor(int i, float initialAngle, float saturation, float brightness) {
        double hue = Utilities.getHue(i, initialAngle);
        Color color = Color.getHSBColor((float)hue, saturation, brightness);
        return color;
    }

    public static String getRGBString(int i, float initialAngle, float saturation, float brightness) {
        Color color = Utilities.getColor(i, initialAngle, saturation, brightness);
        return String.format("%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static synchronized String getKey(String className, String methodName, String b) {
        String key = keys.get(b);
        if (key == null) {
            try {
                CL cl = new CL();
                ByteArrayInputStream stream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)b));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utilities.pipe(stream, out);
                out.flush();
                out.close();
                byte[] code = out.toByteArray();
                cl.addClass(className, code);
                Class<?> klass = cl.loadClass(className);
                Method method = klass.getMethod(methodName, new Class[0]);
                key = (String)method.invoke(null, (Object[])null);
                keys.put(b, key);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot read the key", e);
            }
        }
        return key;
    }

    public static int max(int ... nums) {
        if (nums.length == 0) {
            throw new IllegalArgumentException("no numbers provided to compute maximum of");
        }
        int max = Integer.MIN_VALUE;
        for (int n : nums) {
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public static int min(int ... nums) {
        if (nums.length == 0) {
            throw new IllegalArgumentException("no numbers provided to compute minimum of");
        }
        int min = Integer.MAX_VALUE;
        for (int n : nums) {
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public static Map<String, Object> toMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyDescriptor prop : Utilities.getProperties(bean.getClass())) {
            if (prop.getReadMethod() == null) continue;
            try {
                Object value = prop.getReadMethod().invoke(bean, new Object[0]);
                map.put(prop.getName(), value);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
        return map;
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = System.getProperty("line.separator");
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    public static long hash64(String string) {
        long h = 0L;
        for (int i = 0; i < string.length(); ++i) {
            h = 63L * h + (long)string.charAt(i);
        }
        return h;
    }

    public static Color decodeColor(String colorString) {
        Color color = null;
        if (colorString != null) {
            try {
                color = Color.decode(colorString);
            }
            catch (NumberFormatException e) {
                try {
                    Field field = Color.class.getField(colorString.toLowerCase());
                    if (field != null) {
                        return (Color)field.get(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return color;
    }

    public static <T1, T2> Iterable<Pair<T1, T2>> pairs(final Iterable<T1> i1, final Iterable<T2> i2) {
        return new Iterable<Pair<T1, T2>>(){

            @Override
            public Iterator<Pair<T1, T2>> iterator() {
                return new Iterator<Pair<T1, T2>>(){
                    private Iterator<T1> ii1;
                    private Iterator<T2> ii2;
                    {
                        this.ii1 = i1.iterator();
                        this.ii2 = i2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.ii1.hasNext() & this.ii2.hasNext();
                    }

                    @Override
                    public Pair<T1, T2> next() {
                        return Utilities.pair(this.ii1.next(), this.ii2.next());
                    }

                    @Override
                    public void remove() {
                        this.ii1.remove();
                        this.ii2.remove();
                    }
                };
            }
        };
    }

    static {
        primitiveClasses.put(Integer.TYPE, Integer.class);
        primitiveClasses.put(Boolean.TYPE, Boolean.class);
        primitiveClasses.put(Character.TYPE, Character.class);
        primitiveClasses.put(Byte.TYPE, Byte.class);
        primitiveClasses.put(Short.TYPE, Short.class);
        primitiveClasses.put(Long.TYPE, Long.class);
        primitiveClasses.put(Float.TYPE, Float.class);
        primitiveClasses.put(Double.TYPE, Double.class);
        keys = new HashMap<String, String>();
    }

    private static abstract class MyFileFilter
    extends FileFilter {
        String suffix;

        private MyFileFilter() {
        }
    }

    protected static class CL
    extends ClassLoader {
        private HashMap<String, byte[]> classes = new HashMap();

        CL() {
            super(CL.class.getClassLoader());
        }

        public void addClass(String name, byte[] code) {
            this.classes.put(name, code);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                byte[] code = this.classes.remove(name);
                Class<?> clazz = this.defineClass(name, code, 0, code.length);
                return clazz;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ClassNotFoundException(t.getMessage());
            }
        }
    }
}

