/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VFlowLayout
implements LayoutManager {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    private int gap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public VFlowLayout() {
        this(0);
    }

    public VFlowLayout(int v) {
        this.gap = v;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.countComponents();
        Dimension d = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                d = c.preferredSize();
                this.minWidth = Math.max(c.minimumSize().width, this.minWidth);
                this.preferredWidth = Math.max(c.preferredSize().width, this.preferredWidth);
                this.minHeight += c.minimumSize().height + this.gap;
                this.preferredHeight += c.preferredSize().height + this.gap;
            }
            ++i;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.countComponents();
        this.setSizes(parent);
        Insets insets = parent.insets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.countComponents();
        this.setSizes(parent);
        Insets insets = parent.insets();
        dim.width = this.minWidth + insets.left + insets.right;
        dim.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.insets();
        int maxWidth = parent.size().width - (insets.left + insets.right);
        int maxHeight = parent.size().height - (insets.top + insets.bottom);
        int nComps = parent.countComponents();
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        int previousWidth = 0;
        int previousHeight = 0;
        boolean x = false;
        int y = insets.top + this.gap / 2;
        boolean rowh = false;
        boolean start = false;
        int yFudge = 0;
        boolean oneColumn = false;
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        if (maxHeight > this.preferredHeight) {
            yFudge = (maxHeight - this.preferredHeight) / nComps;
        }
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.preferredSize();
                y = i != 0 ? (y += previousHeight + yFudge + this.gap) : (y += previousHeight + (yFudge + this.gap) / 2);
                c.reshape(0, y, maxWidth, d.height);
                previousWidth = d.width;
                previousHeight = d.height;
            }
            ++i;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[gap=" + this.gap + "]";
    }
}

