/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.io.IOException;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPControl;

public class RTPPushDataSource
extends PushDataSource {
    PushSourceStream outputstream;
    OutputDataStream inputstream;
    String contentType = null;
    private boolean connected = false;
    private boolean started = false;
    DataSource childsrc = null;
    private RTPControl rtpcontrol = null;

    public RTPPushDataSource() {
        Class<?> eClass = null;
        try {
            eClass = Class.forName("com.sun.media.rtp.RTPControlImpl");
            this.rtpcontrol = (RTPControl)eClass.newInstance();
        }
        catch (Exception e) {
            this.rtpcontrol = null;
        }
    }

    public void setChild(DataSource source) {
        this.childsrc = source;
    }

    public PushSourceStream getOutputStream() {
        return this.outputstream;
    }

    public OutputDataStream getInputStream() {
        return this.inputstream;
    }

    public void setOutputStream(PushSourceStream outputstream) {
        this.outputstream = outputstream;
    }

    public void setInputStream(OutputDataStream inputstream) {
        this.inputstream = inputstream;
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return ContentDescriptor.mimeTypeToPackageName(this.contentType);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void connect() throws IOException {
        this.connected = true;
        if (this.childsrc != null) {
            this.childsrc.connect();
        }
    }

    public void disconnect() {
        this.connected = false;
        if (this.childsrc != null) {
            this.childsrc.disconnect();
        }
    }

    protected void initCheck() {
    }

    public void start() throws IOException {
        if (!this.connected) {
            return;
        }
        this.started = true;
        if (this.childsrc != null) {
            this.childsrc.start();
        }
    }

    public void stop() throws IOException {
        if (!this.connected && !this.started) {
            return;
        }
        this.started = false;
        if (this.childsrc != null) {
            this.childsrc.stop();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public Object[] getControls() {
        Object[] controls = new RTPControl[]{this.rtpcontrol};
        return controls;
    }

    public Object getControl(String controlName) {
        if (controlName.equals("javax.media.rtp.RTPControl")) {
            return this.rtpcontrol;
        }
        return null;
    }

    public Time getDuration() {
        return null;
    }

    public PushSourceStream[] getStreams() {
        PushSourceStream[] outstream = new PushSourceStream[]{this.outputstream};
        return outstream;
    }
}

