/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class CachedTargets {
    static String[] typeString = new String[]{"GEO_TARGETS", "ENV_TARGETS", "BEH_TARGETS", "SND_TARGETS", "VPF_TARGETS", "BLN_TARGETS", "GRP_TARGETS"};
    static int[] updateTargetThreads = new int[]{8384, 4224, 256, 514, 898, 4992, 8256};
    NnuId[][] targetArr = new NnuId[7][];

    CachedTargets() {
    }

    int computeTargetThreads() {
        int n = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.targetArr[i] == null) continue;
            n |= updateTargetThreads[i];
        }
        return n;
    }

    void copy(CachedTargets cachedTargets) {
        for (int i = 0; i < 7; ++i) {
            this.targetArr[i] = cachedTargets.targetArr[i];
        }
    }

    void replace(NnuId nnuId, NnuId nnuId2, int n) {
        NnuId[] nnuIdArray = new NnuId[this.targetArr[n].length];
        System.arraycopy(this.targetArr[n], 0, nnuIdArray, 0, this.targetArr[n].length);
        this.targetArr[n] = nnuIdArray;
        NnuIdManager.replace(nnuId, nnuId2, this.targetArr[n]);
    }

    void dump() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetArr[i] == null) continue;
            System.err.println("  " + typeString[i]);
            for (int j = 0; j < this.targetArr[i].length; ++j) {
                System.err.println("  " + this.targetArr[i][j]);
            }
        }
    }
}

