/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultUserPreferences;
import com.eteks.sweethome3d.io.HomeContentContext;
import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HomeXMLHandler
extends DefaultHandler {
    private HomeContentContext contentContext;
    private UserPreferences preferences;
    private Home home;
    private final StringBuilder buffer = new StringBuilder();
    private final Stack<String> elements = new Stack();
    private final Stack<Map<String, String>> attributes = new Stack();
    private final Stack<List<HomePieceOfFurniture>> groupsFurniture = new Stack();
    private final Stack<Map<String, String>> properties = new Stack();
    private final Stack<Map<String, TextStyle>> textStyles = new Stack();
    private final Map<String, Level> levels = new HashMap<String, Level>();
    private final Map<String, JoinedWall> joinedWalls = new HashMap<String, JoinedWall>();
    private String homeElementName;
    private String labelText;
    private Baseboard leftSideBaseboard;
    private Baseboard rightSideBaseboard;
    private BackgroundImage homeBackgroundImage;
    private BackgroundImage backgroundImage;
    private final Map<String, HomeTexture> textures = new HashMap<String, HomeTexture>();
    private final List<HomeMaterial> materials = new ArrayList<HomeMaterial>();
    private final List<Transformation> transformations = new ArrayList<Transformation>();
    private HomeTexture materialTexture;
    private final List<Sash> sashes = new ArrayList<Sash>();
    private final List<LightSource> lightSources = new ArrayList<LightSource>();
    private final List<float[]> points = new ArrayList<float[]>();
    private final List<HomePieceOfFurniture.SortableProperty> furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>();
    private static final String UNIQUE_ATTRIBUTE = "@&unique&@";

    public HomeXMLHandler() {
        this(null);
    }

    public HomeXMLHandler(UserPreferences userPreferences) {
        this.preferences = userPreferences != null ? userPreferences : new DefaultUserPreferences(false, null);
    }

    void setContentContext(HomeContentContext homeContentContext) {
        this.contentContext = homeContentContext;
    }

    @Override
    public void startDocument() throws SAXException {
        this.home = null;
        this.elements.clear();
        this.attributes.clear();
        this.groupsFurniture.clear();
        this.levels.clear();
        this.joinedWalls.clear();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.buffer.setLength(0);
        this.elements.push(string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            hashMap.put(attributes.getQName(i), attributes.getValue(i));
        }
        this.attributes.push(hashMap);
        if (!("property".equals(string3) || "furnitureVisibleProperty".equals(string3) || "textStyle".equals(string3))) {
            this.properties.push(new HashMap());
            this.textStyles.push(new HashMap());
        }
        if ("home".equals(string3)) {
            this.setHome(this.createHome(string3, hashMap));
            this.furnitureVisibleProperties.clear();
            this.homeBackgroundImage = null;
        } else if ("environment".equals(string3)) {
            this.textures.clear();
        } else if ("level".equals(string3)) {
            this.backgroundImage = null;
        } else if ("pieceOfFurniture".equals(string3) || "doorOrWindow".equals(string3) || "light".equals(string3) || "furnitureGroup".equals(string3)) {
            this.textures.clear();
            this.materials.clear();
            this.transformations.clear();
            this.sashes.clear();
            this.lightSources.clear();
            if ("furnitureGroup".equals(string3)) {
                this.groupsFurniture.push(new ArrayList());
            }
        } else if ("room".equals(string3)) {
            this.textures.clear();
            this.points.clear();
        } else if ("polyline".equals(string3)) {
            this.points.clear();
        } else if ("label".equals(string3)) {
            this.labelText = null;
        } else if ("wall".equals(string3)) {
            this.textures.clear();
            this.leftSideBaseboard = null;
            this.rightSideBaseboard = null;
        } else if ("baseboard".equals(string3)) {
            this.textures.remove(UNIQUE_ATTRIBUTE);
        } else if ("material".equals(string3)) {
            this.materialTexture = null;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.elements.pop();
        String string4 = this.elements.isEmpty() ? null : this.elements.peek();
        Map<String, String> map = this.attributes.pop();
        if (this.homeElementName != null && this.homeElementName.equals(string3)) {
            this.setHomeAttributes(this.home, string3, map);
        } else if ("furnitureVisibleProperty".equals(string3)) {
            try {
                if (map.get("name") == null) {
                    throw new SAXException("Missing name attribute");
                }
                this.furnitureVisibleProperties.add(HomePieceOfFurniture.SortableProperty.valueOf(map.get("name")));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if ("environment".equals(string3)) {
            this.setEnvironmentAttributes(this.home.getEnvironment(), string3, map);
        } else if ("compass".equals(string3)) {
            this.setCompassAttributes(this.home.getCompass(), string3, map);
        } else if ("print".equals(string3)) {
            this.home.setPrint(this.createPrint(map));
        } else if ("level".equals(string3)) {
            Level level = this.createLevel(string3, map);
            this.setLevelAttributes(level, string3, map);
            this.levels.put(map.get("id"), level);
            this.home.addLevel(level);
        } else if ("camera".equals(string3) || "observerCamera".equals(string3)) {
            Camera camera = this.createCamera(string3, map);
            this.setCameraAttributes(camera, string3, map);
            String string5 = map.get("attribute");
            if ("cameraPath".equals(string5)) {
                ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getEnvironment().getVideoCameraPath());
                arrayList.add(camera);
                this.home.getEnvironment().setVideoCameraPath(arrayList);
            } else if ("topCamera".equals(string5)) {
                Camera camera2 = this.home.getTopCamera();
                camera2.setCamera(camera);
                camera2.setTime(camera.getTime());
                camera2.setLens(camera.getLens());
            } else if ("observerCamera".equals(string5)) {
                ObserverCamera observerCamera = this.home.getObserverCamera();
                observerCamera.setCamera(camera);
                observerCamera.setTime(camera.getTime());
                observerCamera.setLens(camera.getLens());
                observerCamera.setFixedSize(((ObserverCamera)camera).isFixedSize());
            } else if ("storedCamera".equals(string5)) {
                ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getStoredCameras());
                arrayList.add(camera);
                this.home.setStoredCameras(arrayList);
            }
        } else if ("pieceOfFurniture".equals(string3) || "doorOrWindow".equals(string3) || "light".equals(string3) || "furnitureGroup".equals(string3)) {
            HomePieceOfFurniture homePieceOfFurniture = "furnitureGroup".equals(string3) ? this.createFurnitureGroup(string3, map, this.groupsFurniture.pop()) : this.createPieceOfFurniture(string3, map);
            this.setPieceOfFurnitureAttributes(homePieceOfFurniture, string3, map);
            if (this.homeElementName != null && this.homeElementName.equals(string4)) {
                this.home.addPieceOfFurniture(homePieceOfFurniture);
                String string6 = map.get("level");
                if (string6 != null) {
                    homePieceOfFurniture.setLevel(this.levels.get(string6));
                }
            } else if ("furnitureGroup".equals(string4)) {
                this.groupsFurniture.peek().add(homePieceOfFurniture);
            }
        } else if ("wall".equals(string3)) {
            Wall wall = this.createWall(string3, map);
            this.joinedWalls.put(map.get("id"), new JoinedWall(wall, map.get("wallAtStart"), map.get("wallAtEnd")));
            this.setWallAttributes(wall, string3, map);
            this.home.addWall(wall);
            String string7 = map.get("level");
            if (string7 != null) {
                wall.setLevel(this.levels.get(string7));
            }
        } else if ("baseboard".equals(string3)) {
            Baseboard baseboard = this.createBaseboard(string3, map);
            if ("leftSideBaseboard".equals(map.get("attribute"))) {
                this.leftSideBaseboard = baseboard;
            } else {
                this.rightSideBaseboard = baseboard;
            }
        } else if ("room".equals(string3)) {
            Room room = this.createRoom(string3, map, (float[][])this.points.toArray((T[])new float[this.points.size()][]));
            this.setRoomAttributes(room, string3, map);
            this.home.addRoom(room);
            String string8 = map.get("level");
            if (string8 != null) {
                room.setLevel(this.levels.get(string8));
            }
        } else if ("polyline".equals(string3)) {
            Polyline polyline = this.createPolyline(string3, map, (float[][])this.points.toArray((T[])new float[this.points.size()][]));
            this.setPolylineAttributes(polyline, string3, map);
            this.home.addPolyline(polyline);
            String string9 = map.get("level");
            if (string9 != null) {
                polyline.setLevel(this.levels.get(string9));
            }
        } else if ("dimensionLine".equals(string3)) {
            DimensionLine dimensionLine = this.createDimensionLine(string3, map);
            this.setDimensionLineAttributes(dimensionLine, string3, map);
            this.home.addDimensionLine(dimensionLine);
            String string10 = map.get("level");
            if (string10 != null) {
                dimensionLine.setLevel(this.levels.get(string10));
            }
        } else if ("label".equals(string3)) {
            Label label = this.createLabel(string3, map, this.labelText);
            this.setLabelAttributes(label, string3, map);
            this.home.addLabel(label);
            String string11 = map.get("level");
            if (string11 != null) {
                label.setLevel(this.levels.get(string11));
            }
        } else if ("text".equals(string3)) {
            this.labelText = this.getCharacters();
        } else if ("textStyle".equals(string3)) {
            String string12;
            this.textStyles.peek().put((string12 = map.get("attribute")) != null ? string12 : UNIQUE_ATTRIBUTE, this.createTextStyle(string3, map));
        } else if ("texture".equals(string3)) {
            if ("material".equals(string4)) {
                this.materialTexture = this.createTexture(string3, map);
            } else {
                String string13 = map.get("attribute");
                this.textures.put(string13 != null ? string13 : UNIQUE_ATTRIBUTE, this.createTexture(string3, map));
            }
        } else if ("material".equals(string3)) {
            this.materials.add(this.createMaterial(string3, map));
        } else if ("transformation".equals(string3)) {
            String string14 = map.get("matrix");
            if (string14 == null) {
                throw new SAXException("Missing attribute matrix");
            }
            String[] stringArray = string14.split(" ", 12);
            if (stringArray.length < 12) {
                throw new SAXException("Missing values for attribute matrix");
            }
            try {
                float[][] fArrayArray = new float[][]{{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])}, {Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5]), Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7])}, {Float.parseFloat(stringArray[8]), Float.parseFloat(stringArray[9]), Float.parseFloat(stringArray[10]), Float.parseFloat(stringArray[11])}};
                Transformation transformation = new Transformation(map.get("name"), fArrayArray);
                this.transformations.add((Transformation)this.resolveObject(transformation, string3, map));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for attribute matrix", numberFormatException);
            }
        } else if ("point".equals(string3)) {
            this.points.add(new float[]{this.parseFloat(map, "x"), this.parseFloat(map, "y")});
        } else if ("sash".equals(string3)) {
            Sash sash = new Sash(this.parseFloat(map, "xAxis"), this.parseFloat(map, "yAxis"), this.parseFloat(map, "width"), this.parseFloat(map, "startAngle"), this.parseFloat(map, "endAngle"));
            this.sashes.add((Sash)this.resolveObject(sash, string3, map));
        } else if ("lightSource".equals(string3)) {
            LightSource lightSource = new LightSource(this.parseFloat(map, "x"), this.parseFloat(map, "y"), this.parseFloat(map, "z"), this.parseOptionalColor(map, "color"), this.parseOptionalFloat(map, "diameter"));
            this.lightSources.add((LightSource)this.resolveObject(lightSource, string3, map));
        } else if ("backgroundImage".equals(string3)) {
            BackgroundImage backgroundImage = new BackgroundImage(this.parseContent(map.get("image"), null, false), this.parseFloat(map, "scaleDistance"), this.parseFloat(map, "scaleDistanceXStart"), this.parseFloat(map, "scaleDistanceYStart"), this.parseFloat(map, "scaleDistanceXEnd"), this.parseFloat(map, "scaleDistanceYEnd"), map.get("xOrigin") != null ? this.parseFloat(map, "xOrigin") : 0.0f, map.get("yOrigin") != null ? this.parseFloat(map, "yOrigin") : 0.0f, !"false".equals(map.get("visible")));
            backgroundImage = (BackgroundImage)this.resolveObject(backgroundImage, string3, map);
            if (this.homeElementName != null && this.homeElementName.equals(string4)) {
                this.homeBackgroundImage = backgroundImage;
            } else {
                this.backgroundImage = backgroundImage;
            }
        } else if ("property".equals(string3) && this.homeElementName != null) {
            this.properties.peek().put(map.get("name"), map.get("value"));
        }
        if (!("property".equals(string3) || "furnitureVisibleProperty".equals(string3) || "textStyle".equals(string3))) {
            this.properties.pop();
            this.textStyles.pop();
        }
    }

    private String getCharacters() {
        return this.buffer.toString();
    }

    @Override
    public void endDocument() throws SAXException {
        for (JoinedWall joinedWall : this.joinedWalls.values()) {
            JoinedWall joinedWall2;
            Wall wall = joinedWall.getWall();
            if (joinedWall.getWallAtStartId() != null && (joinedWall2 = this.joinedWalls.get(joinedWall.getWallAtStartId())) != null) {
                wall.setWallAtStart(joinedWall2.getWall());
            }
            if (joinedWall.getWallAtEndId() == null || (joinedWall2 = this.joinedWalls.get(joinedWall.getWallAtEndId())) == null) continue;
            wall.setWallAtEnd(joinedWall2.getWall());
        }
    }

    protected Object resolveObject(Object object, String string, Map<String, String> map) {
        return object;
    }

    private Home createHome(String string, Map<String, String> map) throws SAXException {
        Home home = map.get("wallHeight") != null ? new Home(this.parseFloat(map, "wallHeight")) : new Home();
        String string2 = map.get("version");
        if (string2 != null) {
            try {
                home.setVersion(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for integer attribute version", numberFormatException);
            }
        }
        return (Home)this.resolveObject(home, string, map);
    }

    protected void setHomeAttributes(Home home, String string, Map<String, String> map) throws SAXException {
        for (Map.Entry<String, String> object2 : this.properties.peek().entrySet()) {
            home.setProperty(object2.getKey(), object2.getValue());
        }
        if (this.furnitureVisibleProperties.size() > 0) {
            this.home.setFurnitureVisibleProperties(this.furnitureVisibleProperties);
        }
        this.home.setBackgroundImage(this.homeBackgroundImage);
        home.setName(map.get("name"));
        String string2 = map.get("selectedLevel");
        if (string2 != null) {
            this.home.setSelectedLevel(this.levels.get(string2));
        }
        if ("observerCamera".equals(map.get("camera"))) {
            this.home.setCamera(this.home.getObserverCamera());
        }
        home.setBasePlanLocked("true".equals(map.get("basePlanLocked")));
        String string3 = map.get("furnitureSortedProperty");
        if (string3 != null) {
            try {
                home.setFurnitureSortedProperty(HomePieceOfFurniture.SortableProperty.valueOf(string3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        home.setFurnitureDescendingSorted("true".equals(map.get("furnitureDescendingSorted")));
    }

    private void setEnvironmentAttributes(HomeEnvironment homeEnvironment, String string, Map<String, String> map) throws SAXException {
        Integer n;
        Float f;
        Integer n2;
        String string2;
        Integer n3;
        Integer n4;
        String string3;
        Integer n5;
        Integer n6;
        Float f2;
        String string4;
        Float f3;
        Integer n7 = this.parseOptionalColor(map, "groundColor");
        if (n7 != null) {
            homeEnvironment.setGroundColor(n7);
        }
        homeEnvironment.setGroundTexture(this.textures.get("groundTexture"));
        homeEnvironment.setBackgroundImageVisibleOnGround3D("true".equals(map.get("backgroundImageVisibleOnGround3D")));
        Integer n8 = this.parseOptionalColor(map, "skyColor");
        if (n8 != null) {
            homeEnvironment.setSkyColor(n8);
        }
        homeEnvironment.setSkyTexture(this.textures.get("skyTexture"));
        Integer n9 = this.parseOptionalColor(map, "lightColor");
        if (n9 != null) {
            homeEnvironment.setLightColor(n9);
        }
        if ((f3 = this.parseOptionalFloat(map, "wallsAlpha")) != null) {
            homeEnvironment.setWallsAlpha(f3.floatValue());
        }
        homeEnvironment.setAllLevelsVisible("true".equals(map.get("allLevelsVisible")));
        homeEnvironment.setObserverCameraElevationAdjusted(!"false".equals(map.get("observerCameraElevationAdjusted")));
        Integer n10 = this.parseOptionalColor(map, "ceillingLightColor");
        if (n10 != null) {
            homeEnvironment.setCeillingLightColor(n10);
        }
        if ((string4 = map.get("drawingMode")) != null) {
            try {
                homeEnvironment.setDrawingMode(HomeEnvironment.DrawingMode.valueOf(string4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((f2 = this.parseOptionalFloat(map, "subpartSizeUnderLight")) != null) {
            homeEnvironment.setSubpartSizeUnderLight(f2.floatValue());
        }
        if ((n6 = this.parseOptionalInteger(map, "photoWidth")) != null) {
            homeEnvironment.setPhotoWidth(n6);
        }
        if ((n5 = this.parseOptionalInteger(map, "photoHeight")) != null) {
            homeEnvironment.setPhotoHeight(n5);
        }
        if ((string3 = map.get("photoAspectRatio")) != null) {
            try {
                homeEnvironment.setPhotoAspectRatio(AspectRatio.valueOf(string3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((n4 = this.parseOptionalInteger(map, "photoQuality")) != null) {
            homeEnvironment.setPhotoQuality(n4);
        }
        if ((n3 = this.parseOptionalInteger(map, "videoWidth")) != null) {
            homeEnvironment.setVideoWidth(n3);
        }
        if ((string2 = map.get("videoAspectRatio")) != null) {
            try {
                homeEnvironment.setVideoAspectRatio(AspectRatio.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((n2 = this.parseOptionalInteger(map, "videoQuality")) != null) {
            homeEnvironment.setVideoQuality(n2);
        }
        if ((f = this.parseOptionalFloat(map, "videoSpeed")) != null) {
            homeEnvironment.setVideoSpeed(f.floatValue());
        }
        if ((n = this.parseOptionalInteger(map, "videoFrameRate")) != null) {
            homeEnvironment.setVideoFrameRate(n);
        }
    }

    protected HomePrint createPrint(Map<String, String> map) throws SAXException {
        HomePrint.PaperOrientation paperOrientation = HomePrint.PaperOrientation.PORTRAIT;
        try {
            if (map.get("paperOrientation") == null) {
                throw new SAXException("Missing paperOrientation attribute");
            }
            paperOrientation = HomePrint.PaperOrientation.valueOf(map.get("paperOrientation"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        HomePrint homePrint = new HomePrint(paperOrientation, this.parseFloat(map, "paperWidth"), this.parseFloat(map, "paperHeight"), this.parseFloat(map, "paperTopMargin"), this.parseFloat(map, "paperLeftMargin"), this.parseFloat(map, "paperBottomMargin"), this.parseFloat(map, "paperRightMargin"), !"false".equals(map.get("furniturePrinted")), !"false".equals(map.get("planPrinted")), !"false".equals(map.get("view3DPrinted")), this.parseOptionalFloat(map, "planScale"), map.get("headerFormat"), map.get("footerFormat"));
        return (HomePrint)this.resolveObject(homePrint, "print", map);
    }

    protected void setCompassAttributes(Compass compass, String string, Map<String, String> map) throws SAXException {
        String string2;
        Float f;
        Float f2;
        this.setProperties(compass);
        compass.setX(this.parseOptionalFloat(map, "x").floatValue());
        compass.setY(this.parseOptionalFloat(map, "y").floatValue());
        compass.setDiameter(this.parseOptionalFloat(map, "diameter").floatValue());
        Float f3 = this.parseOptionalFloat(map, "northDirection");
        if (f3 != null) {
            compass.setNorthDirection(f3.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "longitude")) != null) {
            compass.setLongitude(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "latitude")) != null) {
            compass.setLatitude(f.floatValue());
        }
        if ((string2 = map.get("timeZone")) != null) {
            compass.setTimeZone(string2);
        }
        compass.setVisible(!"false".equals(map.get("visible")));
    }

    private Camera createCamera(String string, Map<String, String> map) throws SAXException {
        Camera camera = "observerCamera".equals(string) ? new ObserverCamera(this.parseFloat(map, "x"), this.parseFloat(map, "y"), this.parseFloat(map, "z"), this.parseFloat(map, "yaw"), this.parseFloat(map, "pitch"), this.parseFloat(map, "fieldOfView")) : new Camera(this.parseFloat(map, "x"), this.parseFloat(map, "y"), this.parseFloat(map, "z"), this.parseFloat(map, "yaw"), this.parseFloat(map, "pitch"), this.parseFloat(map, "fieldOfView"));
        return (Camera)this.resolveObject(camera, string, map);
    }

    protected void setCameraAttributes(Camera camera, String string, Map<String, String> map) throws SAXException {
        String string2;
        String string3;
        this.setProperties(camera);
        if (camera instanceof ObserverCamera) {
            ((ObserverCamera)camera).setFixedSize("true".equals(map.get("fixedSize")));
        }
        if ((string3 = map.get("lens")) != null) {
            try {
                camera.setLens(Camera.Lens.valueOf(string3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string2 = map.get("time")) != null) {
            try {
                camera.setTime(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for long attribute time", numberFormatException);
            }
        }
        camera.setName(map.get("name"));
    }

    private Level createLevel(String string, Map<String, String> map) throws SAXException {
        Level level = new Level(map.get("name"), this.parseFloat(map, "elevation"), this.parseFloat(map, "floorThickness"), this.parseFloat(map, "height"));
        return (Level)this.resolveObject(level, string, map);
    }

    protected void setLevelAttributes(Level level, String string, Map<String, String> map) throws SAXException {
        this.setProperties(level);
        level.setBackgroundImage(this.backgroundImage);
        Integer n = this.parseOptionalInteger(map, "elevationIndex");
        if (n != null) {
            level.setElevationIndex(n);
        }
        level.setVisible(!"false".equals(map.get("visible")));
        level.setViewable(!"false".equals(map.get("viewable")));
    }

    private HomePieceOfFurniture createPieceOfFurniture(String string, Map<String, String> map) throws SAXException {
        Object object;
        String string2 = map.get("catalogId");
        String[] stringArray = map.get("tags") != null ? map.get("tags").split(" ") : null;
        float f = map.get("elevation") != null ? this.parseFloat(map, "elevation") : 0.0f;
        float f2 = map.get("dropOnTopElevation") != null ? this.parseFloat(map, "dropOnTopElevation") : 1.0f;
        float[][] fArrayArray = null;
        if (map.get("modelRotation") != null) {
            object = map.get("modelRotation").split(" ", 9);
            if (((String[])object).length < 9) {
                throw new SAXException("Missing values for attribute modelRotation");
            }
            try {
                fArrayArray = new float[][]{{Float.parseFloat(object[0]), Float.parseFloat(object[1]), Float.parseFloat(object[2])}, {Float.parseFloat(object[3]), Float.parseFloat(object[4]), Float.parseFloat(object[5])}, {Float.parseFloat(object[6]), Float.parseFloat(object[7]), Float.parseFloat(object[8])}};
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for attribute modelRotation", numberFormatException);
            }
        }
        if ("doorOrWindow".equals(string) || "true".equals(map.get("doorOrWindow"))) {
            float f3 = map.get("wallThickness") != null ? this.parseFloat(map, "wallThickness") : 1.0f;
            float f4 = map.get("wallDistance") != null ? this.parseFloat(map, "wallDistance") : 0.0f;
            String string3 = map.get("cutOutShape");
            if (string3 == null && !"doorOrWindow".equals(string)) {
                string3 = "M0,0 v1 h1 v-1 z";
            }
            object = new HomeDoorOrWindow(new CatalogDoorOrWindow(string2, map.get("name"), map.get("description"), map.get("information"), stringArray, this.parseOptionalLong(map, "creationDate"), this.parseOptionalFloat(map, "grade"), this.parseContent(map.get("icon"), string2, false), this.parseContent(map.get("planIcon"), string2, false), this.parseContent(map.get("model"), string2, false), this.parseFloat(map, "width"), this.parseFloat(map, "depth"), this.parseFloat(map, "height"), f, f2, !"false".equals(map.get("movable")), string3, f3, f4, "true".equals(map.get("wallCutOutOnBothSides")), !"false".equals(map.get("widthDepthDeformable")), this.sashes.toArray(new Sash[this.sashes.size()]), fArrayArray, "true".equals(map.get("backFaceShown")), this.parseOptionalLong(map, "modelSize"), map.get("creator"), !"false".equals(map.get("resizable")), !"false".equals(map.get("deformable")), !"false".equals(map.get("texturable")), this.parseOptionalDecimal(map, "price"), this.parseOptionalDecimal(map, "valueAddedTaxPercentage"), map.get("currency")));
        } else {
            object = "light".equals(string) ? new HomeLight(new CatalogLight(string2, map.get("name"), map.get("description"), map.get("information"), stringArray, this.parseOptionalLong(map, "creationDate"), this.parseOptionalFloat(map, "grade"), this.parseContent(map.get("icon"), string2, false), this.parseContent(map.get("planIcon"), string2, false), this.parseContent(map.get("model"), string2, false), this.parseFloat(map, "width"), this.parseFloat(map, "depth"), this.parseFloat(map, "height"), f, f2, !"false".equals(map.get("movable")), this.lightSources.toArray(new LightSource[this.lightSources.size()]), map.get("staircaseCutOutShape"), fArrayArray, "true".equals(map.get("backFaceShown")), this.parseOptionalLong(map, "modelSize"), map.get("creator"), !"false".equals(map.get("resizable")), !"false".equals(map.get("deformable")), !"false".equals(map.get("texturable")), !"false".equals(map.get("horizontallyRotatable")), this.parseOptionalDecimal(map, "price"), this.parseOptionalDecimal(map, "valueAddedTaxPercentage"), map.get("currency"))) : new HomePieceOfFurniture(new CatalogPieceOfFurniture(string2, map.get("name"), map.get("description"), map.get("information"), stringArray, this.parseOptionalLong(map, "creationDate"), this.parseOptionalFloat(map, "grade"), this.parseContent(map.get("icon"), string2, false), this.parseContent(map.get("planIcon"), string2, false), this.parseContent(map.get("model"), string2, false), this.parseFloat(map, "width"), this.parseFloat(map, "depth"), this.parseFloat(map, "height"), f, f2, !"false".equals(map.get("movable")), map.get("staircaseCutOutShape"), fArrayArray, "true".equals(map.get("backFaceShown")), this.parseOptionalLong(map, "modelSize"), map.get("creator"), !"false".equals(map.get("resizable")), !"false".equals(map.get("deformable")), !"false".equals(map.get("texturable")), !"false".equals(map.get("horizontallyRotatable")), this.parseOptionalDecimal(map, "price"), this.parseOptionalDecimal(map, "valueAddedTaxPercentage"), map.get("currency")));
        }
        return (HomePieceOfFurniture)this.resolveObject(object, string, map);
    }

    private HomeFurnitureGroup createFurnitureGroup(String string, Map<String, String> map, List<HomePieceOfFurniture> list) throws SAXException {
        HomeFurnitureGroup homeFurnitureGroup = new HomeFurnitureGroup(list, map.get("angle") != null ? this.parseFloat(map, "angle") : 0.0f, "true".equals(map.get("modelMirrored")), map.get("name"));
        return (HomeFurnitureGroup)this.resolveObject(homeFurnitureGroup, string, map);
    }

    protected void setPieceOfFurnitureAttributes(HomePieceOfFurniture homePieceOfFurniture, String string, Map<String, String> map) throws SAXException {
        Float f;
        Float f2;
        this.setProperties(homePieceOfFurniture);
        homePieceOfFurniture.setNameStyle(this.textStyles.peek().get("nameStyle"));
        homePieceOfFurniture.setNameVisible("true".equals(map.get("nameVisible")));
        Float f3 = this.parseOptionalFloat(map, "nameAngle");
        if (f3 != null) {
            homePieceOfFurniture.setNameAngle(f3.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "nameXOffset")) != null) {
            homePieceOfFurniture.setNameXOffset(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "nameYOffset")) != null) {
            homePieceOfFurniture.setNameYOffset(f.floatValue());
        }
        homePieceOfFurniture.setVisible(!"false".equals(map.get("visible")));
        if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) {
            Float f4;
            Serializable serializable;
            Serializable serializable2;
            Float f5;
            Float f6;
            Float f7;
            Float f8;
            Float f9;
            Float f10 = this.parseOptionalFloat(map, "x");
            if (f10 != null) {
                homePieceOfFurniture.setX(f10.floatValue());
            }
            if ((f9 = this.parseOptionalFloat(map, "y")) != null) {
                homePieceOfFurniture.setY(f9.floatValue());
            }
            if ((f8 = this.parseOptionalFloat(map, "angle")) != null) {
                homePieceOfFurniture.setAngle(f8.floatValue());
            }
            if (homePieceOfFurniture.isHorizontallyRotatable()) {
                f7 = this.parseOptionalFloat(map, "pitch");
                if (f7 != null) {
                    homePieceOfFurniture.setPitch(f7.floatValue());
                }
                if ((f6 = this.parseOptionalFloat(map, "roll")) != null) {
                    homePieceOfFurniture.setRoll(f6.floatValue());
                }
            }
            if ((f7 = this.parseOptionalFloat(map, "widthInPlan")) != null) {
                homePieceOfFurniture.setWidthInPlan(f7.floatValue());
            }
            if ((f6 = this.parseOptionalFloat(map, "depthInPlan")) != null) {
                homePieceOfFurniture.setDepthInPlan(f6.floatValue());
            }
            if ((f5 = this.parseOptionalFloat(map, "heightInPlan")) != null) {
                homePieceOfFurniture.setHeightInPlan(f5.floatValue());
            }
            if (this.home.getVersion() < 5500L || "false".equals(map.get("modelCenteredAtOrigin"))) {
                homePieceOfFurniture.setModelCenteredAtOrigin(map.get("modelRotation") == null);
            }
            if (homePieceOfFurniture.isResizable()) {
                homePieceOfFurniture.setModelMirrored("true".equals(map.get("modelMirrored")));
            }
            if (homePieceOfFurniture.isTexturable()) {
                if (this.materials.size() > 0) {
                    homePieceOfFurniture.setModelMaterials(this.materials.toArray(new HomeMaterial[this.materials.size()]));
                }
                if ((serializable2 = this.parseOptionalColor(map, "color")) != null) {
                    homePieceOfFurniture.setColor((Integer)serializable2);
                }
                if ((serializable = this.textures.get(UNIQUE_ATTRIBUTE)) != null) {
                    homePieceOfFurniture.setTexture((HomeTexture)serializable);
                }
                if ((f4 = this.parseOptionalFloat(map, "shininess")) != null) {
                    homePieceOfFurniture.setShininess(f4);
                }
            }
            if (homePieceOfFurniture.isDeformable() && this.transformations.size() > 0) {
                homePieceOfFurniture.setModelTransformations(this.transformations.toArray(new Transformation[this.transformations.size()]));
            }
            if (homePieceOfFurniture instanceof HomeLight && map.get("power") != null) {
                ((HomeLight)homePieceOfFurniture).setPower(this.parseFloat(map, "power"));
            } else if (homePieceOfFurniture instanceof HomeDoorOrWindow && "doorOrWindow".equals(string)) {
                Float f11;
                Float f12;
                serializable2 = (HomeDoorOrWindow)homePieceOfFurniture;
                ((HomeDoorOrWindow)serializable2).setBoundToWall(!"false".equals(map.get("boundToWall")));
                serializable = this.parseOptionalFloat(map, "wallWidth");
                if (serializable != null) {
                    ((HomeDoorOrWindow)serializable2).setWallWidth(((Float)serializable).floatValue());
                }
                if ((f4 = this.parseOptionalFloat(map, "wallLeft")) != null) {
                    ((HomeDoorOrWindow)serializable2).setWallLeft(f4.floatValue());
                }
                if ((f12 = this.parseOptionalFloat(map, "wallHeight")) != null) {
                    ((HomeDoorOrWindow)serializable2).setWallHeight(f12.floatValue());
                }
                if ((f11 = this.parseOptionalFloat(map, "wallTop")) != null) {
                    ((HomeDoorOrWindow)serializable2).setWallTop(f11.floatValue());
                }
            }
        }
    }

    private Wall createWall(String string, Map<String, String> map) throws SAXException {
        Wall wall = new Wall(this.parseFloat(map, "xStart"), this.parseFloat(map, "yStart"), this.parseFloat(map, "xEnd"), this.parseFloat(map, "yEnd"), this.parseFloat(map, "thickness"), 0.0f);
        return (Wall)this.resolveObject(wall, string, map);
    }

    protected void setWallAttributes(Wall wall, String string, Map<String, String> map) throws SAXException {
        String string2;
        this.setProperties(wall);
        wall.setLeftSideBaseboard(this.leftSideBaseboard);
        wall.setRightSideBaseboard(this.rightSideBaseboard);
        wall.setHeight(this.parseOptionalFloat(map, "height"));
        wall.setHeightAtEnd(this.parseOptionalFloat(map, "heightAtEnd"));
        wall.setArcExtent(this.parseOptionalFloat(map, "arcExtent"));
        wall.setTopColor(this.parseOptionalColor(map, "topColor"));
        wall.setLeftSideColor(this.parseOptionalColor(map, "leftSideColor"));
        wall.setLeftSideTexture(this.textures.get("leftSideTexture"));
        Float f = this.parseOptionalFloat(map, "leftSideShininess");
        if (f != null) {
            wall.setLeftSideShininess(f.floatValue());
        }
        wall.setRightSideColor(this.parseOptionalColor(map, "rightSideColor"));
        wall.setRightSideTexture(this.textures.get("rightSideTexture"));
        Float f2 = this.parseOptionalFloat(map, "rightSideShininess");
        if (f2 != null) {
            wall.setRightSideShininess(f2.floatValue());
        }
        if ((string2 = map.get("pattern")) != null) {
            try {
                wall.setPattern(this.preferences.getPatternsCatalog().getPattern(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private Room createRoom(String string, Map<String, String> map, float[][] fArray) {
        Room room = new Room(fArray);
        return (Room)this.resolveObject(room, string, map);
    }

    protected void setRoomAttributes(Room room, String string, Map<String, String> map) throws SAXException {
        Float f;
        Float f2;
        Float f3;
        Float f4;
        this.setProperties(room);
        room.setNameStyle(this.textStyles.peek().get("nameStyle"));
        room.setAreaStyle(this.textStyles.peek().get("areaStyle"));
        room.setName(map.get("name"));
        Float f5 = this.parseOptionalFloat(map, "nameAngle");
        if (f5 != null) {
            room.setNameAngle(f5.floatValue());
        }
        if ((f4 = this.parseOptionalFloat(map, "nameXOffset")) != null) {
            room.setNameXOffset(f4.floatValue());
        }
        if ((f3 = this.parseOptionalFloat(map, "nameYOffset")) != null) {
            room.setNameYOffset(f3.floatValue());
        }
        room.setAreaVisible("true".equals(map.get("areaVisible")));
        Float f6 = this.parseOptionalFloat(map, "areaAngle");
        if (f6 != null) {
            room.setAreaAngle(f6.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "areaXOffset")) != null) {
            room.setAreaXOffset(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "areaYOffset")) != null) {
            room.setAreaYOffset(f.floatValue());
        }
        room.setFloorVisible(!"false".equals(map.get("floorVisible")));
        room.setFloorColor(this.parseOptionalColor(map, "floorColor"));
        room.setFloorTexture(this.textures.get("floorTexture"));
        Float f7 = this.parseOptionalFloat(map, "floorShininess");
        if (f7 != null) {
            room.setFloorShininess(f7.floatValue());
        }
        room.setCeilingVisible(!"false".equals(map.get("ceilingVisible")));
        room.setCeilingColor(this.parseOptionalColor(map, "ceilingColor"));
        room.setCeilingTexture(this.textures.get("ceilingTexture"));
        Float f8 = this.parseOptionalFloat(map, "ceilingShininess");
        if (f8 != null) {
            room.setCeilingShininess(f8.floatValue());
        }
    }

    private Polyline createPolyline(String string, Map<String, String> map, float[][] fArray) {
        Polyline polyline = new Polyline(fArray);
        return (Polyline)this.resolveObject(polyline, string, map);
    }

    protected void setPolylineAttributes(Polyline polyline, String string, Map<String, String> map) throws SAXException {
        Integer n;
        Float f;
        String string2;
        Object object;
        Object object2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.setProperties(polyline);
        Float f2 = this.parseOptionalFloat(map, "thickness");
        if (f2 != null) {
            polyline.setThickness(f2.floatValue());
        }
        if ((string6 = map.get("capStyle")) != null) {
            try {
                polyline.setCapStyle(Polyline.CapStyle.valueOf(string6));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string5 = map.get("joinStyle")) != null) {
            try {
                polyline.setJoinStyle(Polyline.JoinStyle.valueOf(string5));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string4 = map.get("dashStyle")) != null) {
            try {
                polyline.setDashStyle(Polyline.DashStyle.valueOf(string4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string3 = map.get("dashPattern")) != null) {
            try {
                object2 = string3.split(" ");
                object = new float[((String[])object2).length];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object[i] = Float.parseFloat((String)object2[i]);
                }
                polyline.setDashPattern((float[])object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for dash pattern", numberFormatException);
            }
        }
        if ((object2 = this.parseOptionalFloat(map, "dashOffset")) != null) {
            polyline.setDashOffset(((Float)object2).floatValue());
        }
        if ((object = (Object)map.get("startArrowStyle")) != null) {
            try {
                polyline.setStartArrowStyle(Polyline.ArrowStyle.valueOf((String)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string2 = map.get("endArrowStyle")) != null) {
            try {
                polyline.setEndArrowStyle(Polyline.ArrowStyle.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((f = this.parseOptionalFloat(map, "elevation")) != null) {
            polyline.setVisibleIn3D(true);
            polyline.setElevation(f.floatValue());
        }
        if ((n = this.parseOptionalColor(map, "color")) != null) {
            polyline.setColor(n);
        }
        polyline.setClosedPath("true".equals(map.get("closedPath")));
    }

    private DimensionLine createDimensionLine(String string, Map<String, String> map) throws SAXException {
        DimensionLine dimensionLine = new DimensionLine(this.parseFloat(map, "xStart"), this.parseFloat(map, "yStart"), this.parseFloat(map, "xEnd"), this.parseFloat(map, "yEnd"), this.parseFloat(map, "offset"));
        return (DimensionLine)this.resolveObject(dimensionLine, string, map);
    }

    protected void setDimensionLineAttributes(DimensionLine dimensionLine, String string, Map<String, String> map) throws SAXException {
        this.setProperties(dimensionLine);
        dimensionLine.setLengthStyle(this.textStyles.peek().get("lengthStyle"));
    }

    private Label createLabel(String string, Map<String, String> map, String string2) throws SAXException {
        Label label = new Label(string2, this.parseFloat(map, "x"), this.parseFloat(map, "y"));
        return (Label)this.resolveObject(label, string, map);
    }

    protected void setLabelAttributes(Label label, String string, Map<String, String> map) throws SAXException {
        Float f;
        Float f2;
        this.setProperties(label);
        label.setStyle(this.textStyles.peek().get(UNIQUE_ATTRIBUTE));
        Float f3 = this.parseOptionalFloat(map, "angle");
        if (f3 != null) {
            label.setAngle(f3.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "elevation")) != null) {
            label.setElevation(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "pitch")) != null) {
            label.setPitch(f);
        }
        label.setColor(this.parseOptionalColor(map, "color"));
        label.setOutlineColor(this.parseOptionalColor(map, "outlineColor"));
    }

    private Baseboard createBaseboard(String string, Map<String, String> map) throws SAXException {
        Baseboard baseboard = Baseboard.getInstance(this.parseFloat(map, "thickness"), this.parseFloat(map, "height"), this.parseOptionalColor(map, "color"), this.textures.get(UNIQUE_ATTRIBUTE));
        return (Baseboard)this.resolveObject(baseboard, string, map);
    }

    private TextStyle createTextStyle(String string, Map<String, String> map) throws SAXException {
        TextStyle.Alignment alignment = TextStyle.Alignment.CENTER;
        String string2 = map.get("alignment");
        if (string2 != null) {
            try {
                alignment = TextStyle.Alignment.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        TextStyle textStyle = new TextStyle(map.get("fontName"), this.parseFloat(map, "fontSize"), "true".equals(map.get("bold")), "true".equals(map.get("italic")), alignment);
        return (TextStyle)this.resolveObject(textStyle, string, map);
    }

    private HomeTexture createTexture(String string, Map<String, String> map) throws SAXException {
        String string2 = map.get("catalogId");
        HomeTexture homeTexture = new HomeTexture(new CatalogTexture(string2, map.get("name"), this.parseContent(map.get("image"), string2, true), this.parseFloat(map, "width"), this.parseFloat(map, "height"), map.get("creator")), map.get("xOffset") != null ? this.parseFloat(map, "xOffset") : 0.0f, map.get("yOffset") != null ? this.parseFloat(map, "yOffset") : 0.0f, map.get("angle") != null ? this.parseFloat(map, "angle") : 0.0f, map.get("scale") != null ? this.parseFloat(map, "scale") : 1.0f, !"false".equals(map.get("leftToRightOriented")));
        return (HomeTexture)this.resolveObject(homeTexture, string, map);
    }

    private HomeMaterial createMaterial(String string, Map<String, String> map) throws SAXException {
        HomeMaterial homeMaterial = new HomeMaterial(map.get("name"), map.get("key"), this.parseOptionalColor(map, "color"), this.materialTexture, this.parseOptionalFloat(map, "shininess"));
        return (HomeMaterial)this.resolveObject(homeMaterial, string, map);
    }

    private void setProperties(HomeObject homeObject) {
        for (Map.Entry<String, String> entry : this.properties.peek().entrySet()) {
            homeObject.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Integer parseOptionalColor(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return (int)Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for color attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private Integer parseOptionalInteger(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for integer attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private Long parseOptionalLong(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for long attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private BigDecimal parseOptionalDecimal(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for decimal attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private Float parseOptionalFloat(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Float.valueOf(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for float attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private float parseFloat(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for float attribute " + string, numberFormatException);
            }
        }
        throw new SAXException("Missing float attribute " + string);
    }

    private Content parseContent(String string, String string2, boolean bl) throws SAXException {
        if (string != null) {
            try {
                return new ResourceURLContent(new URL(string), string.startsWith("jar:"));
            }
            catch (MalformedURLException malformedURLException) {
                if (this.contentContext != null) {
                    try {
                        return this.contentContext.lookupContent(string);
                    }
                    catch (IOException iOException) {
                        throw new SAXException("Invalid content " + string, iOException);
                    }
                }
                if (string2 != null && this.preferences != null) {
                    if (bl) {
                        for (TexturesCategory texturesCategory : this.preferences.getTexturesCatalog().getCategories()) {
                            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                                if (!string2.equals(catalogTexture.getId()) || !this.isSameContent(string, catalogTexture.getIcon())) continue;
                                return catalogTexture.getIcon();
                            }
                        }
                    } else {
                        for (FurnitureCategory furnitureCategory : this.preferences.getFurnitureCatalog().getCategories()) {
                            for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                                if (!string2.equals(catalogPieceOfFurniture.getId())) continue;
                                if (this.isSameContent(string, catalogPieceOfFurniture.getIcon())) {
                                    return catalogPieceOfFurniture.getIcon();
                                }
                                if (this.isSameContent(string, catalogPieceOfFurniture.getPlanIcon())) {
                                    return catalogPieceOfFurniture.getPlanIcon();
                                }
                                if (!this.isSameContent(string, catalogPieceOfFurniture.getModel())) continue;
                                return catalogPieceOfFurniture.getModel();
                            }
                        }
                    }
                }
                throw new SAXException("Missing URL base", malformedURLException);
            }
        }
        return null;
    }

    private boolean isSameContent(String string, Content content) {
        if (content instanceof ResourceURLContent) {
            ResourceURLContent resourceURLContent = (ResourceURLContent)content;
            return resourceURLContent.isJAREntry() && resourceURLContent.getJAREntryName().equals(string) || !resourceURLContent.isJAREntry() && resourceURLContent.getURL().toString().endsWith("/" + string);
        }
        return false;
    }

    protected void setHome(Home home) {
        this.home = home;
        this.homeElementName = this.elements.peek();
    }

    public Home getHome() {
        return this.home;
    }

    private static final class JoinedWall {
        private final Wall wall;
        private final String wallAtStartId;
        private final String wallAtEndId;

        public JoinedWall(Wall wall, String string, String string2) {
            this.wall = wall;
            this.wallAtStartId = string;
            this.wallAtEndId = string2;
        }

        public Wall getWall() {
            return this.wall;
        }

        public String getWallAtStartId() {
            return this.wallAtStartId;
        }

        public String getWallAtEndId() {
            return this.wallAtEndId;
        }
    }
}

