/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public class HomeLight
extends HomePieceOfFurniture
implements Light {
    private static final long serialVersionUID = 1L;
    private final LightSource[] lightSources;
    private float power;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public HomeLight(Light light) {
        super(light);
        this.lightSources = light.getLightSources();
        this.power = 0.5f;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public LightSource[] getLightSources() {
        if (this.lightSources.length == 0) {
            return this.lightSources;
        }
        return (LightSource[])this.lightSources.clone();
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        if (f != this.power) {
            float f2 = this.power;
            this.power = f;
            this.propertyChangeSupport.firePropertyChange(Property.POWER.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    @Override
    public HomeLight clone() {
        HomeLight homeLight = (HomeLight)super.clone();
        homeLight.propertyChangeSupport = new PropertyChangeSupport(homeLight);
        return homeLight;
    }

    public static enum Property {
        POWER;

    }
}

