/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.writers;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sunflow.image.BitmapWriter;
import org.sunflow.image.Color;
import org.sunflow.image.ColorEncoder;

public class TGABitmapWriter
implements BitmapWriter {
    private String filename;
    private int width;
    private int height;
    private byte[] data;

    public void configure(String string, String string2) {
    }

    public void openFile(String string) throws IOException {
        this.filename = string;
    }

    public void writeHeader(int n, int n2, int n3) throws IOException, UnsupportedOperationException {
        this.width = n;
        this.height = n2;
        this.data = new byte[n * n2 * 4];
    }

    public void writeTile(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) throws IOException {
        colorArray = ColorEncoder.unlinearize(colorArray);
        byte[] byArray = ColorEncoder.quantizeRGBA8(colorArray, fArray);
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = 4 * (n + (this.height - 1 - (n2 + i)) * this.width);
            int n7 = 0;
            while (n7 < n3) {
                this.data[n6 + 0] = byArray[n5 + 2];
                this.data[n6 + 1] = byArray[n5 + 1];
                this.data[n6 + 2] = byArray[n5 + 0];
                this.data[n6 + 3] = byArray[n5 + 3];
                ++n7;
                n5 += 4;
                n6 += 4;
            }
        }
    }

    public void closeFile() throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.filename));
        byte[] byArray = new byte[]{0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((OutputStream)bufferedOutputStream).write(byArray);
        ((OutputStream)bufferedOutputStream).write(this.width & 0xFF);
        ((OutputStream)bufferedOutputStream).write(this.width >> 8 & 0xFF);
        ((OutputStream)bufferedOutputStream).write(this.height & 0xFF);
        ((OutputStream)bufferedOutputStream).write(this.height >> 8 & 0xFF);
        ((OutputStream)bufferedOutputStream).write(32);
        ((OutputStream)bufferedOutputStream).write(0);
        ((OutputStream)bufferedOutputStream).write(this.data);
        ((OutputStream)bufferedOutputStream).close();
    }
}

